/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.util.Log;
import android.util.TypedValue;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.mozglue.DirectBufferAllocator;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;

public final class ThumbnailHelper {
    private static final String LOGTAG = "GeckoThumbnailHelper";
    public static final float THUMBNAIL_ASPECT_RATIO = 0.571f;
    private static ThumbnailHelper sInstance;
    private final LinkedList<Tab> mPendingThumbnails;
    private AtomicInteger mPendingWidth;
    private int mWidth;
    private int mHeight;
    private ByteBuffer mBuffer;
    private final float mThumbnailAspectRatio;

    public static synchronized ThumbnailHelper getInstance() {
        if (sInstance == null) {
            sInstance = new ThumbnailHelper();
        }
        return sInstance;
    }

    private ThumbnailHelper() {
        Resources resources = GeckoAppShell.getContext().getResources();
        TypedValue typedValue = new TypedValue();
        resources.getValue(R.dimen.thumbnail_aspect_ratio, typedValue, true);
        this.mThumbnailAspectRatio = typedValue.getFloat();
        this.mPendingThumbnails = new LinkedList();
        try {
            this.mPendingWidth = new AtomicInteger((int)resources.getDimension(R.dimen.tab_thumbnail_width));
        }
        catch (Resources.NotFoundException notFoundException) {
            this.mPendingWidth = new AtomicInteger(0);
        }
        this.mWidth = -1;
        this.mHeight = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAndProcessThumbnailFor(Tab tab) {
        if (AboutPages.isAboutHome(tab.getURL())) {
            tab.updateThumbnail(null, CachePolicy.NO_STORE);
            return;
        }
        LinkedList<Tab> linkedList = this.mPendingThumbnails;
        synchronized (linkedList) {
            if (this.mPendingThumbnails.lastIndexOf(tab) > 0) {
                return;
            }
            this.mPendingThumbnails.add(tab);
            if (this.mPendingThumbnails.size() > 1) {
                return;
            }
        }
        this.requestThumbnailFor(tab);
    }

    public void setThumbnailWidth(int n) {
        if (GeckoAppShell.getScreenDepth() == 24) {
            this.mPendingWidth.set(n);
        } else {
            this.mPendingWidth.set((n & 1) == 0 ? n : n + 1);
        }
    }

    private void updateThumbnailSize() {
        this.mWidth = this.mPendingWidth.get();
        this.mHeight = Math.round((float)this.mWidth * this.mThumbnailAspectRatio);
        int n = GeckoAppShell.getScreenDepth() == 24 ? 4 : 2;
        int n2 = this.mWidth * this.mHeight * n;
        Log.d((String)LOGTAG, (String)("Using new thumbnail size: " + n2 + " (width " + this.mWidth + " - height " + this.mHeight + ")"));
        if (this.mBuffer == null || this.mBuffer.capacity() != n2) {
            if (this.mBuffer != null) {
                this.mBuffer = DirectBufferAllocator.free((ByteBuffer)this.mBuffer);
            }
            try {
                this.mBuffer = DirectBufferAllocator.allocate((int)n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)LOGTAG, (String)illegalArgumentException.toString());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)LOGTAG, (String)("Unable to allocate thumbnail buffer of capacity " + n2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestThumbnailFor(Tab tab) {
        this.updateThumbnailSize();
        if (this.mBuffer == null) {
            LinkedList<Tab> linkedList = this.mPendingThumbnails;
            synchronized (linkedList) {
                this.mPendingThumbnails.clear();
            }
            return;
        }
        Log.d((String)LOGTAG, (String)("Sending thumbnail event: " + this.mWidth + ", " + this.mHeight));
        GeckoEvent geckoEvent = GeckoEvent.createThumbnailEvent(tab.getId(), this.mWidth, this.mHeight, this.mBuffer);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    @WrapElementForJNI(stubName="SendThumbnail")
    public static void notifyThumbnail(ByteBuffer byteBuffer, int n, boolean bl, boolean bl2) {
        Tab tab = Tabs.getInstance().getTab(n);
        ThumbnailHelper thumbnailHelper = ThumbnailHelper.getInstance();
        if (bl && tab != null) {
            thumbnailHelper.handleThumbnailData(tab, byteBuffer, bl2 ? CachePolicy.STORE : CachePolicy.NO_STORE);
        }
        thumbnailHelper.processNextThumbnail(tab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextThumbnail(Tab tab) {
        Tab tab2 = null;
        LinkedList<Tab> linkedList = this.mPendingThumbnails;
        synchronized (linkedList) {
            if (tab != null && tab != this.mPendingThumbnails.peek()) {
                Log.e((String)LOGTAG, (String)"handleThumbnailData called with unexpected tab's data!");
            } else {
                this.mPendingThumbnails.remove();
            }
            tab2 = this.mPendingThumbnails.peek();
        }
        if (tab2 != null) {
            this.requestThumbnailFor(tab2);
        }
    }

    private void handleThumbnailData(Tab tab, ByteBuffer byteBuffer, CachePolicy cachePolicy) {
        Log.d((String)LOGTAG, (String)("handleThumbnailData: " + byteBuffer.capacity()));
        if (byteBuffer != this.mBuffer) {
            Log.e((String)LOGTAG, (String)"handleThumbnailData called with an unexpected ByteBuffer!");
        }
        if (this.shouldUpdateThumbnail(tab)) {
            this.processThumbnailData(tab, byteBuffer, cachePolicy);
        }
    }

    private void processThumbnailData(Tab tab, ByteBuffer byteBuffer, CachePolicy cachePolicy) {
        Bitmap bitmap = tab.getThumbnailBitmap(this.mWidth, this.mHeight);
        byteBuffer.position(0);
        bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
        this.setTabThumbnail(tab, bitmap, null, cachePolicy);
    }

    private void setTabThumbnail(Tab tab, Bitmap bitmap, byte[] byArray, CachePolicy cachePolicy) {
        if (bitmap == null) {
            if (byArray == null) {
                Log.w((String)LOGTAG, (String)"setTabThumbnail: one of bitmap or compressed must be non-null!");
                return;
            }
            bitmap = BitmapUtils.decodeByteArray(byArray);
        }
        tab.updateThumbnail(bitmap, cachePolicy);
    }

    private boolean shouldUpdateThumbnail(Tab tab) {
        return Tabs.getInstance().isSelectedTab(tab) || GeckoAppShell.getGeckoInterface() != null && GeckoAppShell.getGeckoInterface().areTabsShown();
    }

    public static enum CachePolicy {
        STORE,
        NO_STORE;

    }
}

