/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.net.Uri;
import org.mozilla.gecko.mozglue.RobocopTarget;

@RobocopTarget
public class BrowserContract {
    public static final String AUTHORITY = "org.mozilla.fennec.db.browser";
    public static final Uri AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.browser");
    public static final String PASSWORDS_AUTHORITY = "org.mozilla.fennec.db.passwords";
    public static final Uri PASSWORDS_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.passwords");
    public static final String FORM_HISTORY_AUTHORITY = "org.mozilla.fennec.db.formhistory";
    public static final Uri FORM_HISTORY_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.formhistory");
    public static final String TABS_AUTHORITY = "org.mozilla.fennec.db.tabs";
    public static final Uri TABS_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.tabs");
    public static final String HOME_AUTHORITY = "org.mozilla.fennec.db.home";
    public static final Uri HOME_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.home");
    public static final String PROFILES_AUTHORITY = "org.mozilla.fennec.profiles";
    public static final Uri PROFILES_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.profiles");
    public static final String READING_LIST_AUTHORITY = "org.mozilla.fennec.db.readinglist";
    public static final Uri READING_LIST_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.readinglist");
    public static final String SEARCH_HISTORY_AUTHORITY = "org.mozilla.fennec.db.searchhistory";
    public static final Uri SEARCH_HISTORY_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.searchhistory");
    public static final String PARAM_PROFILE = "profile";
    public static final String PARAM_PROFILE_PATH = "profilePath";
    public static final String PARAM_LIMIT = "limit";
    public static final String PARAM_IS_SYNC = "sync";
    public static final String PARAM_SHOW_DELETED = "show_deleted";
    public static final String PARAM_IS_TEST = "test";
    public static final String PARAM_INSERT_IF_NEEDED = "insert_if_needed";
    public static final String PARAM_INCREMENT_VISITS = "increment_visits";
    public static final String PARAM_EXPIRE_PRIORITY = "priority";
    public static final String PARAM_DATASET_ID = "dataset_id";

    public static String getFrecencySortOrder(boolean bl, boolean bl2) {
        String string2 = "(date - " + System.currentTimeMillis() + ") / 86400000";
        StringBuilder stringBuilder = new StringBuilder("visits * MAX(1, 100 * 225 / (" + string2 + "*" + string2 + " + 225)) ");
        if (bl) {
            stringBuilder.insert(0, "(CASE WHEN bookmark_id > -1 THEN 100 ELSE 0 END) + ");
        }
        stringBuilder.append(bl2 ? " ASC" : " DESC");
        return stringBuilder.toString();
    }

    @RobocopTarget
    public static final class SuggestedSites
    implements CommonColumns,
    URLColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"suggestedsites");

        private SuggestedSites() {
        }
    }

    @RobocopTarget
    public static final class SearchHistory
    implements CommonColumns,
    HistoryColumns {
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/searchhistory";
        public static final String QUERY = "query";
        public static final String TABLE_NAME = "searchhistory";
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)SEARCH_HISTORY_AUTHORITY_URI, (String)"searchhistory");

        private SearchHistory() {
        }
    }

    @RobocopTarget
    public static final class TopSites
    implements CommonColumns,
    URLColumns {
        public static final int TYPE_BLANK = 0;
        public static final int TYPE_TOP = 1;
        public static final int TYPE_PINNED = 2;
        public static final int TYPE_SUGGESTED = 3;
        public static final String BOOKMARK_ID = "bookmark_id";
        public static final String HISTORY_ID = "history_id";
        public static final String TYPE = "type";

        private TopSites() {
        }
    }

    @RobocopTarget
    public static final class ReadingListItems
    implements CommonColumns,
    URLColumns {
        public static final String EXCERPT = "excerpt";
        public static final String CLIENT_LAST_MODIFIED = "client_last_modified";
        public static final String GUID = "guid";
        public static final String SERVER_LAST_MODIFIED = "last_modified";
        public static final String SERVER_STORED_ON = "stored_on";
        public static final String ADDED_ON = "added_on";
        public static final String MARKED_READ_ON = "marked_read_on";
        public static final String IS_DELETED = "is_deleted";
        public static final String IS_ARCHIVED = "is_archived";
        public static final String IS_UNREAD = "is_unread";
        public static final String IS_ARTICLE = "is_article";
        public static final String IS_FAVORITE = "is_favorite";
        public static final String RESOLVED_URL = "resolved_url";
        public static final String RESOLVED_TITLE = "resolved_title";
        public static final String ADDED_BY = "added_by";
        public static final String MARKED_READ_BY = "marked_read_by";
        public static final String WORD_COUNT = "word_count";
        public static final String READ_POSITION = "read_position";
        public static final String CONTENT_STATUS = "content_status";
        public static final String SYNC_STATUS = "sync_status";
        public static final String SYNC_CHANGE_FLAGS = "sync_change_flags";
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)READING_LIST_AUTHORITY_URI, (String)"items");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/readinglistitem";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/readinglistitem";
        public static final int STATUS_UNFETCHED = 0;
        public static final int STATUS_FETCH_FAILED_TEMPORARY = 1;
        public static final int STATUS_FETCH_FAILED_PERMANENT = 2;
        public static final int STATUS_FETCH_FAILED_UNSUPPORTED_FORMAT = 3;
        public static final int STATUS_FETCHED_ARTICLE = 4;
        public static final int SYNC_STATUS_SYNCED = 0;
        public static final int SYNC_STATUS_NEW = 1;
        public static final int SYNC_STATUS_DELETED = 2;
        public static final int SYNC_STATUS_MODIFIED = 3;
        public static final int SYNC_CHANGE_NONE = 0;
        public static final int SYNC_CHANGE_UNREAD_CHANGED = 1;
        public static final int SYNC_CHANGE_FAVORITE_CHANGED = 2;
        public static final int SYNC_CHANGE_RESOLVED = 4;
        public static final String DEFAULT_SORT_ORDER = "client_last_modified DESC";
        public static final String[] DEFAULT_PROJECTION = new String[]{"_id", "url", "title", "excerpt", "word_count"};
        public static final String[] REQUIRED_FIELDS = new String[]{"url", "title"};
        public static final String[] ALL_FIELDS = new String[]{"_id", "url", "title", "excerpt", "client_last_modified", "guid", "last_modified", "stored_on", "added_on", "marked_read_on", "is_deleted", "is_archived", "is_unread", "is_article", "is_favorite", "resolved_url", "resolved_title", "added_by", "marked_read_by", "word_count", "read_position", "content_status", "sync_status", "sync_change_flags"};
        public static final String TABLE_NAME = "reading_list";

        private ReadingListItems() {
        }
    }

    @RobocopTarget
    public static final class HomeItems
    implements CommonColumns {
        public static final Uri CONTENT_FAKE_URI = Uri.withAppendedPath((Uri)HOME_AUTHORITY_URI, (String)"items/fake");
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)HOME_AUTHORITY_URI, (String)"items");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/homeitem";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/homeitem";
        public static final String DATASET_ID = "dataset_id";
        public static final String URL = "url";
        public static final String TITLE = "title";
        public static final String DESCRIPTION = "description";
        public static final String IMAGE_URL = "image_url";
        public static final String CREATED = "created";
        public static final String FILTER = "filter";
        public static final String[] DEFAULT_PROJECTION = new String[]{"_id", "dataset_id", "url", "title", "description", "image_url", "filter"};

        private HomeItems() {
        }
    }

    public static final class Clients {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)TABS_AUTHORITY_URI, (String)"clients");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/client";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/client";
        public static final String ROWID = "rowid";
        public static final String NAME = "name";
        public static final String GUID = "guid";
        public static final String LAST_MODIFIED = "last_modified";
        public static final String DEVICE_TYPE = "device_type";

        private Clients() {
        }
    }

    public static final class Tabs
    implements CommonColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)TABS_AUTHORITY_URI, (String)"tabs");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/tab";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/tab";
        public static final String TITLE = "title";
        public static final String URL = "url";
        public static final String CLIENT_GUID = "client_guid";
        public static final String HISTORY = "history";
        public static final String FAVICON = "favicon";
        public static final String LAST_USED = "last_used";
        public static final String POSITION = "position";

        private Tabs() {
        }
    }

    public static final class DeletedFormHistory
    implements DeletedColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)FORM_HISTORY_AUTHORITY_URI, (String)"deleted-formhistory");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/deleted-formhistory";

        private DeletedFormHistory() {
        }
    }

    public static final class FormHistory {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)FORM_HISTORY_AUTHORITY_URI, (String)"formhistory");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/formhistory";
        public static final String ID = "id";
        public static final String FIELD_NAME = "fieldname";
        public static final String VALUE = "value";
        public static final String TIMES_USED = "timesUsed";
        public static final String FIRST_USED = "firstUsed";
        public static final String LAST_USED = "lastUsed";
        public static final String GUID = "guid";

        private FormHistory() {
        }
    }

    public static final class DeletedPasswords
    implements DeletedColumns {
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/deleted-passwords";
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)PASSWORDS_AUTHORITY_URI, (String)"deleted-passwords");

        private DeletedPasswords() {
        }
    }

    public static final class Passwords {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)PASSWORDS_AUTHORITY_URI, (String)"passwords");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/passwords";
        public static final String ID = "id";
        public static final String HOSTNAME = "hostname";
        public static final String HTTP_REALM = "httpRealm";
        public static final String FORM_SUBMIT_URL = "formSubmitURL";
        public static final String USERNAME_FIELD = "usernameField";
        public static final String PASSWORD_FIELD = "passwordField";
        public static final String ENCRYPTED_USERNAME = "encryptedUsername";
        public static final String ENCRYPTED_PASSWORD = "encryptedPassword";
        public static final String ENC_TYPE = "encType";
        public static final String TIME_CREATED = "timeCreated";
        public static final String TIME_LAST_USED = "timeLastUsed";
        public static final String TIME_PASSWORD_CHANGED = "timePasswordChanged";
        public static final String TIMES_USED = "timesUsed";
        public static final String GUID = "guid";
        public static final int ENCTYPE_SDR = 1;

        private Passwords() {
        }
    }

    public static final class Schema {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"schema");
        public static final String VERSION = "version";

        private Schema() {
        }
    }

    @RobocopTarget
    public static final class Combined
    implements CommonColumns,
    URLColumns,
    HistoryColumns,
    FaviconColumns {
        public static final String VIEW_NAME = "combined";
        public static final String VIEW_WITH_FAVICONS = "combined_with_favicons";
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"combined");
        public static final String BOOKMARK_ID = "bookmark_id";
        public static final String HISTORY_ID = "history_id";

        private Combined() {
        }
    }

    @RobocopTarget
    public static final class History
    implements CommonColumns,
    URLColumns,
    HistoryColumns,
    FaviconColumns,
    SyncColumns {
        public static final String TABLE_NAME = "history";
        public static final String VIEW_WITH_FAVICONS = "history_with_favicons";
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"history");
        public static final Uri CONTENT_OLD_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"history/old");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/browser-history";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/browser-history";

        private History() {
        }
    }

    @RobocopTarget
    public static final class Bookmarks
    implements CommonColumns,
    URLColumns,
    FaviconColumns,
    SyncColumns {
        public static final String TABLE_NAME = "bookmarks";
        public static final String VIEW_WITH_FAVICONS = "bookmarks_with_favicons";
        public static final int FIXED_ROOT_ID = 0;
        public static final int FAKE_DESKTOP_FOLDER_ID = -1;
        public static final int FIXED_READING_LIST_ID = -2;
        public static final int FIXED_PINNED_LIST_ID = -3;
        public static final String MOBILE_FOLDER_GUID = "mobile";
        public static final String PLACES_FOLDER_GUID = "places";
        public static final String MENU_FOLDER_GUID = "menu";
        public static final String TAGS_FOLDER_GUID = "tags";
        public static final String TOOLBAR_FOLDER_GUID = "toolbar";
        public static final String UNFILED_FOLDER_GUID = "unfiled";
        public static final String FAKE_DESKTOP_FOLDER_GUID = "desktop";
        public static final String PINNED_FOLDER_GUID = "pinned";
        public static final int TYPE_FOLDER = 0;
        public static final int TYPE_BOOKMARK = 1;
        public static final int TYPE_SEPARATOR = 2;
        public static final int TYPE_LIVEMARK = 3;
        public static final int TYPE_QUERY = 4;
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"bookmarks");
        public static final Uri PARENTS_CONTENT_URI = Uri.withAppendedPath((Uri)CONTENT_URI, (String)"parents");
        public static final Uri POSITIONS_CONTENT_URI = Uri.withAppendedPath((Uri)CONTENT_URI, (String)"positions");
        public static final long DEFAULT_POSITION = Long.MIN_VALUE;
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/bookmark";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/bookmark";
        public static final String TYPE = "type";
        public static final String PARENT = "parent";
        public static final String POSITION = "position";
        public static final String TAGS = "tags";
        public static final String DESCRIPTION = "description";
        public static final String KEYWORD = "keyword";

        private Bookmarks() {
        }
    }

    public static final class Profiles {
        public static final String NAME = "name";
        public static final String PATH = "path";

        private Profiles() {
        }
    }

    @RobocopTarget
    public static final class Thumbnails
    implements CommonColumns {
        public static final String TABLE_NAME = "thumbnails";
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"thumbnails");
        public static final String URL = "url";
        public static final String DATA = "data";

        private Thumbnails() {
        }
    }

    @RobocopTarget
    public static final class Favicons
    implements CommonColumns,
    DateSyncColumns {
        public static final String TABLE_NAME = "favicons";
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"favicons");
        public static final String URL = "url";
        public static final String DATA = "data";
        public static final String PAGE_URL = "page_url";

        private Favicons() {
        }
    }

    public static interface DeletedColumns {
        public static final String ID = "id";
        public static final String GUID = "guid";
        public static final String TIME_DELETED = "timeDeleted";
    }

    @RobocopTarget
    public static interface HistoryColumns {
        public static final String DATE_LAST_VISITED = "date";
        public static final String VISITS = "visits";
    }

    @RobocopTarget
    public static interface FaviconColumns {
        public static final String FAVICON = "favicon";
        public static final String FAVICON_ID = "favicon_id";
        public static final String FAVICON_URL = "favicon_url";
    }

    @RobocopTarget
    public static interface URLColumns {
        public static final String URL = "url";
        public static final String TITLE = "title";
    }

    @RobocopTarget
    public static interface SyncColumns
    extends DateSyncColumns {
        public static final String GUID = "guid";
        public static final String IS_DELETED = "deleted";
    }

    @RobocopTarget
    public static interface DateSyncColumns {
        public static final String DATE_CREATED = "created";
        public static final String DATE_MODIFIED = "modified";
    }

    @RobocopTarget
    public static interface CommonColumns {
        public static final String _ID = "_id";
    }

    public static enum ExpirePriority {
        NORMAL,
        AGGRESSIVE;

    }
}

