/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.content.Context;
import android.content.Intent;
import java.util.Map;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractUpdateCredentialsActivity;
import org.mozilla.gecko.fxa.activities.FxAccountMigrationFinishedActivity;
import org.mozilla.gecko.fxa.login.State;

public class FxAccountFinishMigratingActivity
extends FxAccountAbstractUpdateCredentialsActivity {
    protected static final String LOG_TAG = FxAccountFinishMigratingActivity.class.getSimpleName();

    public FxAccountFinishMigratingActivity() {
        super(R.layout.fxaccount_finish_migrating);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.fxAccount = this.getAndroidFxAccount();
        if (this.fxAccount == null) {
            Logger.warn(LOG_TAG, "Could not get Firefox Account.");
            this.setResult(0);
            this.finish();
            return;
        }
        State state = this.fxAccount.getState();
        if (state.getStateLabel() != State.StateLabel.MigratedFromSync11) {
            Logger.warn(LOG_TAG, "Cannot finish migrating from Firefox Account in state: " + (Object)((Object)state.getStateLabel()));
            this.setResult(0);
            this.finish();
            return;
        }
        this.emailEdit.setText((CharSequence)this.fxAccount.getEmail());
    }

    @Override
    public Intent makeSuccessIntent(String string2, FxAccountClient20.LoginResponse loginResponse) {
        Intent intent = new Intent((Context)this, FxAccountMigrationFinishedActivity.class);
        intent.setFlags(65536);
        return intent;
    }

    @Override
    protected Map<String, String> getQueryParameters() {
        Map<String, String> map = super.getQueryParameters();
        map.put("migration", "sync11");
        return map;
    }
}

