/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.database.Cursor;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import org.mozilla.gecko.animation.TransitionsTracker;

public abstract class TransitionAwareCursorLoaderCallbacks
implements LoaderManager.LoaderCallbacks<Cursor> {
    private OnLoadFinishedRunnable onLoadFinishedRunnable;

    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        if (this.onLoadFinishedRunnable != null) {
            TransitionsTracker.cancelPendingAction(this.onLoadFinishedRunnable);
        }
        this.onLoadFinishedRunnable = new OnLoadFinishedRunnable(loader, cursor);
        TransitionsTracker.runAfterTransitions(this.onLoadFinishedRunnable);
    }

    protected abstract void onLoadFinishedAfterTransitions(Loader<Cursor> var1, Cursor var2);

    public void onLoaderReset(Loader<Cursor> loader) {
        if (this.onLoadFinishedRunnable != null) {
            TransitionsTracker.cancelPendingAction(this.onLoadFinishedRunnable);
            this.onLoadFinishedRunnable = null;
        }
    }

    private class OnLoadFinishedRunnable
    implements Runnable {
        private final Loader<Cursor> loader;
        private final Cursor cursor;

        public OnLoadFinishedRunnable(Loader<Cursor> loader, Cursor cursor) {
            this.loader = loader;
            this.cursor = cursor;
        }

        @Override
        public void run() {
            TransitionAwareCursorLoaderCallbacks.this.onLoadFinishedAfterTransitions(this.loader, this.cursor);
            TransitionAwareCursorLoaderCallbacks.this.onLoadFinishedRunnable = null;
        }
    }
}

