/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.service.sharemethods;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.LocalBrowserDB;
import org.mozilla.gecko.overlays.service.ShareData;
import org.mozilla.gecko.overlays.service.sharemethods.ShareMethod;

public class AddToReadingList
extends ShareMethod {
    private static final String LOGTAG = "GeckoAddToReadingList";

    @Override
    public ShareMethod.Result handle(ShareData shareData) {
        ContentResolver contentResolver = this.context.getContentResolver();
        ContentValues contentValues = new ContentValues();
        contentValues.put("title", shareData.title);
        contentValues.put("url", shareData.url);
        contentValues.put("added_on", Long.valueOf(System.currentTimeMillis()));
        contentValues.put("added_by", "$local");
        new LocalBrowserDB("default").getReadingListAccessor().addReadingListItem(contentResolver, contentValues);
        return ShareMethod.Result.SUCCESS;
    }

    @Override
    public String getSuccessMessage() {
        return this.context.getResources().getString(R.string.reading_list_added);
    }

    @Override
    public String getFailureMessage() {
        return null;
    }

    public AddToReadingList(Context context) {
        super(context);
    }
}

