/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.SharedPreferences;
import java.io.IOException;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.common.PrefsBranch;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.repositories.RepositorySessionBundle;

public class SynchronizerConfiguration {
    private static final String LOG_TAG = "SynczrConfiguration";
    public String syncID;
    public RepositorySessionBundle remoteBundle;
    public RepositorySessionBundle localBundle;

    public SynchronizerConfiguration(PrefsBranch prefsBranch) throws NonObjectJSONException, IOException, ParseException {
        this.load(prefsBranch);
    }

    public SynchronizerConfiguration(String string2, RepositorySessionBundle repositorySessionBundle, RepositorySessionBundle repositorySessionBundle2) {
        this.syncID = string2;
        this.remoteBundle = repositorySessionBundle;
        this.localBundle = repositorySessionBundle2;
    }

    public void load(PrefsBranch prefsBranch) throws NonObjectJSONException, IOException, ParseException {
        if (prefsBranch == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        String string2 = prefsBranch.getString("remote", null);
        String string3 = prefsBranch.getString("local", null);
        RepositorySessionBundle repositorySessionBundle = new RepositorySessionBundle(string2);
        RepositorySessionBundle repositorySessionBundle2 = new RepositorySessionBundle(string3);
        if (string2 == null) {
            repositorySessionBundle.setTimestamp(0L);
        }
        if (string3 == null) {
            repositorySessionBundle2.setTimestamp(0L);
        }
        this.syncID = prefsBranch.getString("syncID", null);
        this.remoteBundle = repositorySessionBundle;
        this.localBundle = repositorySessionBundle2;
        Logger.debug(LOG_TAG, "Loaded SynchronizerConfiguration. syncID: " + this.syncID + ", remoteBundle: " + this.remoteBundle + ", localBundle: " + this.localBundle);
    }

    public void persist(PrefsBranch prefsBranch) {
        if (prefsBranch == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        String string2 = this.remoteBundle.toJSONString();
        String string3 = this.localBundle.toJSONString();
        SharedPreferences.Editor editor = prefsBranch.edit();
        editor.putString("remote", string2);
        editor.putString("local", string3);
        editor.putString("syncID", this.syncID);
        editor.commit();
        Logger.debug(LOG_TAG, "Persisted SynchronizerConfiguration. syncID: " + this.syncID + ", remoteBundle: " + this.remoteBundle + ", localBundle: " + this.localBundle);
    }
}

