/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.HttpResponse;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.MozResponse;

public class SyncResponse
extends MozResponse {
    public SyncResponse(HttpResponse httpResponse) {
        super(httpResponse);
    }

    public int weaveBackoffInSeconds() throws NumberFormatException {
        return this.getIntegerHeader("x-weave-backoff");
    }

    public int xBackoffInSeconds() throws NumberFormatException {
        return this.getIntegerHeader("x-backoff");
    }

    public int totalBackoffInSeconds(boolean bl) {
        int n = -1;
        if (bl) {
            try {
                n = this.retryAfterInSeconds();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int n2 = -1;
        try {
            n2 = this.weaveBackoffInSeconds();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n3 = -1;
        try {
            n3 = this.xBackoffInSeconds();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n4 = Math.max(n, Math.max(n3, n2));
        if (n4 < 0) {
            return -1;
        }
        return n4;
    }

    public long totalBackoffInMilliseconds() {
        long l = this.totalBackoffInSeconds(true);
        if (l < 0L) {
            return -1L;
        }
        return 1000L * l;
    }

    public long normalizedWeaveTimestamp() {
        String string2 = "x-weave-timestamp";
        if (!this.hasHeader(string2)) {
            return -1L;
        }
        return Utils.decimalSecondsToMilliseconds(this.response.getFirstHeader(string2).getValue());
    }

    public int weaveRecords() throws NumberFormatException {
        return this.getIntegerHeader("x-weave-records");
    }

    public int weaveQuotaRemaining() throws NumberFormatException {
        return this.getIntegerHeader("x-weave-quota-remaining");
    }

    public String weaveAlert() {
        if (this.hasHeader("x-weave-alert")) {
            return this.response.getFirstHeader("x-weave-alert").getValue();
        }
        return null;
    }
}

