/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentProviderClient;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import java.util.ArrayList;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.NoStoreDelegateException;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.RecordFilter;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.StoreTrackingRepositorySession;
import org.mozilla.gecko.sync.repositories.android.BrowserContractHelpers;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCreationDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFetchRecordsDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionGuidsSinceDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionWipeDelegate;
import org.mozilla.gecko.sync.repositories.domain.PasswordRecord;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class PasswordsRepositorySession
extends StoreTrackingRepositorySession {
    private static final String LOG_TAG = "PasswordsRepoSession";
    private static final String COLLECTION = "passwords";
    private final RepoUtils.QueryHelper passwordsHelper;
    private final RepoUtils.QueryHelper deletedPasswordsHelper;
    private final ContentProviderClient passwordsProvider;
    private final Context context;
    private static final String[] GUID_COLS = new String[]{"guid"};
    private static final String[] DELETED_GUID_COLS = new String[]{"guid"};
    private static final String WHERE_GUID_IS = "guid = ?";
    private static final String WHERE_DELETED_GUID_IS = "guid = ?";
    private static final String WHERE_RECORD_DATA = "hostname = ? AND httpRealm = ? AND formSubmitURL = ? AND usernameField = ? AND passwordField = ?";

    public PasswordsRepositorySession(Repository repository, Context context) {
        super(repository);
        this.context = context;
        this.passwordsHelper = new RepoUtils.QueryHelper(context, BrowserContractHelpers.PASSWORDS_CONTENT_URI, LOG_TAG);
        this.deletedPasswordsHelper = new RepoUtils.QueryHelper(context, BrowserContractHelpers.DELETED_PASSWORDS_CONTENT_URI, LOG_TAG);
        this.passwordsProvider = context.getContentResolver().acquireContentProviderClient(BrowserContract.PASSWORDS_AUTHORITY_URI);
    }

    @Override
    public void guidsSince(final long l, final RepositorySessionGuidsSinceDelegate repositorySessionGuidsSinceDelegate) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String[] stringArray;
                if (!PasswordsRepositorySession.this.isActive()) {
                    repositorySessionGuidsSinceDelegate.onGuidsSinceFailed(new InactiveSessionException(null));
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    Logger.debug(PasswordsRepositorySession.LOG_TAG, "Fetching guidsSince from data table.");
                    stringArray = PasswordsRepositorySession.this.passwordsHelper.safeQuery(PasswordsRepositorySession.this.passwordsProvider, ".getGUIDsSince", GUID_COLS, PasswordsRepositorySession.dateModifiedWhere(l), null, null);
                    try {
                        if (stringArray.moveToFirst()) {
                            while (!stringArray.isAfterLast()) {
                                arrayList.add(RepoUtils.getStringFromCursor((Cursor)stringArray, "guid"));
                                stringArray.moveToNext();
                            }
                        }
                    }
                    finally {
                        stringArray.close();
                    }
                    Logger.debug(PasswordsRepositorySession.LOG_TAG, "Fetching guidsSince from deleted table.");
                    try (Cursor cursor = PasswordsRepositorySession.this.deletedPasswordsHelper.safeQuery(PasswordsRepositorySession.this.passwordsProvider, ".getGUIDsSince", DELETED_GUID_COLS, PasswordsRepositorySession.dateModifiedWhereDeleted(l), null, null);){
                        if (cursor.moveToFirst()) {
                            while (!cursor.isAfterLast()) {
                                arrayList.add(RepoUtils.getStringFromCursor(cursor, "guid"));
                                cursor.moveToNext();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.error(PasswordsRepositorySession.LOG_TAG, "Exception in fetch.");
                    repositorySessionGuidsSinceDelegate.onGuidsSinceFailed(exception);
                    return;
                }
                stringArray = new String[arrayList.size()];
                repositorySessionGuidsSinceDelegate.onGuidsSinceSucceeded(arrayList.toArray(stringArray));
            }
        };
        this.delegateQueue.execute(runnable);
    }

    @Override
    public void fetchSince(final long l, final RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        final RecordFilter recordFilter = this.storeTracker.getFilter();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!PasswordsRepositorySession.this.isActive()) {
                    repositorySessionFetchRecordsDelegate.onFetchFailed(new InactiveSessionException(null), null);
                    return;
                }
                long l2 = RepositorySession.now();
                try {
                    Cursor cursor = PasswordsRepositorySession.this.passwordsHelper.safeQuery(PasswordsRepositorySession.this.passwordsProvider, ".fetchSince", PasswordsRepositorySession.getAllColumns(), PasswordsRepositorySession.dateModifiedWhere(l), null, null);
                    if (!PasswordsRepositorySession.fetchAndCloseCursorDeleted(cursor, false, recordFilter, repositorySessionFetchRecordsDelegate)) {
                        return;
                    }
                    Cursor cursor2 = PasswordsRepositorySession.this.deletedPasswordsHelper.safeQuery(PasswordsRepositorySession.this.passwordsProvider, ".fetchSince", PasswordsRepositorySession.getAllDeletedColumns(), PasswordsRepositorySession.dateModifiedWhereDeleted(l), null, null);
                    if (!PasswordsRepositorySession.fetchAndCloseCursorDeleted(cursor2, true, recordFilter, repositorySessionFetchRecordsDelegate)) {
                        return;
                    }
                    try {
                        repositorySessionFetchRecordsDelegate.onFetchCompleted(l2);
                    }
                    catch (Exception exception) {
                        Logger.error(PasswordsRepositorySession.LOG_TAG, "Delegate fetch completed callback failed.", exception);
                        return;
                    }
                }
                catch (Exception exception) {
                    Logger.error(PasswordsRepositorySession.LOG_TAG, "Exception in fetch.");
                    repositorySessionFetchRecordsDelegate.onFetchFailed(exception, null);
                }
            }
        };
        this.delegateQueue.execute(runnable);
    }

    @Override
    public void fetch(final String[] stringArray, final RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        if (stringArray == null || stringArray.length < 1) {
            Logger.error(LOG_TAG, "No guids to be fetched.");
            final long l = PasswordsRepositorySession.now();
            this.delegateQueue.execute(new Runnable(){

                @Override
                public void run() {
                    repositorySessionFetchRecordsDelegate.onFetchCompleted(l);
                }
            });
            return;
        }
        final RecordFilter recordFilter = this.storeTracker.getFilter();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!PasswordsRepositorySession.this.isActive()) {
                    repositorySessionFetchRecordsDelegate.onFetchFailed(new InactiveSessionException(null), null);
                    return;
                }
                long l = RepositorySession.now();
                String string2 = RepoUtils.computeSQLInClause(stringArray.length, "guid");
                Logger.trace(PasswordsRepositorySession.LOG_TAG, "Fetch guids where: " + string2);
                try {
                    Cursor cursor = PasswordsRepositorySession.this.passwordsHelper.safeQuery(PasswordsRepositorySession.this.passwordsProvider, ".fetch", PasswordsRepositorySession.getAllColumns(), string2, stringArray, null);
                    if (!PasswordsRepositorySession.fetchAndCloseCursorDeleted(cursor, false, recordFilter, repositorySessionFetchRecordsDelegate)) {
                        return;
                    }
                    Cursor cursor2 = PasswordsRepositorySession.this.deletedPasswordsHelper.safeQuery(PasswordsRepositorySession.this.passwordsProvider, ".fetch", PasswordsRepositorySession.getAllDeletedColumns(), string2, stringArray, null);
                    if (!PasswordsRepositorySession.fetchAndCloseCursorDeleted(cursor2, true, recordFilter, repositorySessionFetchRecordsDelegate)) {
                        return;
                    }
                    repositorySessionFetchRecordsDelegate.onFetchCompleted(l);
                }
                catch (Exception exception) {
                    Logger.error(PasswordsRepositorySession.LOG_TAG, "Exception in fetch.");
                    repositorySessionFetchRecordsDelegate.onFetchFailed(exception, null);
                }
            }
        };
        this.delegateQueue.execute(runnable);
    }

    @Override
    public void fetchAll(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        this.fetchSince(0L, repositorySessionFetchRecordsDelegate);
    }

    @Override
    public void store(final Record record) throws NoStoreDelegateException {
        if (this.delegate == null) {
            Logger.error(LOG_TAG, "No store delegate.");
            throw new NoStoreDelegateException();
        }
        if (record == null) {
            Logger.error(LOG_TAG, "Record sent to store was null.");
            throw new IllegalArgumentException("Null record passed to PasswordsRepositorySession.store().");
        }
        if (!(record instanceof PasswordRecord)) {
            Logger.error(LOG_TAG, "Can't store anything but a PasswordRecord.");
            throw new IllegalArgumentException("Non-PasswordRecord passed to PasswordsRepositorySession.store().");
        }
        final PasswordRecord passwordRecord = (PasswordRecord)record;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Record record3;
                boolean bl;
                PasswordRecord passwordRecord2;
                if (!PasswordsRepositorySession.this.isActive()) {
                    Logger.warn(PasswordsRepositorySession.LOG_TAG, "RepositorySession is inactive. Store failing.");
                    PasswordsRepositorySession.this.delegate.onRecordStoreFailed(new InactiveSessionException(null), record.guid);
                    return;
                }
                String string2 = passwordRecord.guid;
                if (string2 == null) {
                    PasswordsRepositorySession.this.delegate.onRecordStoreFailed(new RuntimeException("Can't store record with null GUID."), record.guid);
                    return;
                }
                try {
                    passwordRecord2 = PasswordsRepositorySession.this.retrieveByGUID(string2);
                }
                catch (RemoteException | NullCursorException throwable) {
                    PasswordsRepositorySession.this.delegate.onRecordStoreFailed((Exception)throwable, record.guid);
                    return;
                }
                long l = 0L;
                long l2 = 0L;
                boolean bl2 = bl = passwordRecord.lastModified > l2;
                if (passwordRecord.deleted) {
                    boolean bl3;
                    if (passwordRecord2 == null) {
                        Logger.info(PasswordsRepositorySession.LOG_TAG, "Incoming record " + passwordRecord.guid + " is deleted, and no local version.");
                        return;
                    }
                    if (passwordRecord2.deleted) {
                        PasswordsRepositorySession.this.storeRecordDeletion(passwordRecord2);
                        Logger.info(PasswordsRepositorySession.LOG_TAG, "Incoming record " + passwordRecord.guid + " and local are both deleted.");
                        return;
                    }
                    if (!bl) {
                        PasswordsRepositorySession.trace("Ignoring deleted record from the past.");
                        return;
                    }
                    boolean bl4 = bl3 = passwordRecord2.lastModified > l;
                    if (!bl3) {
                        PasswordsRepositorySession.trace("Remote modified, local not. Deleting.");
                        PasswordsRepositorySession.this.storeRecordDeletion(passwordRecord);
                        return;
                    }
                    PasswordsRepositorySession.trace("Both local and remote records have been modified.");
                    if (passwordRecord.lastModified > passwordRecord2.lastModified) {
                        PasswordsRepositorySession.trace("Remote is newer, and deleted. Deleting local.");
                        PasswordsRepositorySession.this.storeRecordDeletion(passwordRecord);
                        return;
                    }
                    PasswordsRepositorySession.trace("Remote is older, local is not deleted. Ignoring.");
                    if (!bl3) {
                        Logger.warn(PasswordsRepositorySession.LOG_TAG, "Inconsistency: old remote record is deleted, but local record not modified!");
                    }
                    return;
                }
                if (!passwordRecord.isValid()) {
                    Logger.warn(PasswordsRepositorySession.LOG_TAG, "Incoming record is invalid. Reporting store failed.");
                    PasswordsRepositorySession.this.delegate.onRecordStoreFailed(new RuntimeException("Can't store invalid password record."), record.guid);
                    return;
                }
                if (passwordRecord2 == null) {
                    PasswordsRepositorySession.trace("Looking up match for record " + passwordRecord.guid);
                    try {
                        passwordRecord2 = PasswordsRepositorySession.this.findExistingRecord(passwordRecord);
                    }
                    catch (RemoteException remoteException) {
                        Logger.error(PasswordsRepositorySession.LOG_TAG, "Remote exception in findExistingRecord.");
                        PasswordsRepositorySession.this.delegate.onRecordStoreFailed((Exception)((Object)remoteException), record.guid);
                    }
                    catch (NullCursorException nullCursorException) {
                        Logger.error(PasswordsRepositorySession.LOG_TAG, "Null cursor in findExistingRecord.");
                        PasswordsRepositorySession.this.delegate.onRecordStoreFailed(nullCursorException, record.guid);
                    }
                }
                if (passwordRecord2 == null) {
                    PasswordsRepositorySession.trace("No match. Inserting.");
                    Logger.debug(PasswordsRepositorySession.LOG_TAG, "Didn't find matching record. Inserting.");
                    record3 = null;
                    try {
                        record3 = PasswordsRepositorySession.this.insert(passwordRecord);
                    }
                    catch (RemoteException remoteException) {
                        Logger.debug(PasswordsRepositorySession.LOG_TAG, "Record insert caused a RemoteException.");
                        PasswordsRepositorySession.this.delegate.onRecordStoreFailed((Exception)((Object)remoteException), record.guid);
                        return;
                    }
                    PasswordsRepositorySession.this.trackRecord(record3);
                    PasswordsRepositorySession.this.delegate.onRecordStoreSucceeded(record3.guid);
                    return;
                }
                PasswordsRepositorySession.trace("Incoming record " + passwordRecord.guid + " dupes to local record " + passwordRecord2.guid);
                Logger.debug(PasswordsRepositorySession.LOG_TAG, "remote " + passwordRecord.guid + " dupes to " + passwordRecord2.guid);
                record3 = PasswordsRepositorySession.this.reconcileRecords(passwordRecord, passwordRecord2, l2, l);
                if (record3 == null) {
                    Logger.debug(PasswordsRepositorySession.LOG_TAG, "Reconciling returned null. Not inserting a record.");
                    return;
                }
                Logger.debug(PasswordsRepositorySession.LOG_TAG, "Replacing " + passwordRecord2.guid + " with record " + record3.guid);
                Record record2 = null;
                try {
                    record2 = PasswordsRepositorySession.this.replace(passwordRecord2, record3);
                }
                catch (RemoteException remoteException) {
                    Logger.debug(PasswordsRepositorySession.LOG_TAG, "Record replace caused a RemoteException.");
                    PasswordsRepositorySession.this.delegate.onRecordStoreFailed((Exception)((Object)remoteException), record.guid);
                    return;
                }
                Logger.debug(PasswordsRepositorySession.LOG_TAG, "Calling delegate callback with guid " + record2.guid + "(" + record2.androidID + ")");
                PasswordsRepositorySession.this.delegate.onRecordStoreSucceeded(record.guid);
            }
        };
        this.storeWorkQueue.execute(runnable);
    }

    @Override
    public void wipe(final RepositorySessionWipeDelegate repositorySessionWipeDelegate) {
        Logger.info(LOG_TAG, "Wiping " + BrowserContractHelpers.PASSWORDS_CONTENT_URI + ", " + BrowserContractHelpers.DELETED_PASSWORDS_CONTENT_URI);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!PasswordsRepositorySession.this.isActive()) {
                    repositorySessionWipeDelegate.onWipeFailed(new InactiveSessionException(null));
                    return;
                }
                try {
                    PasswordsRepositorySession.this.context.getContentResolver().delete(BrowserContractHelpers.PASSWORDS_CONTENT_URI, null, null);
                    PasswordsRepositorySession.this.context.getContentResolver().delete(BrowserContractHelpers.DELETED_PASSWORDS_CONTENT_URI, null, null);
                }
                catch (Exception exception) {
                    repositorySessionWipeDelegate.onWipeFailed(exception);
                    return;
                }
                repositorySessionWipeDelegate.onWipeSucceeded();
            }
        };
        this.storeWorkQueue.execute(runnable);
    }

    @Override
    public void abort() {
        this.passwordsProvider.release();
        super.abort();
    }

    @Override
    public void finish(RepositorySessionFinishDelegate repositorySessionFinishDelegate) throws InactiveSessionException {
        this.passwordsProvider.release();
        super.finish(repositorySessionFinishDelegate);
    }

    public void deleteGUID(String string2) throws RemoteException {
        String[] stringArray = new String[]{string2};
        int n = this.passwordsProvider.delete(BrowserContractHelpers.PASSWORDS_CONTENT_URI, "guid = ?", stringArray) + this.passwordsProvider.delete(BrowserContractHelpers.DELETED_PASSWORDS_CONTENT_URI, "guid = ?", stringArray);
        if (n == 1) {
            return;
        }
        Logger.warn(LOG_TAG, "Unexpectedly deleted " + n + " rows for guid " + string2);
    }

    public PasswordRecord insert(PasswordRecord passwordRecord) throws RemoteException {
        passwordRecord.timePasswordChanged = PasswordsRepositorySession.now();
        ContentValues contentValues = PasswordsRepositorySession.getContentValues(passwordRecord);
        Uri uri = this.passwordsProvider.insert(BrowserContractHelpers.PASSWORDS_CONTENT_URI, contentValues);
        if (uri == null) {
            throw new RemoteException();
        }
        passwordRecord.androidID = ContentUris.parseId((Uri)uri);
        return passwordRecord;
    }

    public Record replace(Record record, Record record2) throws RemoteException {
        PasswordRecord passwordRecord = (PasswordRecord)record2;
        PasswordRecord passwordRecord2 = (PasswordRecord)record;
        PasswordsRepositorySession.propagateTimes(passwordRecord, passwordRecord2);
        ContentValues contentValues = PasswordsRepositorySession.getContentValues(passwordRecord);
        String[] stringArray = new String[]{record.guid};
        int n = this.context.getContentResolver().update(BrowserContractHelpers.PASSWORDS_CONTENT_URI, contentValues, "guid = ?", stringArray);
        if (n != 1) {
            Logger.warn(LOG_TAG, "Unexpectedly updated " + n + " rows for guid " + passwordRecord2.guid);
        }
        return record2;
    }

    private static void propagateTimes(PasswordRecord passwordRecord, PasswordRecord passwordRecord2) {
        passwordRecord.timePasswordChanged = PasswordsRepositorySession.now();
        passwordRecord.timeCreated = passwordRecord2.timeCreated;
        passwordRecord.timeLastUsed = passwordRecord2.timeLastUsed;
        passwordRecord.timesUsed = passwordRecord2.timesUsed;
    }

    private static String[] getAllColumns() {
        return BrowserContractHelpers.PasswordColumns;
    }

    private static String[] getAllDeletedColumns() {
        return BrowserContractHelpers.DeletedColumns;
    }

    private static String dateModifiedWhereDeleted(long l) {
        return "timeDeleted >= " + Long.toString(l);
    }

    private static String dateModifiedWhere(long l) {
        return "timePasswordChanged >= " + Long.toString(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean fetchAndCloseCursorDeleted(Cursor cursor, boolean bl, RecordFilter recordFilter, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        if (cursor == null) {
            return true;
        }
        try {
            while (cursor.moveToNext()) {
                PasswordRecord passwordRecord = bl ? PasswordsRepositorySession.deletedPasswordRecordFromCursor(cursor) : PasswordsRepositorySession.passwordRecordFromCursor(cursor);
                if (passwordRecord == null) continue;
                if (recordFilter == null || !recordFilter.excludeRecord(passwordRecord)) {
                    Logger.debug(LOG_TAG, "Processing record " + passwordRecord.guid);
                    repositorySessionFetchRecordsDelegate.onFetchedRecord(passwordRecord);
                    continue;
                }
                Logger.debug(LOG_TAG, "Skipping filtered record " + passwordRecord.guid);
            }
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Exception in fetch.");
            repositorySessionFetchRecordsDelegate.onFetchFailed(exception, null);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            cursor.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasswordRecord retrieveByGUID(String string2) throws NullCursorException, RemoteException {
        String[] stringArray = new String[]{string2};
        try (Cursor cursor = this.passwordsHelper.safeQuery(this.passwordsProvider, ".store", BrowserContractHelpers.PasswordColumns, "guid = ?", stringArray, null);){
            if (cursor.moveToFirst()) {
                PasswordRecord passwordRecord = PasswordsRepositorySession.passwordRecordFromCursor(cursor);
                return passwordRecord;
            }
        }
        try (Cursor cursor = this.deletedPasswordsHelper.safeQuery(this.passwordsProvider, ".retrieveByGuid", BrowserContractHelpers.DeletedColumns, "guid = ?", stringArray, null);){
            if (cursor.moveToFirst()) {
                PasswordRecord passwordRecord = PasswordsRepositorySession.deletedPasswordRecordFromCursor(cursor);
                return passwordRecord;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasswordRecord findExistingRecord(PasswordRecord passwordRecord) throws NullCursorException, RemoteException {
        PasswordRecord passwordRecord2 = null;
        String[] stringArray = new String[]{passwordRecord.hostname, passwordRecord.httpRealm, passwordRecord.formSubmitURL, passwordRecord.usernameField, passwordRecord.passwordField};
        try (Cursor cursor = null;){
            cursor = this.passwordsHelper.safeQuery(this.passwordsProvider, ".findRecord", PasswordsRepositorySession.getAllColumns(), WHERE_RECORD_DATA, stringArray, null);
            while (cursor.moveToNext()) {
                passwordRecord2 = PasswordsRepositorySession.passwordRecordFromCursor(cursor);
                Logger.pii(LOG_TAG, "Checking incoming [" + passwordRecord.encryptedUsername + "] to [" + passwordRecord2.encryptedUsername + "]");
                if (!passwordRecord.encryptedUsername.equals(passwordRecord2.encryptedUsername)) continue;
                Logger.trace(LOG_TAG, "Found matching record: " + passwordRecord2.guid);
                PasswordRecord passwordRecord3 = passwordRecord2;
                return passwordRecord3;
            }
        }
        Logger.debug(LOG_TAG, "No matching records, returning null.");
        return null;
    }

    private void storeRecordDeletion(Record record) {
        try {
            this.deleteGUID(record.guid);
        }
        catch (RemoteException remoteException) {
            Logger.error(LOG_TAG, "RemoteException in password delete.");
            this.delegate.onRecordStoreFailed((Exception)((Object)remoteException), record.guid);
            return;
        }
        this.delegate.onRecordStoreSucceeded(record.guid);
    }

    private static PasswordRecord passwordRecordFromCursor(Cursor cursor) {
        if (cursor.isAfterLast()) {
            return null;
        }
        String string2 = RepoUtils.getStringFromCursor(cursor, "guid");
        long l = RepoUtils.getLongFromCursor(cursor, "timePasswordChanged");
        PasswordRecord passwordRecord = new PasswordRecord(string2, COLLECTION, l, false);
        passwordRecord.id = RepoUtils.getStringFromCursor(cursor, "id");
        passwordRecord.hostname = RepoUtils.getStringFromCursor(cursor, "hostname");
        passwordRecord.httpRealm = RepoUtils.getStringFromCursor(cursor, "httpRealm");
        passwordRecord.formSubmitURL = RepoUtils.getStringFromCursor(cursor, "formSubmitURL");
        passwordRecord.usernameField = RepoUtils.getStringFromCursor(cursor, "usernameField");
        passwordRecord.passwordField = RepoUtils.getStringFromCursor(cursor, "passwordField");
        passwordRecord.encType = RepoUtils.getStringFromCursor(cursor, "encType");
        passwordRecord.encryptedUsername = RepoUtils.getStringFromCursor(cursor, "encryptedUsername");
        passwordRecord.encryptedPassword = RepoUtils.getStringFromCursor(cursor, "encryptedPassword");
        passwordRecord.timeCreated = RepoUtils.getLongFromCursor(cursor, "timeCreated");
        passwordRecord.timeLastUsed = RepoUtils.getLongFromCursor(cursor, "timeLastUsed");
        passwordRecord.timePasswordChanged = RepoUtils.getLongFromCursor(cursor, "timePasswordChanged");
        passwordRecord.timesUsed = RepoUtils.getLongFromCursor(cursor, "timesUsed");
        return passwordRecord;
    }

    private static PasswordRecord deletedPasswordRecordFromCursor(Cursor cursor) {
        if (cursor.isAfterLast()) {
            return null;
        }
        String string2 = RepoUtils.getStringFromCursor(cursor, "guid");
        long l = RepoUtils.getLongFromCursor(cursor, "timeDeleted");
        PasswordRecord passwordRecord = new PasswordRecord(string2, COLLECTION, l, true);
        passwordRecord.androidID = RepoUtils.getLongFromCursor(cursor, "id");
        return passwordRecord;
    }

    private static ContentValues getContentValues(Record record) {
        PasswordRecord passwordRecord = (PasswordRecord)record;
        ContentValues contentValues = new ContentValues();
        contentValues.put("guid", passwordRecord.guid);
        contentValues.put("hostname", passwordRecord.hostname);
        contentValues.put("httpRealm", passwordRecord.httpRealm);
        contentValues.put("formSubmitURL", passwordRecord.formSubmitURL);
        contentValues.put("usernameField", passwordRecord.usernameField);
        contentValues.put("passwordField", passwordRecord.passwordField);
        contentValues.put("encType", passwordRecord.encType);
        contentValues.put("encryptedUsername", passwordRecord.encryptedUsername);
        contentValues.put("encryptedPassword", passwordRecord.encryptedPassword);
        contentValues.put("timeCreated", Long.valueOf(passwordRecord.timeCreated));
        contentValues.put("timeLastUsed", Long.valueOf(passwordRecord.timeLastUsed));
        contentValues.put("timePasswordChanged", Long.valueOf(passwordRecord.timePasswordChanged));
        contentValues.put("timesUsed", Long.valueOf(passwordRecord.timesUsed));
        return contentValues;
    }

    public static class PasswordsRepository
    extends Repository {
        @Override
        public void createSession(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
            PasswordsRepositorySession passwordsRepositorySession = new PasswordsRepositorySession(this, context);
            RepositorySessionCreationDelegate repositorySessionCreationDelegate2 = repositorySessionCreationDelegate.deferredCreationDelegate();
            repositorySessionCreationDelegate2.onSessionCreated(passwordsRepositorySession);
        }
    }
}

