/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabqueue;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.mozglue.ContextUtils;
import org.mozilla.gecko.tabqueue.TabQueueService;

public class TabQueueDispatcher
extends Locales.LocaleAwareActivity {
    private static final String LOGTAG = "Gecko" + TabQueueDispatcher.class.getSimpleName();

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        GeckoAppShell.ensureCrashHandling();
        ContextUtils.SafeIntent safeIntent = new ContextUtils.SafeIntent(this.getIntent());
        String string2 = safeIntent.getDataString();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.abortDueToNoURL(string2);
            return;
        }
        boolean bl = GeckoSharedPrefs.forApp((Context)this).getBoolean("android.not_a_preference.tab_queue", false);
        if (bl) {
            this.showToast(safeIntent.getUnsafe());
        } else {
            this.loadNormally(safeIntent.getUnsafe());
        }
    }

    private void showToast(Intent intent) {
        intent.setClass(this.getApplicationContext(), TabQueueService.class);
        this.startService(intent);
        this.finish();
    }

    private void loadNormally(Intent intent) {
        intent.setClassName(this.getApplicationContext(), "org.mozilla.gecko.BrowserApp");
        this.startActivity(intent);
        this.finish();
    }

    private void abortDueToNoURL(String string2) {
        Log.w((String)LOGTAG, (String)("Unable to process tab queue insertion. No URL found! - passed data string: " + string2));
        this.finish();
    }
}

