/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.lwt.LightweightTheme;
import org.mozilla.gecko.lwt.LightweightThemeDrawable;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.MenuPanel;
import org.mozilla.gecko.menu.MenuPopup;
import org.mozilla.gecko.tabs.TabHistoryController;
import org.mozilla.gecko.toolbar.AutocompleteHandler;
import org.mozilla.gecko.toolbar.BrowserToolbarPhone;
import org.mozilla.gecko.toolbar.BrowserToolbarPreHC;
import org.mozilla.gecko.toolbar.BrowserToolbarTablet;
import org.mozilla.gecko.toolbar.TabCounter;
import org.mozilla.gecko.toolbar.ToolbarDisplayLayout;
import org.mozilla.gecko.toolbar.ToolbarEditLayout;
import org.mozilla.gecko.toolbar.ToolbarPrefs;
import org.mozilla.gecko.toolbar.ToolbarProgressView;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.MenuUtils;
import org.mozilla.gecko.widget.ThemedImageButton;
import org.mozilla.gecko.widget.ThemedImageView;
import org.mozilla.gecko.widget.ThemedLinearLayout;
import org.mozilla.gecko.widget.ThemedRelativeLayout;

public abstract class BrowserToolbar
extends ThemedRelativeLayout
implements Tabs.OnTabsChangedListener,
GeckoMenu.ActionItemBarPresenter {
    private static final String LOGTAG = "GeckoToolbar";
    private static final int LIGHTWEIGHT_THEME_INVERT_ALPHA = 34;
    protected final ToolbarDisplayLayout urlDisplayLayout;
    protected final ToolbarEditLayout urlEditLayout;
    protected final View urlBarEntry;
    protected boolean isSwitchingTabs;
    protected final ThemedImageButton tabsButton;
    private ToolbarProgressView progressBar;
    protected final TabCounter tabsCounter;
    protected final ThemedImageButton menuButton;
    protected final ThemedImageView menuIcon;
    private MenuPopup menuPopup;
    protected final List<View> focusOrder;
    private OnActivateListener activateListener;
    private View.OnFocusChangeListener focusChangeListener;
    private OnStartEditingListener startEditingListener;
    private OnStopEditingListener stopEditingListener;
    protected final BrowserApp activity;
    protected boolean hasSoftMenuButton;
    protected UIMode uiMode;
    protected TabHistoryController tabHistoryController;
    private final Paint shadowPaint;
    private final int shadowSize;
    private final ToolbarPrefs prefs;
    private boolean contextMenuEnabled = true;

    public abstract boolean isAnimating();

    protected abstract boolean isTabsButtonOffscreen();

    protected abstract void updateNavigationButtons(Tab var1);

    protected abstract void triggerStartEditingTransition(PropertyAnimator var1);

    protected abstract void triggerStopEditingTransition();

    public abstract void triggerTabsPanelTransition(PropertyAnimator var1, boolean var2);

    protected Drawable getLWTDefaultStateSetDrawable() {
        return this.getTheme().getDrawable((View)this);
    }

    public static BrowserToolbar create(Context context, AttributeSet attributeSet) {
        BrowserToolbar browserToolbar = HardwareUtils.isTablet() ? new BrowserToolbarTablet(context, attributeSet) : (AppConstants.Versions.preHC ? new BrowserToolbarPreHC(context, attributeSet) : new BrowserToolbarPhone(context, attributeSet));
        return browserToolbar;
    }

    protected BrowserToolbar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setWillNotDraw(false);
        this.activity = (BrowserApp)context;
        LayoutInflater.from((Context)context).inflate(R.layout.browser_toolbar, (ViewGroup)this);
        Tabs.registerOnTabsChangedListener(this);
        this.isSwitchingTabs = true;
        this.urlDisplayLayout = (ToolbarDisplayLayout)this.findViewById(R.id.display_layout);
        this.urlBarEntry = this.findViewById(R.id.url_bar_entry);
        this.urlEditLayout = (ToolbarEditLayout)this.findViewById(R.id.edit_layout);
        this.tabsButton = (ThemedImageButton)this.findViewById(R.id.tabs);
        this.tabsCounter = (TabCounter)this.findViewById(R.id.tabs_counter);
        if (AppConstants.Versions.feature11Plus) {
            this.tabsCounter.setLayerType(1, null);
        }
        this.menuButton = (ThemedImageButton)this.findViewById(R.id.menu);
        this.menuIcon = (ThemedImageView)this.findViewById(R.id.menu_icon);
        this.hasSoftMenuButton = !HardwareUtils.hasMenuButton();
        this.focusOrder = new ArrayList<View>();
        Resources resources = this.getResources();
        this.shadowSize = resources.getDimensionPixelSize(R.dimen.browser_toolbar_shadow_size);
        this.shadowPaint = new Paint();
        this.shadowPaint.setColor(resources.getColor(R.color.url_bar_shadow));
        this.shadowPaint.setStrokeWidth(0.0f);
        this.setUIMode(UIMode.DISPLAY);
        this.prefs = new ToolbarPrefs();
        this.urlDisplayLayout.setToolbarPrefs(this.prefs);
        this.urlEditLayout.setToolbarPrefs(this.prefs);
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.prefs.open();
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BrowserToolbar.this.activateListener != null) {
                    BrowserToolbar.this.activateListener.onActivate();
                }
            }
        });
        this.setOnCreateContextMenuListener(new View.OnCreateContextMenuListener(){

            public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
                Tab tab;
                if (BrowserToolbar.this.isEditing() || !BrowserToolbar.this.contextMenuEnabled) {
                    return;
                }
                MenuInflater menuInflater = BrowserToolbar.this.activity.getMenuInflater();
                menuInflater.inflate(R.menu.titlebar_contextmenu, (Menu)contextMenu);
                String string2 = Clipboard.getText();
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    contextMenu.findItem(R.id.pasteandgo).setVisible(false);
                    contextMenu.findItem(R.id.paste).setVisible(false);
                }
                if ((tab = Tabs.getInstance().getSelectedTab()) != null) {
                    String string3 = tab.getURL();
                    if (string3 == null) {
                        contextMenu.findItem(R.id.copyurl).setVisible(false);
                        contextMenu.findItem(R.id.add_to_launcher).setVisible(false);
                    }
                    MenuUtils.safeSetVisible((Menu)contextMenu, (int)R.id.subscribe, (boolean)tab.hasFeeds());
                    MenuUtils.safeSetVisible((Menu)contextMenu, (int)R.id.add_search_engine, (boolean)tab.hasOpenSearch());
                } else {
                    contextMenu.findItem(R.id.copyurl).setVisible(false);
                    contextMenu.findItem(R.id.add_to_launcher).setVisible(false);
                    MenuUtils.safeSetVisible((Menu)contextMenu, (int)R.id.subscribe, (boolean)false);
                    MenuUtils.safeSetVisible((Menu)contextMenu, (int)R.id.add_search_engine, (boolean)false);
                }
            }
        });
        this.urlDisplayLayout.setOnStopListener(new ToolbarDisplayLayout.OnStopListener(){

            @Override
            public Tab onStop() {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    tab.doStop();
                    return tab;
                }
                return null;
            }
        });
        this.urlDisplayLayout.setOnTitleChangeListener(new ToolbarDisplayLayout.OnTitleChangeListener(){

            @Override
            public void onTitleChange(CharSequence charSequence) {
                String string2 = charSequence != null ? charSequence.toString() : BrowserToolbar.this.activity.getString(R.string.url_bar_default_text);
                BrowserToolbar.this.setContentDescription(string2);
            }
        });
        this.urlEditLayout.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                BrowserToolbar.this.setSelected(bl);
                if (BrowserToolbar.this.focusChangeListener != null) {
                    BrowserToolbar.this.focusChangeListener.onFocusChange(view, bl);
                }
            }
        });
        this.tabsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BrowserToolbar.this.urlEditLayout.clearFocus();
                BrowserToolbar.this.toggleTabs();
            }
        });
        this.tabsButton.setImageLevel(0);
        if (this.hasSoftMenuButton) {
            this.menuButton.setVisibility(0);
            this.menuIcon.setVisibility(0);
            this.menuButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BrowserToolbar.this.urlEditLayout.clearFocus();
                    BrowserToolbar.this.activity.openOptionsMenu();
                }
            });
        }
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.prefs.close();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int n = this.getHeight();
        canvas.drawRect(0.0f, (float)(n - this.shadowSize), (float)this.getWidth(), (float)n, this.shadowPaint);
    }

    public void setProgressBar(ToolbarProgressView toolbarProgressView) {
        this.progressBar = toolbarProgressView;
    }

    public void setTabHistoryController(TabHistoryController tabHistoryController) {
        this.tabHistoryController = tabHistoryController;
    }

    public void refresh() {
        this.urlDisplayLayout.dismissSiteIdentityPopup();
    }

    public boolean onBackPressed() {
        if (this.isEditing() && !this.isAnimating()) {
            Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.BACK);
            this.cancelEdit();
            return true;
        }
        return this.urlDisplayLayout.dismissSiteIdentityPopup();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent != null && motionEvent.getY() > (float)this.getHeight() + ViewHelper.getTranslationY((View)this)) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n2 != n4) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    BrowserToolbar.this.activity.refreshToolbarHeight();
                }
            });
        }
    }

    public void saveTabEditingState(TabEditingState tabEditingState) {
        this.urlEditLayout.saveTabEditingState(tabEditingState);
    }

    public void restoreTabEditingState(TabEditingState tabEditingState) {
        if (!this.isEditing()) {
            throw new IllegalStateException("Expected to be editing");
        }
        this.urlEditLayout.restoreTabEditingState(tabEditingState);
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        Log.d((String)LOGTAG, (String)("onTabChanged: " + (Object)((Object)tabEvents)));
        Tabs tabs = Tabs.getInstance();
        switch (tabEvents) {
            case ADDED: 
            case CLOSED: {
                this.updateTabCount(tabs.getDisplayCount());
                break;
            }
            case RESTORED: 
            case SELECTED: {
                this.urlDisplayLayout.dismissSiteIdentityPopup();
                this.updateTabCount(tabs.getDisplayCount());
                this.isSwitchingTabs = true;
            }
        }
        if (tabs.isSelectedTab(tab)) {
            EnumSet<ToolbarDisplayLayout.UpdateFlags> enumSet = EnumSet.noneOf(ToolbarDisplayLayout.UpdateFlags.class);
            switch (tabEvents) {
                case START: {
                    this.updateProgressVisibility(tab, 10);
                }
                case ADDED: 
                case LOCATION_CHANGE: 
                case LOAD_ERROR: 
                case LOADED: 
                case STOP: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.PROGRESS);
                    if (this.progressBar.getVisibility() != 0) break;
                    this.progressBar.animateProgress(tab.getLoadProgress());
                    break;
                }
                case SELECTED: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.PROGRESS);
                    this.updateProgressVisibility();
                }
            }
            switch (tabEvents) {
                case STOP: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.TITLE);
                }
                case ADDED: 
                case CLOSED: 
                case START: {
                    this.updateNavigationButtons(tab);
                    break;
                }
                case SELECTED: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.PRIVATE_MODE);
                    this.setPrivateMode(tab.isPrivate());
                }
                case LOAD_ERROR: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.TITLE);
                }
                case LOCATION_CHANGE: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.FAVICON);
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.SITE_IDENTITY);
                    this.updateNavigationButtons(tab);
                    break;
                }
                case TITLE: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.TITLE);
                    break;
                }
                case FAVICON: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.FAVICON);
                    break;
                }
                case SECURITY_CHANGE: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.SITE_IDENTITY);
                }
            }
            if (!enumSet.isEmpty()) {
                this.updateDisplayLayout(tab, enumSet);
            }
        }
        switch (tabEvents) {
            case SELECTED: 
            case LOCATION_CHANGE: 
            case LOAD_ERROR: {
                this.isSwitchingTabs = false;
            }
        }
    }

    private void updateProgressVisibility() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            this.updateProgressVisibility(tab, tab.getLoadProgress());
        }
    }

    private void updateProgressVisibility(Tab tab, int n) {
        if (!this.isEditing() && tab.getState() == 1) {
            this.progressBar.setProgress(n);
            this.progressBar.setVisibility(0);
        } else {
            this.progressBar.setVisibility(8);
        }
    }

    protected boolean isVisible() {
        return ViewHelper.getTranslationY((View)this) == 0.0f;
    }

    public void setNextFocusDownId(int n) {
        super.setNextFocusDownId(n);
        this.tabsButton.setNextFocusDownId(n);
        this.urlDisplayLayout.setNextFocusDownId(n);
        this.menuButton.setNextFocusDownId(n);
    }

    public boolean hideVirtualKeyboard() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.activity.getSystemService("input_method");
        return inputMethodManager.hideSoftInputFromWindow(this.tabsButton.getWindowToken(), 0);
    }

    private void showSelectedTabs() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            if (!tab.isPrivate()) {
                this.activity.showNormalTabs();
            } else {
                this.activity.showPrivateTabs();
            }
        }
    }

    private void toggleTabs() {
        if (this.activity.areTabsShown()) {
            return;
        }
        if (this.hideVirtualKeyboard()) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    BrowserToolbar.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    BrowserToolbar.this.showSelectedTabs();
                }
            });
        } else {
            this.showSelectedTabs();
        }
    }

    protected void updateTabCount(int n) {
        if (this.isTabsButtonOffscreen()) {
            return;
        }
        if (this.isVisible() && ViewHelper.getAlpha((View)this.tabsCounter) != 0.0f && !this.isEditing()) {
            this.tabsCounter.setCountWithAnimation(n);
        } else {
            this.tabsCounter.setCount(n);
        }
        this.tabsButton.setContentDescription(n > 1 ? this.activity.getString(R.string.num_tabs, new Object[]{n}) : this.activity.getString(R.string.one_tab));
    }

    private void updateDisplayLayout(Tab tab, EnumSet<ToolbarDisplayLayout.UpdateFlags> enumSet) {
        if (this.isSwitchingTabs) {
            enumSet.add(ToolbarDisplayLayout.UpdateFlags.DISABLE_ANIMATIONS);
        }
        this.urlDisplayLayout.updateFromTab(tab, enumSet);
        if (enumSet.contains((Object)ToolbarDisplayLayout.UpdateFlags.TITLE) && !this.isEditing()) {
            this.urlEditLayout.setText(tab.getURL());
        }
        if (enumSet.contains((Object)ToolbarDisplayLayout.UpdateFlags.PROGRESS)) {
            this.updateFocusOrder();
        }
    }

    private void updateFocusOrder() {
        if (this.focusOrder.size() == 0) {
            throw new IllegalStateException("Expected focusOrder to be initialized in subclass");
        }
        View view = null;
        boolean bl = false;
        for (View view2 : this.focusOrder) {
            if (view2.getVisibility() != 0 || !view2.isEnabled()) {
                if (!view2.hasFocus()) continue;
                bl = true;
                continue;
            }
            if (view2.getId() == R.id.menu_items) {
                LinearLayout linearLayout = (LinearLayout)view2;
                int n = linearLayout.getChildCount();
                for (int i = 0; i < n; ++i) {
                    View view3 = linearLayout.getChildAt(i);
                    if (view != null) {
                        view3.setNextFocusLeftId(view.getId());
                        view.setNextFocusRightId(view3.getId());
                    }
                    view = view3;
                }
                continue;
            }
            if (view != null) {
                view2.setNextFocusLeftId(view.getId());
                view.setNextFocusRightId(view2.getId());
            }
            view = view2;
        }
        if (bl) {
            this.requestFocus();
        }
    }

    public void setToolBarButtonsAlpha(float f) {
        ViewHelper.setAlpha((View)this.tabsCounter, f);
        if (this.hasSoftMenuButton && !HardwareUtils.isTablet()) {
            ViewHelper.setAlpha((View)this.menuIcon, f);
        }
    }

    public void onEditSuggestion(String string2) {
        if (!this.isEditing()) {
            return;
        }
        this.urlEditLayout.onEditSuggestion(string2);
    }

    public void setTitle(CharSequence charSequence) {
        this.urlDisplayLayout.setTitle(charSequence);
    }

    public void setOnActivateListener(OnActivateListener onActivateListener) {
        this.activateListener = onActivateListener;
    }

    public void setOnCommitListener(OnCommitListener onCommitListener) {
        this.urlEditLayout.setOnCommitListener(onCommitListener);
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.urlEditLayout.setOnDismissListener(onDismissListener);
    }

    public void setOnFilterListener(OnFilterListener onFilterListener) {
        this.urlEditLayout.setOnFilterListener(onFilterListener);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.focusChangeListener = onFocusChangeListener;
    }

    public void setOnStartEditingListener(OnStartEditingListener onStartEditingListener) {
        this.startEditingListener = onStartEditingListener;
    }

    public void setOnStopEditingListener(OnStopEditingListener onStopEditingListener) {
        this.stopEditingListener = onStopEditingListener;
    }

    protected void showUrlEditLayout() {
        this.setUrlEditLayoutVisibility(true, null);
    }

    protected void showUrlEditLayout(PropertyAnimator propertyAnimator) {
        this.setUrlEditLayoutVisibility(true, propertyAnimator);
    }

    protected void hideUrlEditLayout() {
        this.setUrlEditLayoutVisibility(false, null);
    }

    protected void hideUrlEditLayout(PropertyAnimator propertyAnimator) {
        this.setUrlEditLayoutVisibility(false, propertyAnimator);
    }

    protected void setUrlEditLayoutVisibility(final boolean bl, PropertyAnimator propertyAnimator) {
        if (bl) {
            this.urlEditLayout.prepareShowAnimation(propertyAnimator);
        }
        if (propertyAnimator == null) {
            ThemedLinearLayout themedLinearLayout = bl ? this.urlEditLayout : this.urlDisplayLayout;
            ThemedLinearLayout themedLinearLayout2 = bl ? this.urlDisplayLayout : this.urlEditLayout;
            themedLinearLayout2.setVisibility(8);
            themedLinearLayout.setVisibility(0);
            return;
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                if (!bl) {
                    BrowserToolbar.this.urlEditLayout.setVisibility(8);
                    BrowserToolbar.this.urlDisplayLayout.setVisibility(0);
                }
            }

            @Override
            public void onPropertyAnimationEnd() {
                if (bl) {
                    BrowserToolbar.this.urlDisplayLayout.setVisibility(8);
                    BrowserToolbar.this.urlEditLayout.setVisibility(0);
                }
            }
        });
    }

    private void setUIMode(UIMode uIMode) {
        this.uiMode = uIMode;
        this.urlEditLayout.setEnabled(uIMode == UIMode.EDIT);
    }

    public boolean isEditing() {
        return this.uiMode == UIMode.EDIT;
    }

    public void startEditing(String string2, PropertyAnimator propertyAnimator) {
        if (this.isEditing()) {
            return;
        }
        this.urlEditLayout.setText(string2 != null ? string2 : "");
        this.setUIMode(UIMode.EDIT);
        this.updateProgressVisibility();
        if (this.startEditingListener != null) {
            this.startEditingListener.onStartEditing();
        }
        this.triggerStartEditingTransition(propertyAnimator);
    }

    public String cancelEdit() {
        Telemetry.stopUISession(TelemetryContract.Session.AWESOMESCREEN);
        return this.stopEditing();
    }

    public String commitEdit() {
        String string2 = this.stopEditing();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.setTitle(string2);
        }
        return string2;
    }

    private String stopEditing() {
        String string2 = this.urlEditLayout.getText();
        if (!this.isEditing()) {
            return string2;
        }
        this.setUIMode(UIMode.DISPLAY);
        if (this.stopEditingListener != null) {
            this.stopEditingListener.onStopEditing();
        }
        this.updateProgressVisibility();
        this.triggerStopEditingTransition();
        return string2;
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.tabsButton.setPrivateMode(bl);
        this.menuButton.setPrivateMode(bl);
        this.menuIcon.setPrivateMode(bl);
        this.urlEditLayout.setPrivateMode(bl);
    }

    public void show() {
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
    }

    public View getDoorHangerAnchor() {
        return this.urlDisplayLayout;
    }

    public void onDestroy() {
        Tabs.unregisterOnTabsChangedListener(this);
    }

    public boolean openOptionsMenu() {
        if (!this.hasSoftMenuButton) {
            return false;
        }
        if (this.menuPopup == null) {
            MenuPanel menuPanel = this.activity.getMenuPanel();
            this.menuPopup = new MenuPopup((Context)this.activity);
            this.menuPopup.setPanelView((View)menuPanel);
            this.menuPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    BrowserToolbar.this.activity.onOptionsMenuClosed(null);
                }
            });
        }
        GeckoAppShell.getGeckoInterface().invalidateOptionsMenu();
        if (!this.menuPopup.isShowing()) {
            this.menuPopup.showAsDropDown((View)this.menuButton);
        }
        return true;
    }

    public boolean closeOptionsMenu() {
        if (!this.hasSoftMenuButton) {
            return false;
        }
        if (this.menuPopup != null && this.menuPopup.isShowing()) {
            this.menuPopup.dismiss();
        }
        return true;
    }

    @Override
    public void onLightweightThemeChanged() {
        Drawable drawable2 = this.getLWTDefaultStateSetDrawable();
        if (drawable2 == null) {
            return;
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.private_toolbar_grey));
        stateListDrawable.addState(EMPTY_STATE_SET, drawable2);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    @Override
    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.url_bar_bg);
    }

    public static LightweightThemeDrawable getLightweightThemeDrawable(View view, Resources resources, LightweightTheme lightweightTheme, int n) {
        int n2 = resources.getColor(n);
        LightweightThemeDrawable lightweightThemeDrawable = lightweightTheme.getColorDrawable(view, n2);
        if (lightweightThemeDrawable != null) {
            lightweightThemeDrawable.setAlpha(34, 34);
        }
        return lightweightThemeDrawable;
    }

    public void setContextMenuEnabled(boolean bl) {
        this.contextMenuEnabled = bl;
    }

    public static class TabEditingState {
        protected String lastEditingText;
        protected int selectionStart;
        protected int selectionEnd;
        public boolean isBrowserSearchShown;

        public void copyFrom(TabEditingState tabEditingState) {
            this.lastEditingText = tabEditingState.lastEditingText;
            this.selectionStart = tabEditingState.selectionStart;
            this.selectionEnd = tabEditingState.selectionEnd;
            this.isBrowserSearchShown = tabEditingState.isBrowserSearchShown;
        }

        public boolean isBrowserSearchShown() {
            return this.isBrowserSearchShown;
        }

        public void setIsBrowserSearchShown(boolean bl) {
            this.isBrowserSearchShown = bl;
        }
    }

    protected static enum UIMode {
        EDIT,
        DISPLAY;

    }

    public static interface OnStopEditingListener {
        public void onStopEditing();
    }

    public static interface OnStartEditingListener {
        public void onStartEditing();
    }

    public static interface OnFilterListener {
        public void onFilter(String var1, AutocompleteHandler var2);
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    public static interface OnCommitListener {
        public void onCommit();
    }

    public static interface OnActivateListener {
        public void onActivate();
    }
}

