/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.widget.AnchoredPopup;
import org.mozilla.gecko.widget.DoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;

public class SiteIdentityPopup
extends AnchoredPopup {
    private static final String LOGTAG = "GeckoSiteIdentityPopup";
    private static final String MIXED_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android";
    private static final String TRACKING_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/firefox-android-tracking-protection";
    private SiteIdentity mSiteIdentity;
    private LinearLayout mIdentity;
    private LinearLayout mIdentityKnownContainer;
    private LinearLayout mIdentityUnknownContainer;
    private TextView mHost;
    private TextView mOwnerLabel;
    private TextView mOwner;
    private TextView mVerifier;
    private View mDivider;
    private DoorHanger mMixedContentNotification;
    private DoorHanger mTrackingContentNotification;
    private final DoorHanger.OnButtonClickListener mButtonClickListener = new PopupButtonListener();

    public SiteIdentityPopup(Context context) {
        super(context);
    }

    @Override
    protected void init() {
        super.init();
        this.setFocusable(true);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mIdentity = (LinearLayout)layoutInflater.inflate(R.layout.site_identity, null);
        this.mContent.addView((View)this.mIdentity);
        this.mIdentityKnownContainer = (LinearLayout)this.mIdentity.findViewById(R.id.site_identity_known_container);
        this.mIdentityUnknownContainer = (LinearLayout)this.mIdentity.findViewById(R.id.site_identity_unknown_container);
        this.mHost = (TextView)this.mIdentityKnownContainer.findViewById(R.id.host);
        this.mOwnerLabel = (TextView)this.mIdentityKnownContainer.findViewById(R.id.owner_label);
        this.mOwner = (TextView)this.mIdentityKnownContainer.findViewById(R.id.owner);
        this.mVerifier = (TextView)this.mIdentityKnownContainer.findViewById(R.id.verifier);
        this.mDivider = this.mIdentity.findViewById(R.id.divider_doorhanger);
        TextView textView = (TextView)this.mIdentity.findViewById(R.id.site_settings_link);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Permissions:Get", null));
                SiteIdentityPopup.this.dismiss();
            }
        });
    }

    private void updateIdentity(SiteIdentity siteIdentity) {
        if (!this.mInflated) {
            this.init();
        }
        boolean bl = siteIdentity.getSecurityMode() != SiteIdentity.SecurityMode.UNKNOWN;
        this.toggleIdentityKnownContainerVisibility(bl);
        if (bl) {
            this.updateIdentityInformation(siteIdentity);
        }
    }

    private void toggleIdentityKnownContainerVisibility(boolean bl) {
        if (bl) {
            this.mIdentityKnownContainer.setVisibility(0);
            this.mIdentityUnknownContainer.setVisibility(8);
        } else {
            this.mIdentityKnownContainer.setVisibility(8);
            this.mIdentityUnknownContainer.setVisibility(0);
        }
    }

    private void updateIdentityInformation(SiteIdentity siteIdentity) {
        String string2;
        this.mHost.setText((CharSequence)siteIdentity.getHost());
        String string3 = siteIdentity.getOwner();
        if (string3 == null) {
            this.mOwnerLabel.setVisibility(8);
            this.mOwner.setVisibility(8);
        } else {
            this.mOwnerLabel.setVisibility(0);
            this.mOwner.setVisibility(0);
            string2 = siteIdentity.getSupplemental();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string3 = string3 + "\n" + string2;
            }
            this.mOwner.setText((CharSequence)string3);
        }
        string2 = siteIdentity.getVerifier();
        String string4 = siteIdentity.getEncrypted();
        this.mVerifier.setText((CharSequence)(string2 + "\n" + string4));
    }

    private void addMixedContentNotification(boolean bl) {
        int n;
        this.removeMixedContentNotification();
        DoorhangerConfig doorhangerConfig = new DoorhangerConfig(DoorHanger.Type.MIXED_CONTENT, this.mButtonClickListener);
        if (bl) {
            n = R.drawable.shield_enabled_doorhanger;
            doorhangerConfig.setMessage(this.mContext.getString(R.string.blocked_mixed_content_message_top) + "\n\n" + this.mContext.getString(R.string.blocked_mixed_content_message_bottom));
        } else {
            n = R.drawable.shield_disabled_doorhanger;
            doorhangerConfig.setMessage(this.mContext.getString(R.string.loaded_mixed_content_message));
        }
        doorhangerConfig.setLink(this.mContext.getString(R.string.learn_more), MIXED_CONTENT_SUPPORT_URL, "\n\n");
        this.addNotificationButtons(doorhangerConfig, bl);
        this.mMixedContentNotification = DoorHanger.Get(this.mContext, doorhangerConfig);
        this.mMixedContentNotification.setIcon(n);
        this.mContent.addView((View)this.mMixedContentNotification);
        this.mDivider.setVisibility(0);
    }

    private void removeMixedContentNotification() {
        if (this.mMixedContentNotification != null) {
            this.mContent.removeView((View)this.mMixedContentNotification);
            this.mMixedContentNotification = null;
        }
    }

    private void addTrackingContentNotification(boolean bl) {
        int n;
        this.removeTrackingContentNotification();
        DoorhangerConfig doorhangerConfig = new DoorhangerConfig(DoorHanger.Type.TRACKING, this.mButtonClickListener);
        if (bl) {
            n = R.drawable.shield_enabled_doorhanger;
            doorhangerConfig.setMessage(this.mContext.getString(R.string.blocked_tracking_content_message_top) + "\n\n" + this.mContext.getString(R.string.blocked_tracking_content_message_bottom));
        } else {
            n = R.drawable.shield_disabled_doorhanger;
            doorhangerConfig.setMessage(this.mContext.getString(R.string.loaded_tracking_content_message_top) + "\n\n" + this.mContext.getString(R.string.loaded_tracking_content_message_bottom));
        }
        doorhangerConfig.setLink(this.mContext.getString(R.string.learn_more), TRACKING_CONTENT_SUPPORT_URL, "\n\n");
        this.addNotificationButtons(doorhangerConfig, bl);
        this.mTrackingContentNotification = DoorHanger.Get(this.mContext, doorhangerConfig);
        this.mTrackingContentNotification.setIcon(n);
        this.mContent.addView((View)this.mTrackingContentNotification);
        this.mDivider.setVisibility(0);
    }

    private void removeTrackingContentNotification() {
        if (this.mTrackingContentNotification != null) {
            this.mContent.removeView((View)this.mTrackingContentNotification);
            this.mTrackingContentNotification = null;
        }
    }

    private void addNotificationButtons(DoorhangerConfig doorhangerConfig, boolean bl) {
        if (bl) {
            doorhangerConfig.appendButton(this.mContext.getString(R.string.disable_protection), ButtonType.DISABLE.ordinal());
            doorhangerConfig.appendButton(this.mContext.getString(R.string.keep_blocking), ButtonType.KEEP_BLOCKING.ordinal());
        } else {
            doorhangerConfig.appendButton(this.mContext.getString(R.string.enable_protection), ButtonType.ENABLE.ordinal());
        }
    }

    void setSiteIdentity(SiteIdentity siteIdentity) {
        this.mSiteIdentity = siteIdentity;
    }

    @Override
    public void show() {
        SiteIdentity.TrackingMode trackingMode;
        if (this.mSiteIdentity == null) {
            Log.e((String)LOGTAG, (String)"Can't show site identity popup for undefined state");
            return;
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null && AboutPages.isAboutPage(tab.getURL())) {
            Log.d((String)LOGTAG, (String)"We don't show site identity popups for about: pages");
            return;
        }
        this.updateIdentity(this.mSiteIdentity);
        SiteIdentity.MixedMode mixedMode = this.mSiteIdentity.getMixedMode();
        if (mixedMode != SiteIdentity.MixedMode.UNKNOWN) {
            this.addMixedContentNotification(mixedMode == SiteIdentity.MixedMode.MIXED_CONTENT_BLOCKED);
        }
        if ((trackingMode = this.mSiteIdentity.getTrackingMode()) != SiteIdentity.TrackingMode.UNKNOWN) {
            this.addTrackingContentNotification(trackingMode == SiteIdentity.TrackingMode.TRACKING_CONTENT_BLOCKED);
        }
        this.showDividers();
        super.show();
    }

    private void showDividers() {
        int n = this.mContent.getChildCount();
        DoorHanger doorHanger = null;
        for (int i = 0; i < n; ++i) {
            View view = this.mContent.getChildAt(i);
            if (!(view instanceof DoorHanger)) continue;
            DoorHanger doorHanger2 = (DoorHanger)view;
            doorHanger2.showDivider();
            if (doorHanger2.getVisibility() != 0) continue;
            doorHanger = doorHanger2;
        }
        if (doorHanger != null) {
            doorHanger.hideDivider();
        }
    }

    public void dismiss() {
        super.dismiss();
        this.removeMixedContentNotification();
        this.removeTrackingContentNotification();
        this.mDivider.setVisibility(8);
    }

    private class PopupButtonListener
    implements DoorHanger.OnButtonClickListener {
        private PopupButtonListener() {
        }

        @Override
        public void onButtonClick(JSONObject jSONObject, DoorHanger doorHanger) {
            GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:Reload", jSONObject.toString());
            GeckoAppShell.sendEventToGecko(geckoEvent);
            SiteIdentityPopup.this.dismiss();
        }
    }

    public static enum ButtonType {
        DISABLE,
        ENABLE,
        KEEP_BLOCKING;

    }
}

