/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.prompts.PromptInput;
import org.mozilla.gecko.toolbar.SiteIdentityPopup;
import org.mozilla.gecko.widget.DoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;

public class DefaultDoorHanger
extends DoorHanger {
    private static final String LOGTAG = "GeckoDefaultDoorHanger";
    private static int sSpinnerTextColor = -1;
    private List<PromptInput> mInputs;
    private CheckBox mCheckBox;

    public DefaultDoorHanger(Context context, DoorhangerConfig doorhangerConfig, DoorHanger.Type type) {
        super(context, doorhangerConfig, type);
        if (sSpinnerTextColor == -1) {
            sSpinnerTextColor = this.mResources.getColor(R.color.text_color_primary_disable_only);
        }
        this.loadConfig(doorhangerConfig);
    }

    @Override
    protected void loadConfig(DoorhangerConfig doorhangerConfig) {
        DoorhangerConfig.Link link;
        JSONObject jSONObject;
        String string2 = doorhangerConfig.getMessage();
        if (string2 != null) {
            this.setMessage(string2);
        }
        if ((jSONObject = doorhangerConfig.getOptions()) != null) {
            this.setOptions(jSONObject);
        }
        if ((link = doorhangerConfig.getLink()) != null) {
            this.addLink(link.label, link.url, link.delimiter);
        }
        this.setButtons(doorhangerConfig);
    }

    private List<PromptInput> getInputs() {
        return this.mInputs;
    }

    private CheckBox getCheckBox() {
        return this.mCheckBox;
    }

    @Override
    public void setOptions(JSONObject jSONObject) {
        String string2;
        Object object;
        super.setOptions(jSONObject);
        JSONObject jSONObject2 = jSONObject.optJSONObject("link");
        if (jSONObject2 != null) {
            try {
                object = jSONObject2.getString("label");
                string2 = jSONObject2.getString("url");
                this.addLink((String)object, string2, " ");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if ((object = jSONObject.optJSONArray("inputs")) != null) {
            this.mInputs = new ArrayList<PromptInput>();
            string2 = (ViewGroup)this.findViewById(R.id.doorhanger_inputs);
            string2.setVisibility(0);
            for (int i = 0; i < object.length(); ++i) {
                try {
                    PromptInput promptInput = PromptInput.getInput(object.getJSONObject(i));
                    this.mInputs.add(promptInput);
                    int n = this.mResources.getDimensionPixelSize(R.dimen.doorhanger_padding);
                    View view = promptInput.getView(this.getContext());
                    this.styleInput(promptInput, view);
                    view.setPadding(0, 0, 0, n);
                    string2.addView(view);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = jSONObject.optString("checkbox")))) {
            this.mCheckBox = (CheckBox)this.findViewById(R.id.doorhanger_checkbox);
            this.mCheckBox.setText((CharSequence)string2);
            this.mCheckBox.setVisibility(0);
        }
    }

    @Override
    protected Button createButtonInstance(String string2, final int n) {
        Button button = (Button)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.doorhanger_button, null);
        button.setText((CharSequence)string2);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                JSONObject jSONObject = new JSONObject();
                try {
                    switch (DefaultDoorHanger.this.mType) {
                        case MIXED_CONTENT: {
                            jSONObject.put("allowContent", n == SiteIdentityPopup.ButtonType.DISABLE.ordinal());
                            jSONObject.put("contentType", (Object)"mixed");
                            break;
                        }
                        case TRACKING: {
                            jSONObject.put("allowContent", n == SiteIdentityPopup.ButtonType.DISABLE.ordinal());
                            jSONObject.put("contentType", (Object)"tracking");
                            break;
                        }
                        default: {
                            List list;
                            jSONObject.put("callback", n);
                            CheckBox checkBox = DefaultDoorHanger.this.getCheckBox();
                            if (checkBox != null) {
                                jSONObject.put("checked", checkBox.isChecked());
                            }
                            if ((list = DefaultDoorHanger.this.getInputs()) == null) break;
                            JSONObject jSONObject2 = new JSONObject();
                            for (PromptInput promptInput : list) {
                                jSONObject2.put(promptInput.getId(), promptInput.getValue());
                            }
                            jSONObject.put("inputs", (Object)jSONObject2);
                        }
                    }
                    DefaultDoorHanger.this.mOnButtonClickListener.onButtonClick(jSONObject, DefaultDoorHanger.this);
                }
                catch (JSONException jSONException) {
                    Log.e((String)DefaultDoorHanger.LOGTAG, (String)"Error creating onClick response", (Throwable)jSONException);
                }
            }
        });
        return button;
    }

    private void styleInput(PromptInput promptInput, View view) {
        if (promptInput instanceof PromptInput.MenulistInput) {
            this.styleDropdownInputs(promptInput, view);
        }
        view.setPadding(0, 0, 0, this.mResources.getDimensionPixelSize(R.dimen.doorhanger_padding));
    }

    private void styleDropdownInputs(PromptInput promptInput, View view) {
        PromptInput.MenulistInput menulistInput = (PromptInput.MenulistInput)promptInput;
        if (menulistInput.textView != null) {
            menulistInput.textView.setTextColor(sSpinnerTextColor);
        }
    }
}

