/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.Resources;
import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.style.ForegroundColorSpan;
import android.text.style.URLSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.widget.DefaultDoorHanger;
import org.mozilla.gecko.widget.Divider;
import org.mozilla.gecko.widget.DoorhangerConfig;
import org.mozilla.gecko.widget.LoginDoorHanger;

public abstract class DoorHanger
extends LinearLayout {
    protected static final LinearLayout.LayoutParams sButtonParams = new LinearLayout.LayoutParams(-1, -1, 1.0f);
    private static final String LOGTAG = "GeckoDoorHanger";
    private final View mDivider;
    protected final LinearLayout mButtonsContainer;
    protected final OnButtonClickListener mOnButtonClickListener;
    private final int mTabId;
    private final String mIdentifier;
    protected final Type mType;
    private final ImageView mIcon;
    private final TextView mMessage;
    protected final Context mContext;
    protected final Resources mResources;
    protected int mDividerColor;
    protected boolean mPersistWhileVisible;
    protected int mPersistenceCount;
    protected long mTimeout;

    public static DoorHanger Get(Context context, DoorhangerConfig doorhangerConfig) {
        Type type = doorhangerConfig.getType();
        switch (type) {
            case LOGIN: {
                return new LoginDoorHanger(context, doorhangerConfig);
            }
            case TRACKING: 
            case MIXED_CONTENT: {
                return new DefaultDoorHanger(context, doorhangerConfig, type);
            }
        }
        return new DefaultDoorHanger(context, doorhangerConfig, type);
    }

    protected DoorHanger(Context context, DoorhangerConfig doorhangerConfig, Type type) {
        super(context);
        int n;
        this.mContext = context;
        this.mResources = context.getResources();
        this.mTabId = doorhangerConfig.getTabId();
        this.mIdentifier = doorhangerConfig.getId();
        switch (type) {
            case LOGIN: {
                n = R.layout.login_doorhanger;
                break;
            }
            default: {
                n = R.layout.doorhanger;
            }
        }
        LayoutInflater.from((Context)context).inflate(n, (ViewGroup)this);
        this.mDivider = this.findViewById(R.id.divider_doorhanger);
        this.mIcon = (ImageView)this.findViewById(R.id.doorhanger_icon);
        this.mMessage = (TextView)this.findViewById(R.id.doorhanger_message);
        if (type == Type.TRACKING || type == Type.MIXED_CONTENT) {
            this.mMessage.setTextAppearance(this.getContext(), R.style.TextAppearance_DoorHanger_Small);
        }
        this.mType = type;
        this.mButtonsContainer = (LinearLayout)this.findViewById(R.id.doorhanger_buttons);
        this.mOnButtonClickListener = doorhangerConfig.getButtonClickListener();
        this.mDividerColor = this.mResources.getColor(R.color.divider_light);
        this.setOrientation(1);
    }

    protected abstract void loadConfig(DoorhangerConfig var1);

    protected void setOptions(JSONObject jSONObject) {
        int n = jSONObject.optInt("persistence");
        if (n > 0) {
            this.mPersistenceCount = n;
        }
        this.mPersistWhileVisible = jSONObject.optBoolean("persistWhileVisible");
        long l = jSONObject.optLong("timeout");
        if (l > 0L) {
            this.mTimeout = l;
        }
    }

    protected void setButtons(DoorhangerConfig doorhangerConfig) {
        JSONArray jSONArray = doorhangerConfig.getButtons();
        OnButtonClickListener onButtonClickListener = doorhangerConfig.getButtonClickListener();
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                String string2 = jSONObject.getString("label");
                int n = jSONObject.getInt("callback");
                this.addButtonToLayout(string2, n);
                continue;
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error creating doorhanger button", (Throwable)jSONException);
            }
        }
    }

    public int getTabId() {
        return this.mTabId;
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public void showDivider() {
        this.mDivider.setVisibility(0);
    }

    public void hideDivider() {
        this.mDivider.setVisibility(8);
    }

    public void setIcon(int n) {
        this.mIcon.setImageResource(n);
        this.mIcon.setVisibility(0);
    }

    protected void setMessage(String string2) {
        Spanned spanned = Html.fromHtml((String)string2);
        this.mMessage.setText((CharSequence)spanned);
    }

    protected void addLink(String string2, String string3, String string4) {
        String string5 = this.mMessage.getText().toString();
        SpannableString spannableString = new SpannableString((CharSequence)(string5 + string4 + string2));
        URLSpan uRLSpan = new URLSpan(string3){

            public void onClick(View view) {
                Tabs.getInstance().loadUrlInTab(this.getURL());
            }
        };
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(this.mMessage.getCurrentTextColor());
        spannableString.setSpan((Object)foregroundColorSpan, 0, string5.length(), 0);
        spannableString.setSpan((Object)uRLSpan, string5.length() + 1, spannableString.length(), 0);
        this.mMessage.setText((CharSequence)spannableString);
        this.mMessage.setMovementMethod(LinkMovementMethod.getInstance());
    }

    private void addButtonToLayout(String string2, int n) {
        Button button = this.createButtonInstance(string2, n);
        if (this.mButtonsContainer.getChildCount() == 0) {
            this.mButtonsContainer.setVisibility(0);
            View view = this.findViewById(R.id.divider_buttons);
            view.setVisibility(0);
        } else {
            Divider divider = new Divider(this.getContext(), null);
            divider.setOrientation(Divider.Orientation.VERTICAL);
            divider.setBackgroundColor(this.mDividerColor);
            this.mButtonsContainer.addView((View)divider);
        }
        this.mButtonsContainer.addView((View)button, (ViewGroup.LayoutParams)sButtonParams);
    }

    protected abstract Button createButtonInstance(String var1, int var2);

    public boolean shouldRemove(boolean bl) {
        if (this.mPersistWhileVisible && bl) {
            if (this.mPersistenceCount != 0) {
                --this.mPersistenceCount;
            }
            return false;
        }
        if (this.mPersistenceCount != 0) {
            --this.mPersistenceCount;
            return false;
        }
        return System.currentTimeMillis() > this.mTimeout;
    }

    public static interface OnButtonClickListener {
        public void onButtonClick(JSONObject var1, DoorHanger var2);
    }

    public static enum Type {
        DEFAULT,
        LOGIN,
        TRACKING,
        MIXED_CONTENT;

    }
}

