/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import ch.boye.httpclientandroidlib.util.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.widget.DoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;

public class LoginDoorHanger
extends DoorHanger {
    private static final String LOGTAG = "LoginDoorHanger";
    private final TextView mTitle = (TextView)this.findViewById(R.id.doorhanger_title);
    private final TextView mLogin = (TextView)this.findViewById(R.id.doorhanger_login);
    private int mCallbackID;

    public LoginDoorHanger(Context context, DoorhangerConfig doorhangerConfig) {
        super(context, doorhangerConfig, DoorHanger.Type.LOGIN);
        this.loadConfig(doorhangerConfig);
    }

    @Override
    protected void loadConfig(DoorhangerConfig doorhangerConfig) {
        this.setOptions(doorhangerConfig.getOptions());
        this.setMessage(doorhangerConfig.getMessage());
        this.setButtons(doorhangerConfig);
    }

    @Override
    protected void setOptions(JSONObject jSONObject) {
        Object object;
        super.setOptions(jSONObject);
        JSONObject jSONObject2 = jSONObject.optJSONObject("title");
        if (jSONObject2 != null) {
            try {
                object = jSONObject2.getString("text");
                this.mTitle.setText((CharSequence)object);
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error loading title from options JSON", (Throwable)jSONException);
            }
            object = jSONObject2.optString("resource");
            if (object != null) {
                Favicons.getSizedFaviconForPageFromLocal(this.mContext, (String)object, 32, new OnFaviconLoadedListener(){

                    @Override
                    public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
                        if (bitmap != null) {
                            LoginDoorHanger.this.mTitle.setCompoundDrawablesWithIntrinsicBounds((Drawable)new BitmapDrawable(LoginDoorHanger.this.mResources, bitmap), null, null, null);
                            LoginDoorHanger.this.mTitle.setCompoundDrawablePadding((int)LoginDoorHanger.this.mResources.getDimension(R.dimen.doorhanger_drawable_padding));
                        }
                    }
                });
            }
        }
        object = jSONObject.optJSONObject("actionText");
        this.addActionText((JSONObject)object);
    }

    @Override
    protected Button createButtonInstance(String string2, final int n) {
        this.mCallbackID = n;
        Button button = (Button)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.doorhanger_button, null);
        button.setText((CharSequence)string2);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("callback", n);
                }
                catch (JSONException jSONException) {
                    Log.e((String)LoginDoorHanger.LOGTAG, (String)"Error making doorhanger response message", (Throwable)jSONException);
                }
                LoginDoorHanger.this.mOnButtonClickListener.onButtonClick(jSONObject, LoginDoorHanger.this);
            }
        });
        return button;
    }

    private void addActionText(JSONObject jSONObject) {
        block7: {
            if (jSONObject == null) {
                this.mLogin.setVisibility(8);
                return;
            }
            boolean bl = true;
            String string2 = jSONObject.optString("text");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                bl = false;
                string2 = this.mResources.getString(R.string.doorhanger_login_no_username);
            }
            this.mLogin.setText((CharSequence)string2);
            this.mLogin.setVisibility(0);
            try {
                AlertDialog alertDialog;
                JSONObject jSONObject2 = jSONObject.getJSONObject("bundle");
                ActionType actionType = ActionType.valueOf(jSONObject.getString("type"));
                AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
                switch (actionType) {
                    case EDIT: {
                        builder.setTitle((CharSequence)this.mResources.getString(R.string.doorhanger_login_edit_title));
                        alertDialog = LayoutInflater.from((Context)this.mContext).inflate(R.layout.login_edit_dialog, null);
                        final EditText editText = (EditText)alertDialog.findViewById(R.id.username_edit);
                        editText.setText((CharSequence)jSONObject2.getString("username"));
                        final EditText editText2 = (EditText)alertDialog.findViewById(R.id.password_edit);
                        editText2.setText((CharSequence)jSONObject2.getString("password"));
                        CheckBox checkBox = (CheckBox)alertDialog.findViewById(R.id.checkbox_toggle_password);
                        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                            public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                                if (bl) {
                                    editText2.setTransformationMethod(null);
                                } else {
                                    editText2.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                                }
                            }
                        });
                        builder.setView((View)alertDialog);
                        builder.setPositiveButton(R.string.button_remember, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int n) {
                                JSONObject jSONObject = new JSONObject();
                                try {
                                    jSONObject.put("callback", LoginDoorHanger.this.mCallbackID);
                                    JSONObject jSONObject2 = new JSONObject();
                                    jSONObject2.put("username", (Object)editText.getText());
                                    jSONObject2.put("password", (Object)editText2.getText());
                                    jSONObject.put("inputs", (Object)jSONObject2);
                                }
                                catch (JSONException jSONException) {
                                    Log.e((String)LoginDoorHanger.LOGTAG, (String)"Error creating doorhanger reply message");
                                    jSONObject = null;
                                    Toast.makeText((Context)LoginDoorHanger.this.mContext, (CharSequence)LoginDoorHanger.this.mResources.getString(R.string.doorhanger_login_edit_toast_error), (int)0).show();
                                }
                                LoginDoorHanger.this.mOnButtonClickListener.onButtonClick(jSONObject, LoginDoorHanger.this);
                            }
                        });
                        builder.setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int n) {
                                dialogInterface.dismiss();
                            }
                        });
                    }
                }
                alertDialog = builder.create();
                this.mLogin.setOnClickListener(new View.OnClickListener((Dialog)alertDialog){
                    final /* synthetic */ Dialog val$dialog;
                    {
                        this.val$dialog = dialog;
                    }

                    public void onClick(View view) {
                        this.val$dialog.show();
                    }
                });
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error fetching actionText from JSON", (Throwable)jSONException);
                if (bl) break block7;
                this.mLogin.setVisibility(8);
            }
        }
    }

    private static enum ActionType {
        EDIT;

    }
}

