/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;

public class ResizablePathDrawable
extends ShapeDrawable {
    private int alpha = 255;
    private final ColorStateList colorStateList;
    private int currentColor;

    public ResizablePathDrawable(NonScaledPathShape nonScaledPathShape, int n) {
        this(nonScaledPathShape, ColorStateList.valueOf((int)n));
    }

    public ResizablePathDrawable(NonScaledPathShape nonScaledPathShape, ColorStateList colorStateList) {
        super((Shape)nonScaledPathShape);
        this.colorStateList = colorStateList;
        this.updateColor(this.getState());
    }

    private boolean updateColor(int[] nArray) {
        int n = this.colorStateList.getColorForState(nArray, -1);
        if (n != this.currentColor) {
            this.currentColor = n;
            this.alpha = Color.alpha((int)this.currentColor);
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    public Path getPath() {
        NonScaledPathShape nonScaledPathShape = (NonScaledPathShape)this.getShape();
        return nonScaledPathShape.path;
    }

    public boolean isStateful() {
        return true;
    }

    protected void onDraw(Shape shape, Canvas canvas, Paint paint) {
        paint.setColor(this.currentColor);
        if (this.currentColor != 0) {
            paint.setAlpha(this.alpha);
        }
        super.onDraw(shape, canvas, paint);
    }

    public void setAlpha(int n) {
        super.setAlpha(n);
        this.alpha = n;
    }

    protected boolean onStateChange(int[] nArray) {
        return this.updateColor(nArray);
    }

    public static class NonScaledPathShape
    extends Shape {
        private Path path = new Path();

        public void draw(Canvas canvas, Paint paint) {
            if (paint.getColor() == 0) {
                return;
            }
            canvas.drawPath(this.path, paint);
        }

        protected Path getPath() {
            return this.path;
        }

        public NonScaledPathShape clone() throws CloneNotSupportedException {
            NonScaledPathShape nonScaledPathShape = (NonScaledPathShape)super.clone();
            nonScaledPathShape.path = new Path(this.path);
            return nonScaledPathShape;
        }
    }
}

