/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.client.methods.CloseableHttpResponse;
import ch.boye.httpclientandroidlib.client.methods.HttpExecutionAware;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestWrapper;
import ch.boye.httpclientandroidlib.client.protocol.HttpClientContext;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.impl.client.cache.AsynchronousValidator;
import ch.boye.httpclientandroidlib.impl.client.cache.CachingExec;
import java.io.IOException;

class AsynchronousValidationRequest
implements Runnable {
    private final AsynchronousValidator parent;
    private final CachingExec cachingExec;
    private final HttpRoute route;
    private final HttpRequestWrapper request;
    private final HttpClientContext context;
    private final HttpExecutionAware execAware;
    private final HttpCacheEntry cacheEntry;
    private final String identifier;
    private final int consecutiveFailedAttempts;
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());

    AsynchronousValidationRequest(AsynchronousValidator asynchronousValidator, CachingExec cachingExec, HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware, HttpCacheEntry httpCacheEntry, String string, int n) {
        this.parent = asynchronousValidator;
        this.cachingExec = cachingExec;
        this.route = httpRoute;
        this.request = httpRequestWrapper;
        this.context = httpClientContext;
        this.execAware = httpExecutionAware;
        this.cacheEntry = httpCacheEntry;
        this.identifier = string;
        this.consecutiveFailedAttempts = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.revalidateCacheEntry()) {
                this.parent.jobSuccessful(this.identifier);
            } else {
                this.parent.jobFailed(this.identifier);
            }
        }
        finally {
            this.parent.markComplete(this.identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean revalidateCacheEntry() {
        boolean bl;
        CloseableHttpResponse closeableHttpResponse = this.cachingExec.revalidateCacheEntry(this.route, this.request, this.context, this.execAware, this.cacheEntry);
        try {
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            bl = this.isNotServerError(n) && this.isNotStale(closeableHttpResponse);
        }
        catch (Throwable throwable) {
            try {
                closeableHttpResponse.close();
                throw throwable;
            }
            catch (IOException iOException) {
                this.log.debug("Asynchronous revalidation failed due to I/O error", iOException);
                return false;
            }
            catch (HttpException httpException) {
                this.log.error("HTTP protocol exception during asynchronous revalidation", httpException);
                return false;
            }
            catch (RuntimeException runtimeException) {
                this.log.error("RuntimeException thrown during asynchronous revalidation: " + runtimeException);
                return false;
            }
        }
        closeableHttpResponse.close();
        return bl;
    }

    private boolean isNotServerError(int n) {
        return n < 500;
    }

    private boolean isNotStale(HttpResponse httpResponse) {
        Header[] headerArray = httpResponse.getHeaders("Warning");
        if (headerArray != null) {
            for (Header header : headerArray) {
                String string = header.getValue();
                if (!string.startsWith("110") && !string.startsWith("111")) continue;
                return false;
            }
        }
        return true;
    }

    String getIdentifier() {
        return this.identifier;
    }

    public int getConsecutiveFailedAttempts() {
        return this.consecutiveFailedAttempts;
    }
}

