/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search.autocomplete;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.search.AcceptsSearchQuery;
import org.mozilla.search.autocomplete.SuggestionsFragment;

class AutoCompleteAdapter
extends ArrayAdapter<SuggestionsFragment.Suggestion> {
    private final AcceptsSearchQuery searchListener;
    private final LayoutInflater inflater;

    public AutoCompleteAdapter(Context context) {
        super(context, 0);
        if (!(context instanceof AcceptsSearchQuery)) {
            throw new ClassCastException(context.toString() + " must implement AcceptsSearchQuery.");
        }
        this.searchListener = (AcceptsSearchQuery)context;
        this.setNotifyOnChange(false);
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        if (view == null) {
            view = this.inflater.inflate(R.layout.search_suggestions_row, null);
        }
        final SuggestionsFragment.Suggestion suggestion = (SuggestionsFragment.Suggestion)this.getItem(n);
        TextView textView = (TextView)view.findViewById(R.id.auto_complete_row_text);
        textView.setText((CharSequence)suggestion.display);
        View view2 = view.findViewById(R.id.auto_complete_row_jump_button);
        view2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AutoCompleteAdapter.this.searchListener.onSuggest(suggestion.value);
            }
        });
        return view;
    }

    public void update(List<SuggestionsFragment.Suggestion> list) {
        this.clear();
        if (list != null) {
            for (SuggestionsFragment.Suggestion suggestion : list) {
                this.add(suggestion);
            }
        }
        this.notifyDataSetChanged();
    }
}

