/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.client.methods.HttpExecutionAware;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestWrapper;
import ch.boye.httpclientandroidlib.client.protocol.HttpClientContext;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.impl.client.cache.AsynchronousValidationRequest;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheConfig;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheKeyGenerator;
import ch.boye.httpclientandroidlib.impl.client.cache.CachingExec;
import ch.boye.httpclientandroidlib.impl.client.cache.DefaultFailureCache;
import ch.boye.httpclientandroidlib.impl.client.cache.FailureCache;
import ch.boye.httpclientandroidlib.impl.client.cache.ImmediateSchedulingStrategy;
import ch.boye.httpclientandroidlib.impl.client.cache.SchedulingStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;

class AsynchronousValidator
implements Closeable {
    private final SchedulingStrategy schedulingStrategy;
    private final Set<String> queued;
    private final CacheKeyGenerator cacheKeyGenerator;
    private final FailureCache failureCache;
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());

    public AsynchronousValidator(CacheConfig cacheConfig) {
        this(new ImmediateSchedulingStrategy(cacheConfig));
    }

    AsynchronousValidator(SchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
        this.queued = new HashSet<String>();
        this.cacheKeyGenerator = new CacheKeyGenerator();
        this.failureCache = new DefaultFailureCache();
    }

    @Override
    public void close() throws IOException {
        this.schedulingStrategy.close();
    }

    public synchronized void revalidateCacheEntry(CachingExec cachingExec, HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware, HttpCacheEntry httpCacheEntry) {
        String string = this.cacheKeyGenerator.getVariantURI(httpClientContext.getTargetHost(), httpRequestWrapper, httpCacheEntry);
        if (!this.queued.contains(string)) {
            int n = this.failureCache.getErrorCount(string);
            AsynchronousValidationRequest asynchronousValidationRequest = new AsynchronousValidationRequest(this, cachingExec, httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware, httpCacheEntry, string, n);
            try {
                this.schedulingStrategy.schedule(asynchronousValidationRequest);
                this.queued.add(string);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.log.debug("Revalidation for [" + string + "] not scheduled: " + rejectedExecutionException);
            }
        }
    }

    synchronized void markComplete(String string) {
        this.queued.remove(string);
    }

    void jobSuccessful(String string) {
        this.failureCache.resetErrorCount(string);
    }

    void jobFailed(String string) {
        this.failureCache.increaseErrorCount(string);
    }

    Set<String> getScheduledIdentifiers() {
        return Collections.unmodifiableSet(this.queued);
    }
}

