/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.Build;
import android.os.StrictMode;
import android.util.Log;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Pattern;

public final class SysInfo {
    private static final String LOG_TAG = "GeckoSysInfo";
    private static final int MEMINFO_BUFFER_SIZE_BYTES = 256;
    private static volatile int cpuCount = -1;
    private static volatile int totalRAM = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCPUCount() {
        if (cpuCount > 0) {
            return cpuCount;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            int n = SysInfo.readCPUCount();
            return n;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private static int readCPUCount() {
        try {
            File file = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File file) {
                    return Pattern.matches("cpu[0-9]+", file.getName());
                }
            }
            cpuCount = file.listFiles(new CpuFilter()).length;
            return cpuCount;
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Assuming 1 CPU; got exception.", (Throwable)exception);
            cpuCount = 1;
            return 1;
        }
    }

    private static boolean matchMemText(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = byArray2.length;
        if (n + n3 >= n2) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static int extractMemValue(byte[] byArray, int n, int n2) {
        if (n >= n2) {
            return 0;
        }
        while (n < n2 && byArray[n] != 10) {
            if (byArray[n] >= 48 && byArray[n] <= 57) {
                int n3 = n++;
                while (n < n2 && byArray[n] >= 48 && byArray[n] <= 57) {
                    ++n;
                }
                return Integer.parseInt(new String(byArray, n3, n - n3), 10);
            }
            ++n;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getMemSize() {
        if (totalRAM >= 0) {
            return totalRAM;
        }
        byte[] byArray = new byte[]{77, 101, 109, 84, 111, 116, 97, 108};
        try {
            byte[] byArray2 = new byte[256];
            try (FileInputStream fileInputStream = new FileInputStream("/proc/meminfo");){
                int n = fileInputStream.read(byArray2);
                for (int i = 0; i < n; ++i) {
                    if (!SysInfo.matchMemText(byArray2, i, n, byArray)) continue;
                    totalRAM = SysInfo.extractMemValue(byArray2, i += 8, n) / 1024;
                    Log.d((String)LOG_TAG, (String)("System memory: " + totalRAM + "MB."));
                    int n2 = totalRAM;
                    return n2;
                }
            }
            Log.w((String)LOG_TAG, (String)"Did not find MemTotal line in /proc/meminfo.");
            totalRAM = 0;
            return 0;
        }
        catch (FileNotFoundException fileNotFoundException) {
            totalRAM = 0;
            return 0;
        }
        catch (IOException iOException) {
            totalRAM = 0;
            return 0;
        }
    }

    public static int getVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static String getReleaseVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getKernelVersion() {
        return System.getProperty("os.version", "");
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getDevice() {
        return Build.MODEL;
    }

    public static String getHardware() {
        return Build.HARDWARE;
    }

    public static String getName() {
        return "Android";
    }

    public static String getArchABI() {
        return Build.CPU_ABI;
    }
}

