/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.SysInfo;
import org.mozilla.gecko.util.ThreadUtils;

public final class ANRReporter
extends BroadcastReceiver {
    private static final boolean DEBUG = false;
    private static final String LOGTAG = "GeckoANRReporter";
    private static final String ANR_ACTION = "android.intent.action.ANR";
    private static final int LINES_TO_IDENTIFY_TRACES = 10;
    private static final int TRACES_LINE_SIZE = 100;
    private static final int TRACES_BLOCK_SIZE = 2000;
    private static final String TRACES_CHARSET = "utf-8";
    private static final String PING_CHARSET = "utf-8";
    private static final ANRReporter sInstance = new ANRReporter();
    private static int sRegisteredCount;
    private Handler mHandler;
    private volatile boolean mPendingANR;

    private static native boolean requestNativeStack(boolean var0);

    private static native String getNativeStack();

    private static native void releaseNativeStack();

    public static void register(Context context) {
        if (sRegisteredCount++ != 0) {
            return;
        }
        sInstance.start(context);
    }

    public static void unregister() {
        if (sRegisteredCount == 0) {
            Log.w((String)LOGTAG, (String)"register/unregister mismatch");
            return;
        }
        if (--sRegisteredCount != 0) {
            return;
        }
        sInstance.stop();
    }

    private void start(final Context context) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Looper.prepare();
                ANRReporter aNRReporter = ANRReporter.this;
                synchronized (aNRReporter) {
                    ANRReporter.this.mHandler = new Handler();
                    ((Object)((Object)ANRReporter.this)).notify();
                }
                context.registerReceiver((BroadcastReceiver)ANRReporter.this, new IntentFilter(ANRReporter.ANR_ACTION), null, ANRReporter.this.mHandler);
                Looper.loop();
                context.unregisterReceiver((BroadcastReceiver)ANRReporter.this);
                ANRReporter.this.mHandler = null;
            }
        }, LOGTAG);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        ANRReporter aNRReporter = this;
        synchronized (aNRReporter) {
            while (this.mHandler == null) {
                try {
                    ((Object)((Object)this)).wait(1000L);
                    if (this.mHandler != null) continue;
                    Log.w((String)LOGTAG, (String)"timed out waiting for handler");
                    return;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        aNRReporter = this.mHandler.getLooper();
        aNRReporter.quit();
        try {
            aNRReporter.getThread().join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private ANRReporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File getTracesFile() {
        File file = new File("/data/anr/traces.txt");
        if (file.isFile() && file.canRead()) {
            return file;
        }
        try {
            Process process = new ProcessBuilder(new String[0]).command("/system/bin/getprop", "dalvik.vm.stack-trace-file").redirectErrorStream(true).start();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 100);
                String string2 = bufferedReader.readLine();
                if (string2 == null) return null;
                if (string2.length() == 0) return null;
                file = new File(string2);
                if (!file.isFile()) return null;
                if (!file.canRead()) return null;
                File file2 = file;
                return file2;
            }
            finally {
                process.destroy();
            }
        }
        catch (IOException iOException) {
            Log.w((String)LOGTAG, (Throwable)iOException);
            return null;
        }
        catch (ClassCastException classCastException) {
            Log.w((String)LOGTAG, (Throwable)classCastException);
        }
        return null;
    }

    private static File getPingFile() {
        if (GeckoAppShell.getContext() == null) {
            return null;
        }
        GeckoProfile geckoProfile = GeckoAppShell.getGeckoInterface().getProfile();
        if (geckoProfile == null) {
            return null;
        }
        File file = geckoProfile.getDir();
        if (file == null) {
            return null;
        }
        File file2 = new File(file, "saved-telemetry-pings");
        file2.mkdirs();
        if (!file2.exists() || !file2.isDirectory()) {
            return null;
        }
        return new File(file2, UUID.randomUUID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isGeckoTraces(String string2, File file) {
        try {
            Pattern pattern = Pattern.compile(Pattern.quote(string2) + "([^a-zA-Z0-9_]|$)");
            Pattern pattern2 = null;
            if (!"org.mozilla.fennec".equals(string2)) {
                pattern2 = Pattern.compile(Pattern.quote("org.mozilla.fennec") + "([^a-zA-Z0-9_]|$)");
            }
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 2000);){
                int n = 0;
                while (n < 10) {
                    String string3 = bufferedReader.readLine();
                    if (string3 == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pattern.matcher(string3).find()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (pattern2 != null && pattern2.matcher(string3).find()) {
                        boolean bl = true;
                        return bl;
                    }
                    ++n;
                }
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static long getUptimeMins() {
        long l = new File("/proc/self/stat").lastModified();
        if (l != 0L) {
            l = (System.currentTimeMillis() - l) / 1000L / 60L;
            return l;
        }
        return 0L;
    }

    private static int writePingPayload(OutputStream outputStream, String string2) throws IOException {
        byte[] byArray = string2.getBytes("utf-8");
        outputStream.write(byArray);
        return byArray.length;
    }

    private static void fillPingHeader(OutputStream outputStream, String string2) throws IOException {
        byte[] byArray = ("{\"reason\":\"android-anr-report\",\"slug\":" + JSONObject.quote((String)string2) + "," + "\"payload\":").getBytes("utf-8");
        outputStream.write(byArray);
        int n = ANRReporter.writePingPayload(outputStream, "{\"ver\":1,\"simpleMeasurements\":{\"uptime\":" + String.valueOf(ANRReporter.getUptimeMins()) + "}," + "\"info\":{" + "\"reason\":\"android-anr-report\"," + "\"OS\":" + JSONObject.quote((String)SysInfo.getName()) + "," + "\"version\":\"" + String.valueOf(SysInfo.getVersion()) + "\"," + "\"appID\":" + JSONObject.quote((String)"{aa3c5121-dab2-40e2-81ca-7ea25febc110}") + "," + "\"appVersion\":" + JSONObject.quote((String)"41.0a1") + "," + "\"appName\":" + JSONObject.quote((String)"Fennec") + "," + "\"appBuildID\":" + JSONObject.quote((String)"20150602055237") + "," + "\"appUpdateChannel\":" + JSONObject.quote((String)"nightly") + "," + "\"platformBuildID\":" + JSONObject.quote((String)"20150602055237") + "," + "\"locale\":" + JSONObject.quote((String)Locales.getLanguageTag(Locale.getDefault())) + "," + "\"cpucount\":" + String.valueOf(SysInfo.getCPUCount()) + "," + "\"memsize\":" + String.valueOf(SysInfo.getMemSize()) + "," + "\"arch\":" + JSONObject.quote((String)SysInfo.getArchABI()) + "," + "\"kernel_version\":" + JSONObject.quote((String)SysInfo.getKernelVersion()) + "," + "\"device\":" + JSONObject.quote((String)SysInfo.getDevice()) + "," + "\"manufacturer\":" + JSONObject.quote((String)SysInfo.getManufacturer()) + "," + "\"hardware\":" + JSONObject.quote((String)SysInfo.getHardware()) + "}," + "\"androidANR\":\"");
    }

    private static int getEndPatternIndex(String string2, String string3, int n) {
        if (string3 == null || string2.length() < string3.length()) {
            return 0;
        }
        if (n < 0 && string2.startsWith(string3.substring(-n, string3.length()))) {
            return string3.length() + n;
        }
        int n2 = string2.indexOf(string3);
        if (n2 >= 0) {
            return n2 + string3.length();
        }
        for (n2 = string2.length() - string3.length() + 1; n2 < string2.length(); ++n2) {
            if (string2.charAt(n2) != string3.charAt(0) || !string2.endsWith(string3.substring(0, string2.length() - n2))) continue;
            return n2 - string2.length();
        }
        return 0;
    }

    private static int fillPingBlock(OutputStream outputStream, Reader reader, String string2) throws IOException {
        int n = 0;
        int n2 = 0;
        char[] cArray = new char[2000];
        int n3 = reader.read(cArray);
        while (n3 >= 0) {
            String string3 = new String(cArray, 0, n3);
            if ((n2 = ANRReporter.getEndPatternIndex(string3, string2, n2)) > 0) {
                string3 = string3.substring(0, n2);
            }
            String string4 = JSONObject.quote((String)string3);
            n += ANRReporter.writePingPayload(outputStream, string4.substring(1, string4.length() - 1));
            if (n2 > 0) break;
            n3 = reader.read(cArray);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillLogcat(OutputStream outputStream) {
        if (AppConstants.Versions.preJB) {
            return;
        }
        try {
            Process process = new ProcessBuilder(new String[0]).command("/system/bin/logcat", "-v", "threadtime", "-t", "200", "-d", "*:D").redirectErrorStream(true).start();
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream(), "utf-8");
                int n = ANRReporter.fillPingBlock(outputStream, inputStreamReader, null);
            }
            finally {
                process.destroy();
            }
        }
        catch (IOException iOException) {
            Log.w((String)LOGTAG, (Throwable)iOException);
        }
    }

    private static void fillPingFooter(OutputStream outputStream, boolean bl) throws IOException {
        Object object;
        int n = ANRReporter.writePingPayload(outputStream, "\",\"androidLogcat\":\"");
        ANRReporter.fillLogcat(outputStream);
        if (bl) {
            n += ANRReporter.writePingPayload(outputStream, "\",\"androidNativeStack\":");
            object = String.valueOf(ANRReporter.getNativeStack());
            int n2 = ANRReporter.writePingPayload(outputStream, (String)object);
            n += n2 + ANRReporter.writePingPayload(outputStream, "}");
        } else {
            n += ANRReporter.writePingPayload(outputStream, "\"}");
        }
        object = "}".getBytes("utf-8");
        outputStream.write((byte[])object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTraces(Reader reader, File file) {
        boolean bl = GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning) ? ANRReporter.requestNativeStack(SysInfo.getMemSize() >= 640) : false;
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 2000);
            try {
                ANRReporter.fillPingHeader(bufferedOutputStream, file.getName());
                int n = ANRReporter.fillPingBlock(bufferedOutputStream, reader, "\n----- end");
                ANRReporter.fillPingFooter(bufferedOutputStream, bl);
                return;
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
                if (bl) {
                    ANRReporter.releaseNativeStack();
                }
            }
        }
        catch (IOException iOException) {
            Log.w((String)LOGTAG, (Throwable)iOException);
            if (file.exists()) {
                file.delete();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTraces(File file, File file2) {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");){
            ANRReporter.processTraces(inputStreamReader, file2);
        }
        catch (IOException iOException) {
            Log.w((String)LOGTAG, (Throwable)iOException);
        }
    }

    public void onReceive(Context context, Intent intent) {
        if (this.mPendingANR) {
            return;
        }
        if (ThreadUtils.getUiHandler() != null) {
            this.mPendingANR = true;
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ANRReporter.this.mPendingANR = false;
                }
            });
        }
        if (!ANR_ACTION.equals(intent.getAction())) {
            return;
        }
        File file = ANRReporter.getPingFile();
        if (file == null) {
            return;
        }
        File file2 = ANRReporter.getTracesFile();
        if (file2 == null) {
            return;
        }
        if (!ANRReporter.isGeckoTraces(context.getPackageName(), file2)) {
            return;
        }
        Log.i((String)LOGTAG, (String)"processing Gecko ANR");
        ANRReporter.processTraces(file2, file);
    }
}

