/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport.prune;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.IBinder;
import org.mozilla.gecko.background.BackgroundService;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.prune.PrunePolicy;
import org.mozilla.gecko.background.healthreport.prune.PrunePolicyDatabaseStorage;

public class HealthReportPruneService
extends BackgroundService {
    public static final String LOG_TAG = HealthReportPruneService.class.getSimpleName();
    public static final String WORKER_THREAD_NAME = LOG_TAG + "Worker";

    public HealthReportPruneService() {
        super(WORKER_THREAD_NAME);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected SharedPreferences getSharedPreferences() {
        return this.getSharedPreferences("background", 0);
    }

    public void onHandleIntent(Intent intent) {
        Logger.setThreadLogTag("GeckoHealth");
        if (intent == null) {
            Logger.debug(LOG_TAG, "Short-circuiting on null intent.");
            return;
        }
        Logger.debug(LOG_TAG, "Handling prune intent.");
        if (!HealthReportPruneService.isIntentValid(intent)) {
            Logger.warn(LOG_TAG, "Intent not valid - returning.");
            return;
        }
        String string2 = intent.getStringExtra("profileName");
        String string3 = intent.getStringExtra("profilePath");
        Logger.debug(LOG_TAG, "Ticking for profile " + string2 + " at " + string3 + ".");
        PrunePolicy prunePolicy = this.getPrunePolicy(string3);
        prunePolicy.tick(System.currentTimeMillis());
    }

    protected PrunePolicy getPrunePolicy(String string2) {
        PrunePolicyDatabaseStorage prunePolicyDatabaseStorage = new PrunePolicyDatabaseStorage((Context)this, string2);
        return new PrunePolicy(prunePolicyDatabaseStorage, this.getSharedPreferences());
    }

    private static boolean isIntentValid(Intent intent) {
        String string2;
        boolean bl = true;
        String string3 = intent.getStringExtra("profileName");
        if (string3 == null) {
            Logger.warn(LOG_TAG, "Got intent without profileName.");
            bl = false;
        }
        if ((string2 = intent.getStringExtra("profilePath")) == null) {
            Logger.warn(LOG_TAG, "Got intent without profilePath.");
            bl = false;
        }
        return bl;
    }
}

