/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.util.Map;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.mozglue.RobocopTarget;

public class DBUtils {
    private static final String LOGTAG = "GeckoDBUtils";
    private static String HISTOGRAM_DATABASE_LOCKED = "DATABASE_LOCKED_EXCEPTION";
    private static String HISTOGRAM_DATABASE_UNLOCKED = "DATABASE_SUCCESSFUL_UNLOCK";
    private static final int CONFLICT_NONE = 0;
    private static final String[] CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};

    public static final String qualifyColumn(String string2, String string3) {
        return string2 + "." + string3;
    }

    public static String concatenateWhere(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string3;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return string2;
        }
        return "(" + string2 + ") AND (" + string3 + ")";
    }

    public static String[] appendSelectionArgs(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray2;
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static void replaceKey(ContentValues contentValues, String string2, String string3, String string4) {
        String string5 = string4;
        if (string2 != null && contentValues.containsKey(string2)) {
            string5 = contentValues.get(string2).toString();
            contentValues.remove(string2);
        }
        if (!contentValues.containsKey(string3)) {
            contentValues.put(string3, string5);
        }
    }

    public static void ensureDatabaseIsNotLocked(SQLiteOpenHelper sQLiteOpenHelper, String string2) {
        int n;
        SQLiteDatabase sQLiteDatabase = null;
        for (n = 0; n < 5; ++n) {
            try {
                sQLiteDatabase = sQLiteOpenHelper.getWritableDatabase();
                break;
            }
            catch (Exception exception) {
                Telemetry.addToHistogram(HISTOGRAM_DATABASE_LOCKED, n);
                Log.d((String)LOGTAG, (String)("Database is locked, trying to kill any zombie processes: " + string2));
                GeckoAppShell.killAnyZombies();
                try {
                    Thread.sleep(n * 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (sQLiteDatabase == null) {
            Log.w((String)LOGTAG, (String)"Failed to unlock database.");
            GeckoAppShell.listOfOpenFiles();
            return;
        }
        if (n > 1) {
            Telemetry.addToHistogram(HISTOGRAM_DATABASE_UNLOCKED, n - 1);
        }
    }

    public static void stripEmptyByteArray(ContentValues contentValues, String string2) {
        byte[] byArray;
        if (contentValues.containsKey(string2) && ((byArray = contentValues.getAsByteArray(string2)) == null || byArray.length == 0)) {
            Log.w((String)LOGTAG, (String)"Tried to insert an empty or non-byte-array image. Ignoring.");
            contentValues.putNull(string2);
        }
    }

    public static String computeSQLInClause(int n, String string2) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(" IN (");
        for (n2 = 0; n2 < n - 1; ++n2) {
            stringBuilder.append("?, ");
        }
        if (n2 < n) {
            stringBuilder.append("?");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String computeSQLInClauseFromLongs(Cursor cursor, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(" IN (");
        int n = cursor.getCount() - 1;
        int n2 = 0;
        while (cursor.moveToNext()) {
            stringBuilder.append(cursor.getLong(0));
            if (n2++ >= n) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static Uri appendProfile(String string2, Uri uri) {
        return uri.buildUpon().appendQueryParameter("profile", string2).build();
    }

    public static Uri appendProfileWithDefault(String string2, Uri uri) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return DBUtils.appendProfile("default", uri);
        }
        return DBUtils.appendProfile(string2, uri);
    }

    @RobocopTarget
    public static int updateArrays(SQLiteDatabase sQLiteDatabase, String string2, ContentValues[] contentValuesArray, UpdateOperation[] updateOperationArray, String string3, String[] stringArray) {
        return DBUtils.updateArraysWithOnConflict(sQLiteDatabase, string2, contentValuesArray, updateOperationArray, string3, stringArray, 0, true);
    }

    public static void updateArraysBlindly(SQLiteDatabase sQLiteDatabase, String string2, ContentValues[] contentValuesArray, UpdateOperation[] updateOperationArray, String string3, String[] stringArray) {
        DBUtils.updateArraysWithOnConflict(sQLiteDatabase, string2, contentValuesArray, updateOperationArray, string3, stringArray, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateArraysWithOnConflict(SQLiteDatabase sQLiteDatabase, String string2, ContentValues[] contentValuesArray, UpdateOperation[] updateOperationArray, String string3, String[] stringArray, int n, boolean bl) {
        ContentValues contentValues;
        int n2;
        if (contentValuesArray == null || contentValuesArray.length == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        if (updateOperationArray == null || updateOperationArray.length != contentValuesArray.length) {
            throw new IllegalArgumentException("ops and values don't match");
        }
        StringBuilder stringBuilder = new StringBuilder(120);
        stringBuilder.append("UPDATE ");
        stringBuilder.append(CONFLICT_VALUES[n]);
        stringBuilder.append(string2);
        stringBuilder.append(" SET ");
        int n3 = 0;
        for (n2 = 0; n2 < contentValuesArray.length; ++n2) {
            if (updateOperationArray[n2] == UpdateOperation.EXPRESSION) continue;
            n3 += contentValuesArray[n2].size();
        }
        n2 = stringArray == null ? n3 : n3 + stringArray.length;
        Object[] objectArray = new Object[n2];
        int n4 = 0;
        block14: for (int i = 0; i < contentValuesArray.length; ++i) {
            contentValues = contentValuesArray[i];
            UpdateOperation updateOperation = updateOperationArray[i];
            switch (updateOperation) {
                case ASSIGN: {
                    String string4;
                    for (Map.Entry entry : contentValues.valueSet()) {
                        string4 = (String)entry.getKey();
                        stringBuilder.append(n4 > 0 ? "," : "");
                        stringBuilder.append(string4);
                        objectArray[n4++] = entry.getValue();
                        stringBuilder.append("= ?");
                    }
                    continue block14;
                }
                case BITWISE_OR: {
                    String string4;
                    for (Map.Entry entry : contentValues.valueSet()) {
                        string4 = (String)entry.getKey();
                        stringBuilder.append(n4 > 0 ? "," : "");
                        stringBuilder.append(string4);
                        objectArray[n4++] = entry.getValue();
                        stringBuilder.append("= ? | ");
                        stringBuilder.append(string4);
                    }
                    continue block14;
                }
                case EXPRESSION: {
                    String string4;
                    for (Map.Entry entry : contentValues.valueSet()) {
                        string4 = (String)entry.getKey();
                        stringBuilder.append(n4 > 0 ? "," : "");
                        stringBuilder.append(string4);
                        stringBuilder.append(" = ");
                        stringBuilder.append(entry.getValue());
                    }
                    continue block14;
                }
            }
        }
        if (stringArray != null) {
            for (n4 = n3; n4 < n2; ++n4) {
                objectArray[n4] = stringArray[n4 - n3];
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(string3);
        }
        try (SQLiteStatement sQLiteStatement = sQLiteDatabase.compileStatement(stringBuilder.toString());){
            int n5;
            DBUtils.bindAllArgs(sQLiteStatement, objectArray);
            if (!bl) {
                sQLiteStatement.execute();
                int n6 = 0;
                return n6;
            }
            if (AppConstants.Versions.feature11Plus) {
                int n7 = DBUtils.executeStatementReturningChangedRows(sQLiteStatement);
                return n7;
            }
            sQLiteStatement.execute();
            contentValues = sQLiteDatabase.rawQuery("SELECT changes()", null);
            try {
                contentValues.moveToFirst();
                n5 = contentValues.getInt(0);
            }
            catch (Throwable throwable) {
                contentValues.close();
                throw throwable;
            }
            contentValues.close();
            return n5;
        }
    }

    @TargetApi(value=11)
    private static int executeStatementReturningChangedRows(SQLiteStatement sQLiteStatement) {
        return sQLiteStatement.executeUpdateDelete();
    }

    private static void bindAllArgs(SQLiteStatement sQLiteStatement, Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = objectArray.length; i != 0; --i) {
            Object object = objectArray[i - 1];
            if (object == null) {
                sQLiteStatement.bindNull(i);
                continue;
            }
            if (object instanceof String) {
                sQLiteStatement.bindString(i, (String)object);
                continue;
            }
            if (object instanceof Double) {
                sQLiteStatement.bindDouble(i, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof Float) {
                sQLiteStatement.bindDouble(i, (double)((Float)object).floatValue());
                continue;
            }
            if (object instanceof Long) {
                sQLiteStatement.bindLong(i, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Integer) {
                sQLiteStatement.bindLong(i, (long)((Integer)object).intValue());
                continue;
            }
            if (object instanceof Byte) {
                sQLiteStatement.bindLong(i, (long)((Byte)object).byteValue());
                continue;
            }
            if (!(object instanceof byte[])) continue;
            sQLiteStatement.bindBlob(i, (byte[])object);
        }
    }

    @RobocopTarget
    public static enum UpdateOperation {
        ASSIGN,
        BITWISE_OR,
        EXPRESSION;

    }
}

