/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.login;

import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.Set;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.fxa.login.FxAccountLoginTransition;
import org.mozilla.gecko.fxa.login.State;

public class FxAccountLoginStateMachine {
    public static final String LOG_TAG = FxAccountLoginStateMachine.class.getSimpleName();

    public void advance(State state, State.StateLabel stateLabel, LoginStateMachineDelegate loginStateMachineDelegate) {
        if (state.getStateLabel() == stateLabel) {
            loginStateMachineDelegate.handleFinal(state);
            return;
        }
        ExecuteDelegate executeDelegate = new ExecuteDelegate(state.getStateLabel(), stateLabel, loginStateMachineDelegate);
        state.execute(executeDelegate);
    }

    public static class ExecuteDelegate {
        protected final LoginStateMachineDelegate delegate;
        protected final State.StateLabel desiredStateLabel;
        protected final Set<State.StateLabel> stateLabelsSeen = EnumSet.noneOf(State.StateLabel.class);

        protected ExecuteDelegate(State.StateLabel stateLabel, State.StateLabel stateLabel2, LoginStateMachineDelegate loginStateMachineDelegate) {
            this.delegate = loginStateMachineDelegate;
            this.desiredStateLabel = stateLabel2;
            this.stateLabelsSeen.add(stateLabel);
        }

        public FxAccountClient getClient() {
            return this.delegate.getClient();
        }

        public long getCertificateDurationInMilliseconds() {
            return this.delegate.getCertificateDurationInMilliseconds();
        }

        public long getAssertionDurationInMilliseconds() {
            return this.delegate.getAssertionDurationInMilliseconds();
        }

        public BrowserIDKeyPair generateKeyPair() throws NoSuchAlgorithmException {
            return this.delegate.generateKeyPair();
        }

        public void handleTransition(FxAccountLoginTransition.Transition transition, State state) {
            this.delegate.handleTransition(transition, state);
            State.StateLabel stateLabel = state.getStateLabel();
            if (stateLabel == this.desiredStateLabel || this.stateLabelsSeen.contains((Object)stateLabel)) {
                this.delegate.handleFinal(state);
                return;
            }
            this.stateLabelsSeen.add(stateLabel);
            state.execute(this);
        }
    }

    public static interface LoginStateMachineDelegate {
        public FxAccountClient getClient();

        public long getCertificateDurationInMilliseconds();

        public long getAssertionDurationInMilliseconds();

        public void handleTransition(FxAccountLoginTransition.Transition var1, State var2);

        public void handleFinal(State var1);

        public BrowserIDKeyPair generateKeyPair() throws NoSuchAlgorithmException;
    }
}

