/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.tasks;

import android.content.Context;
import android.widget.Toast;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.fxa.tasks.FxAccountSetupTask;

public class FxAccountCodeResender {
    private static final String LOG_TAG = FxAccountCodeResender.class.getSimpleName();

    public static void resendCode(Context context, AndroidFxAccount androidFxAccount) {
        byte[] byArray;
        ResendCodeDelegate resendCodeDelegate = new ResendCodeDelegate(context);
        try {
            byArray = ((Engaged)androidFxAccount.getState()).getSessionToken();
        }
        catch (Exception exception) {
            resendCodeDelegate.handleError(exception);
            return;
        }
        if (byArray == null) {
            resendCodeDelegate.handleError(new IllegalStateException("sessionToken should not be null"));
            return;
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(androidFxAccount.getAccountServerURI(), executorService);
        new FxAccountResendCodeTask(context, byArray, fxAccountClient20, resendCodeDelegate).execute(new Void[0]);
    }

    private static class ResendCodeDelegate
    implements FxAccountClient10.RequestDelegate<Void> {
        public final Context context;

        public ResendCodeDelegate(Context context) {
            this.context = context;
        }

        @Override
        public void handleError(Exception exception) {
            Logger.warn(LOG_TAG, "Got exception requesting fresh confirmation link; ignoring.", exception);
            Toast.makeText((Context)this.context, (int)R.string.fxaccount_confirm_account_verification_link_not_sent, (int)1).show();
        }

        @Override
        public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            this.handleError(fxAccountClientRemoteException);
        }

        @Override
        public void handleSuccess(Void void_) {
            Toast.makeText((Context)this.context, (int)R.string.fxaccount_confirm_account_verification_link_sent, (int)0).show();
        }
    }

    private static class FxAccountResendCodeTask
    extends FxAccountSetupTask<Void> {
        protected static final String LOG_TAG = FxAccountResendCodeTask.class.getSimpleName();
        protected final byte[] sessionToken;

        public FxAccountResendCodeTask(Context context, byte[] byArray, FxAccountClient fxAccountClient, FxAccountClient10.RequestDelegate<Void> requestDelegate) {
            super(context, null, fxAccountClient, null, requestDelegate);
            this.sessionToken = byArray;
        }

        protected FxAccountSetupTask.InnerRequestDelegate<Void> doInBackground(Void ... voidArray) {
            try {
                this.client.resendCode(this.sessionToken, this.innerDelegate);
                this.latch.await();
                return this.innerDelegate;
            }
            catch (Exception exception) {
                Logger.error(LOG_TAG, "Got exception signing in.", exception);
                this.delegate.handleError(exception);
                return null;
            }
        }
    }
}

