/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.BookmarksPanel;
import org.mozilla.gecko.home.DynamicPanel;
import org.mozilla.gecko.home.HistoryPanel;
import org.mozilla.gecko.home.HomeConfigPrefsBackend;
import org.mozilla.gecko.home.ReadingListPanel;
import org.mozilla.gecko.home.RecentTabsPanel;
import org.mozilla.gecko.home.RemoteTabsPanel;
import org.mozilla.gecko.home.TopSitesPanel;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.ThreadUtils;

public final class HomeConfig {
    private static final String TOP_SITES_PANEL_ID = "4becc86b-41eb-429a-a042-88fe8b5a094e";
    private static final String BOOKMARKS_PANEL_ID = "7f6d419a-cd6c-4e34-b26f-f68b1b551907";
    private static final String READING_LIST_PANEL_ID = "20f4549a-64ad-4c32-93e4-1dcef792733b";
    private static final String HISTORY_PANEL_ID = "f134bf20-11f7-4867-ab8b-e8e705d7fbe8";
    private static final String RECENT_TABS_PANEL_ID = "5c2601a5-eedc-4477-b297-ce4cef52adf8";
    private static final String REMOTE_TABS_PANEL_ID = "72429afd-8d8b-43d8-9189-14b779c563d0";
    private final HomeConfigBackend mBackend;

    public HomeConfig(HomeConfigBackend homeConfigBackend) {
        this.mBackend = homeConfigBackend;
    }

    public State load() {
        State state = this.mBackend.load();
        state.setHomeConfig(this);
        return state;
    }

    public String getLocale() {
        return this.mBackend.getLocale();
    }

    public void save(State state) {
        this.mBackend.save(state);
    }

    public void setOnReloadListener(OnReloadListener onReloadListener) {
        this.mBackend.setOnReloadListener(onReloadListener);
    }

    public static PanelConfig createBuiltinPanelConfig(Context context, PanelType panelType) {
        return HomeConfig.createBuiltinPanelConfig(context, panelType, EnumSet.noneOf(PanelConfig.Flags.class));
    }

    public static int getTitleResourceIdForBuiltinPanelType(PanelType panelType) {
        switch (panelType) {
            case TOP_SITES: {
                return R.string.home_top_sites_title;
            }
            case BOOKMARKS: {
                return R.string.bookmarks_title;
            }
            case HISTORY: {
                return R.string.home_history_title;
            }
            case REMOTE_TABS: {
                return R.string.home_remote_tabs_title;
            }
            case READING_LIST: {
                return R.string.reading_list_title;
            }
            case RECENT_TABS: {
                return R.string.recent_tabs_title;
            }
        }
        throw new IllegalArgumentException("Only for built-in panel types: " + (Object)((Object)panelType));
    }

    public static String getIdForBuiltinPanelType(PanelType panelType) {
        switch (panelType) {
            case TOP_SITES: {
                return TOP_SITES_PANEL_ID;
            }
            case BOOKMARKS: {
                return BOOKMARKS_PANEL_ID;
            }
            case HISTORY: {
                return HISTORY_PANEL_ID;
            }
            case REMOTE_TABS: {
                return REMOTE_TABS_PANEL_ID;
            }
            case READING_LIST: {
                return READING_LIST_PANEL_ID;
            }
            case RECENT_TABS: {
                return RECENT_TABS_PANEL_ID;
            }
        }
        throw new IllegalArgumentException("Only for built-in panel types: " + (Object)((Object)panelType));
    }

    public static PanelConfig createBuiltinPanelConfig(Context context, PanelType panelType, EnumSet<PanelConfig.Flags> enumSet) {
        int n = HomeConfig.getTitleResourceIdForBuiltinPanelType(panelType);
        String string2 = HomeConfig.getIdForBuiltinPanelType(panelType);
        return new PanelConfig(panelType, context.getString(n), string2, enumSet);
    }

    public static HomeConfig getDefault(Context context) {
        return new HomeConfig(new HomeConfigPrefsBackend(context));
    }

    public static interface HomeConfigBackend {
        public State load();

        public void save(State var1);

        public String getLocale();

        public void setOnReloadListener(OnReloadListener var1);
    }

    public static interface OnReloadListener {
        public void onReload();
    }

    public static class Editor
    implements Iterable<PanelConfig> {
        private final HomeConfig mHomeConfig;
        private final Map<String, PanelConfig> mConfigMap;
        private final List<String> mConfigOrder;
        private final List<GeckoEvent> mEventQueue;
        private final Thread mOriginalThread;
        private PanelConfig mDefaultPanel;
        private int mEnabledCount;
        private boolean mHasChanged;
        private final boolean mIsFromDefault;

        private Editor(HomeConfig homeConfig, State state) {
            this.mHomeConfig = homeConfig;
            this.mOriginalThread = Thread.currentThread();
            this.mConfigMap = new HashMap<String, PanelConfig>();
            this.mConfigOrder = new LinkedList<String>();
            this.mEventQueue = new LinkedList<GeckoEvent>();
            this.mIsFromDefault = state.isDefault();
            this.initFromState(state);
        }

        private void initFromState(State state) {
            for (PanelConfig panelConfig : state) {
                PanelConfig panelConfig2 = new PanelConfig(panelConfig);
                if (!panelConfig2.isDisabled()) {
                    ++this.mEnabledCount;
                }
                if (panelConfig2.isDefault()) {
                    if (this.mDefaultPanel == null) {
                        this.mDefaultPanel = panelConfig2;
                    } else {
                        throw new IllegalStateException("Multiple default panels in HomeConfig state");
                    }
                }
                String string2 = panelConfig.getId();
                this.mConfigOrder.add(string2);
                this.mConfigMap.put(string2, panelConfig2);
            }
            if (this.mEnabledCount > 0 && this.mDefaultPanel == null) {
                throw new IllegalStateException("Default panel in HomeConfig state is undefined");
            }
        }

        private PanelConfig getPanelOrThrow(String string2) {
            PanelConfig panelConfig = this.mConfigMap.get(string2);
            if (panelConfig == null) {
                throw new IllegalStateException("Tried to access non-existing panel: " + string2);
            }
            return panelConfig;
        }

        private boolean isCurrentDefaultPanel(PanelConfig panelConfig) {
            if (this.mDefaultPanel == null) {
                return false;
            }
            return this.mDefaultPanel.equals(panelConfig);
        }

        private void findNewDefault() {
            for (PanelConfig panelConfig : this.mConfigMap.values()) {
                if (panelConfig.isDefault() || panelConfig.isDisabled()) continue;
                this.setDefault(panelConfig.getId());
                return;
            }
            this.mDefaultPanel = null;
        }

        private List<PanelConfig> makeOrderedCopy(boolean bl) {
            ArrayList<PanelConfig> arrayList = new ArrayList<PanelConfig>(this.mConfigOrder.size());
            for (String string2 : this.mConfigOrder) {
                PanelConfig panelConfig = this.mConfigMap.get(string2);
                if (bl) {
                    panelConfig = new PanelConfig(panelConfig);
                }
                arrayList.add(panelConfig);
            }
            return arrayList;
        }

        private void setPanelIsDisabled(PanelConfig panelConfig, boolean bl) {
            if (panelConfig.isDisabled() == bl) {
                return;
            }
            panelConfig.setIsDisabled(bl);
            this.mEnabledCount += bl ? -1 : 1;
        }

        public String getDefaultPanelId() {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            if (this.mDefaultPanel == null) {
                return null;
            }
            return this.mDefaultPanel.getId();
        }

        public void setDefault(String string2) {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            PanelConfig panelConfig = this.getPanelOrThrow(string2);
            if (this.isCurrentDefaultPanel(panelConfig)) {
                return;
            }
            if (this.mDefaultPanel != null) {
                this.mDefaultPanel.setIsDefault(false);
            }
            panelConfig.setIsDefault(true);
            this.setPanelIsDisabled(panelConfig, false);
            this.mDefaultPanel = panelConfig;
            this.mHasChanged = true;
        }

        public void setDisabled(String string2, boolean bl) {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            PanelConfig panelConfig = this.getPanelOrThrow(string2);
            if (panelConfig.isDisabled() == bl) {
                return;
            }
            this.setPanelIsDisabled(panelConfig, bl);
            if (bl) {
                if (this.isCurrentDefaultPanel(panelConfig)) {
                    panelConfig.setIsDefault(false);
                    this.findNewDefault();
                }
            } else if (this.mEnabledCount == 1) {
                this.setDefault(string2);
            }
            this.mHasChanged = true;
        }

        public boolean install(PanelConfig panelConfig) {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            if (panelConfig == null) {
                throw new IllegalStateException("Can't install a null panel");
            }
            if (!panelConfig.isDynamic()) {
                throw new IllegalStateException("Can't install a built-in panel: " + panelConfig.getId());
            }
            if (panelConfig.isDisabled()) {
                throw new IllegalStateException("Can't install a disabled panel: " + panelConfig.getId());
            }
            boolean bl = false;
            String string2 = panelConfig.getId();
            if (!this.mConfigMap.containsKey(string2)) {
                this.mConfigMap.put(string2, panelConfig);
                int n = panelConfig.getPosition();
                if (n < 0 || n >= this.mConfigOrder.size()) {
                    this.mConfigOrder.add(string2);
                } else {
                    this.mConfigOrder.add(n, string2);
                }
                ++this.mEnabledCount;
                if (this.mEnabledCount == 1 || panelConfig.isDefault()) {
                    this.setDefault(panelConfig.getId());
                }
                bl = true;
                this.mEventQueue.add(GeckoEvent.createBroadcastEvent("HomePanels:Installed", panelConfig.getId()));
            }
            this.mHasChanged = true;
            return bl;
        }

        public boolean uninstall(String string2) {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            PanelConfig panelConfig = this.mConfigMap.get(string2);
            if (panelConfig == null) {
                return false;
            }
            if (!panelConfig.isDynamic()) {
                throw new IllegalStateException("Can't uninstall a built-in panel: " + panelConfig.getId());
            }
            this.mConfigMap.remove(string2);
            this.mConfigOrder.remove(string2);
            if (!panelConfig.isDisabled()) {
                --this.mEnabledCount;
            }
            if (this.isCurrentDefaultPanel(panelConfig)) {
                this.findNewDefault();
            }
            this.mEventQueue.add(GeckoEvent.createBroadcastEvent("HomePanels:Uninstalled", string2));
            this.mHasChanged = true;
            return true;
        }

        public boolean moveTo(String string2, int n) {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            if (!this.mConfigOrder.contains(string2)) {
                return false;
            }
            this.mConfigOrder.remove(string2);
            this.mConfigOrder.add(n, string2);
            this.mHasChanged = true;
            return true;
        }

        public boolean update(PanelConfig panelConfig) {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            if (panelConfig == null) {
                throw new IllegalStateException("Can't update a null panel");
            }
            boolean bl = false;
            String string2 = panelConfig.getId();
            if (this.mConfigMap.containsKey(string2)) {
                PanelConfig panelConfig2 = this.mConfigMap.put(string2, panelConfig);
                panelConfig.setIsDefault(panelConfig2.isDefault());
                panelConfig.setIsDisabled(panelConfig2.isDisabled());
                bl = true;
            }
            this.mHasChanged = true;
            return bl;
        }

        public State apply() {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            final State state = new State(this.mHomeConfig, this.makeOrderedCopy(true), this.isDefault());
            final LinkedList<GeckoEvent> linkedList = new LinkedList<GeckoEvent>(this.mEventQueue);
            this.mEventQueue.clear();
            ThreadUtils.getBackgroundHandler().post(new Runnable(){

                @Override
                public void run() {
                    Editor.this.mHomeConfig.save(state);
                    Editor.this.sendEventsToGecko(linkedList);
                }
            });
            return state;
        }

        public State commit() {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            State state = new State(this.mHomeConfig, this.makeOrderedCopy(false), this.isDefault());
            this.mHomeConfig.save(state);
            this.sendEventsToGecko(this.mEventQueue);
            this.mEventQueue.clear();
            return state;
        }

        public boolean isDefault() {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            return !this.mHasChanged && this.mIsFromDefault;
        }

        public boolean isEmpty() {
            return this.mConfigMap.isEmpty();
        }

        private void sendEventsToGecko(List<GeckoEvent> list) {
            for (GeckoEvent geckoEvent : list) {
                GeckoAppShell.sendEventToGecko(geckoEvent);
            }
        }

        @Override
        public Iterator<PanelConfig> iterator() {
            ThreadUtils.assertOnThread((Thread)this.mOriginalThread);
            return new EditorIterator();
        }

        private class EditorIterator
        implements Iterator<PanelConfig> {
            private final Iterator<String> mOrderIterator;

            public EditorIterator() {
                this.mOrderIterator = Editor.this.mConfigOrder.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mOrderIterator.hasNext();
            }

            @Override
            public PanelConfig next() {
                String string2 = this.mOrderIterator.next();
                return (PanelConfig)Editor.this.mConfigMap.get(string2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't 'remove' from on Editor iterator.");
            }
        }
    }

    public static class State
    implements Iterable<PanelConfig> {
        private HomeConfig mHomeConfig;
        private final List<PanelConfig> mPanelConfigs;
        private final boolean mIsDefault;

        State(List<PanelConfig> list, boolean bl) {
            this(null, list, bl);
        }

        private State(HomeConfig homeConfig, List<PanelConfig> list, boolean bl) {
            this.mHomeConfig = homeConfig;
            this.mPanelConfigs = Collections.unmodifiableList(list);
            this.mIsDefault = bl;
        }

        private void setHomeConfig(HomeConfig homeConfig) {
            if (this.mHomeConfig != null) {
                throw new IllegalStateException("Can't set HomeConfig more than once");
            }
            this.mHomeConfig = homeConfig;
        }

        @Override
        public Iterator<PanelConfig> iterator() {
            return this.mPanelConfigs.iterator();
        }

        public boolean isDefault() {
            return this.mIsDefault;
        }

        public Editor edit() {
            return new Editor(this.mHomeConfig, this);
        }
    }

    public static class AuthConfig
    implements Parcelable {
        private final String mMessageText;
        private final String mButtonText;
        private final String mImageUrl;
        static final String JSON_KEY_MESSAGE_TEXT = "messageText";
        static final String JSON_KEY_BUTTON_TEXT = "buttonText";
        static final String JSON_KEY_IMAGE_URL = "imageUrl";
        public static final Parcelable.Creator<AuthConfig> CREATOR = new Parcelable.Creator<AuthConfig>(){

            public AuthConfig createFromParcel(Parcel parcel) {
                return new AuthConfig(parcel);
            }

            public AuthConfig[] newArray(int n) {
                return new AuthConfig[n];
            }
        };

        public AuthConfig(JSONObject jSONObject) throws JSONException, IllegalArgumentException {
            this.mMessageText = jSONObject.optString(JSON_KEY_MESSAGE_TEXT);
            this.mButtonText = jSONObject.optString(JSON_KEY_BUTTON_TEXT);
            this.mImageUrl = jSONObject.optString(JSON_KEY_IMAGE_URL, null);
        }

        public AuthConfig(Parcel parcel) {
            this.mMessageText = parcel.readString();
            this.mButtonText = parcel.readString();
            this.mImageUrl = parcel.readString();
            this.validate();
        }

        public AuthConfig(AuthConfig authConfig) {
            this.mMessageText = authConfig.mMessageText;
            this.mButtonText = authConfig.mButtonText;
            this.mImageUrl = authConfig.mImageUrl;
            this.validate();
        }

        public AuthConfig(String string2, String string3, String string4) {
            this.mMessageText = string2;
            this.mButtonText = string3;
            this.mImageUrl = string4;
            this.validate();
        }

        private void validate() {
            if (this.mMessageText == null) {
                throw new IllegalArgumentException("Can't create AuthConfig with null message text");
            }
            if (this.mButtonText == null) {
                throw new IllegalArgumentException("Can't create AuthConfig with null button text");
            }
        }

        public String getMessageText() {
            return this.mMessageText;
        }

        public String getButtonText() {
            return this.mButtonText;
        }

        public String getImageUrl() {
            return this.mImageUrl;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(JSON_KEY_MESSAGE_TEXT, (Object)this.mMessageText);
            jSONObject.put(JSON_KEY_BUTTON_TEXT, (Object)this.mButtonText);
            jSONObject.put(JSON_KEY_IMAGE_URL, (Object)this.mImageUrl);
            return jSONObject;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.mMessageText);
            parcel.writeString(this.mButtonText);
            parcel.writeString(this.mImageUrl);
        }
    }

    public static class EmptyViewConfig
    implements Parcelable {
        private final String mText;
        private final String mImageUrl;
        static final String JSON_KEY_TEXT = "text";
        static final String JSON_KEY_IMAGE_URL = "imageUrl";
        public static final Parcelable.Creator<EmptyViewConfig> CREATOR = new Parcelable.Creator<EmptyViewConfig>(){

            public EmptyViewConfig createFromParcel(Parcel parcel) {
                return new EmptyViewConfig(parcel);
            }

            public EmptyViewConfig[] newArray(int n) {
                return new EmptyViewConfig[n];
            }
        };

        public EmptyViewConfig(JSONObject jSONObject) throws JSONException, IllegalArgumentException {
            this.mText = jSONObject.optString(JSON_KEY_TEXT, null);
            this.mImageUrl = jSONObject.optString(JSON_KEY_IMAGE_URL, null);
        }

        public EmptyViewConfig(Parcel parcel) {
            this.mText = parcel.readString();
            this.mImageUrl = parcel.readString();
        }

        public EmptyViewConfig(EmptyViewConfig emptyViewConfig) {
            this.mText = emptyViewConfig.mText;
            this.mImageUrl = emptyViewConfig.mImageUrl;
        }

        public EmptyViewConfig(String string2, String string3) {
            this.mText = string2;
            this.mImageUrl = string3;
        }

        public String getText() {
            return this.mText;
        }

        public String getImageUrl() {
            return this.mImageUrl;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(JSON_KEY_TEXT, (Object)this.mText);
            jSONObject.put(JSON_KEY_IMAGE_URL, (Object)this.mImageUrl);
            return jSONObject;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.mText);
            parcel.writeString(this.mImageUrl);
        }
    }

    public static class ViewConfig
    implements Parcelable {
        private final int mIndex;
        private final ViewType mType;
        private final String mDatasetId;
        private final ItemType mItemType;
        private final ItemHandler mItemHandler;
        private final String mBackImageUrl;
        private final String mFilter;
        private final EmptyViewConfig mEmptyViewConfig;
        private final EnumSet<Flags> mFlags;
        static final String JSON_KEY_TYPE = "type";
        static final String JSON_KEY_DATASET = "dataset";
        static final String JSON_KEY_ITEM_TYPE = "itemType";
        static final String JSON_KEY_ITEM_HANDLER = "itemHandler";
        static final String JSON_KEY_BACK_IMAGE_URL = "backImageUrl";
        static final String JSON_KEY_FILTER = "filter";
        static final String JSON_KEY_EMPTY = "empty";
        static final String JSON_KEY_REFRESH_ENABLED = "refreshEnabled";
        public static final Parcelable.Creator<ViewConfig> CREATOR = new Parcelable.Creator<ViewConfig>(){

            public ViewConfig createFromParcel(Parcel parcel) {
                return new ViewConfig(parcel);
            }

            public ViewConfig[] newArray(int n) {
                return new ViewConfig[n];
            }
        };

        public ViewConfig(int n, JSONObject jSONObject) throws JSONException, IllegalArgumentException {
            this.mIndex = n;
            this.mType = ViewType.fromId(jSONObject.getString(JSON_KEY_TYPE));
            this.mDatasetId = jSONObject.getString(JSON_KEY_DATASET);
            this.mItemType = ItemType.fromId(jSONObject.getString(JSON_KEY_ITEM_TYPE));
            this.mItemHandler = ItemHandler.fromId(jSONObject.getString(JSON_KEY_ITEM_HANDLER));
            this.mBackImageUrl = jSONObject.optString(JSON_KEY_BACK_IMAGE_URL, null);
            this.mFilter = jSONObject.optString(JSON_KEY_FILTER, null);
            JSONObject jSONObject2 = jSONObject.optJSONObject(JSON_KEY_EMPTY);
            this.mEmptyViewConfig = jSONObject2 != null ? new EmptyViewConfig(jSONObject2) : null;
            this.mFlags = EnumSet.noneOf(Flags.class);
            if (jSONObject.optBoolean(JSON_KEY_REFRESH_ENABLED, false)) {
                this.mFlags.add(Flags.REFRESH_ENABLED);
            }
            this.validate();
        }

        public ViewConfig(Parcel parcel) {
            this.mIndex = parcel.readInt();
            this.mType = (ViewType)parcel.readParcelable(this.getClass().getClassLoader());
            this.mDatasetId = parcel.readString();
            this.mItemType = (ItemType)parcel.readParcelable(this.getClass().getClassLoader());
            this.mItemHandler = (ItemHandler)parcel.readParcelable(this.getClass().getClassLoader());
            this.mBackImageUrl = parcel.readString();
            this.mFilter = parcel.readString();
            this.mEmptyViewConfig = (EmptyViewConfig)parcel.readParcelable(this.getClass().getClassLoader());
            this.mFlags = (EnumSet)parcel.readSerializable();
            this.validate();
        }

        public ViewConfig(ViewConfig viewConfig) {
            this.mIndex = viewConfig.mIndex;
            this.mType = viewConfig.mType;
            this.mDatasetId = viewConfig.mDatasetId;
            this.mItemType = viewConfig.mItemType;
            this.mItemHandler = viewConfig.mItemHandler;
            this.mBackImageUrl = viewConfig.mBackImageUrl;
            this.mFilter = viewConfig.mFilter;
            this.mEmptyViewConfig = viewConfig.mEmptyViewConfig;
            this.mFlags = viewConfig.mFlags.clone();
            this.validate();
        }

        public ViewConfig(int n, ViewType viewType, String string2, ItemType itemType, ItemHandler itemHandler, String string3, String string4, EmptyViewConfig emptyViewConfig, EnumSet<Flags> enumSet) {
            this.mIndex = n;
            this.mType = viewType;
            this.mDatasetId = string2;
            this.mItemType = itemType;
            this.mItemHandler = itemHandler;
            this.mBackImageUrl = string3;
            this.mFilter = string4;
            this.mEmptyViewConfig = emptyViewConfig;
            this.mFlags = enumSet;
            this.validate();
        }

        private void validate() {
            if (this.mType == null) {
                throw new IllegalArgumentException("Can't create ViewConfig with null type");
            }
            if (TextUtils.isEmpty((CharSequence)this.mDatasetId)) {
                throw new IllegalArgumentException("Can't create ViewConfig with empty dataset ID");
            }
            if (this.mItemType == null) {
                throw new IllegalArgumentException("Can't create ViewConfig with null item type");
            }
            if (this.mItemHandler == null) {
                throw new IllegalArgumentException("Can't create ViewConfig with null item handler");
            }
            if (this.mFlags == null) {
                throw new IllegalArgumentException("Can't create ViewConfig with null flags");
            }
        }

        public int getIndex() {
            return this.mIndex;
        }

        public ViewType getType() {
            return this.mType;
        }

        public String getDatasetId() {
            return this.mDatasetId;
        }

        public ItemType getItemType() {
            return this.mItemType;
        }

        public ItemHandler getItemHandler() {
            return this.mItemHandler;
        }

        public String getBackImageUrl() {
            return this.mBackImageUrl;
        }

        public String getFilter() {
            return this.mFilter;
        }

        public EmptyViewConfig getEmptyViewConfig() {
            return this.mEmptyViewConfig;
        }

        public boolean isRefreshEnabled() {
            return this.mFlags.contains((Object)Flags.REFRESH_ENABLED);
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(JSON_KEY_TYPE, (Object)this.mType.toString());
            jSONObject.put(JSON_KEY_DATASET, (Object)this.mDatasetId);
            jSONObject.put(JSON_KEY_ITEM_TYPE, (Object)this.mItemType.toString());
            jSONObject.put(JSON_KEY_ITEM_HANDLER, (Object)this.mItemHandler.toString());
            if (!TextUtils.isEmpty((CharSequence)this.mBackImageUrl)) {
                jSONObject.put(JSON_KEY_BACK_IMAGE_URL, (Object)this.mBackImageUrl);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mFilter)) {
                jSONObject.put(JSON_KEY_FILTER, (Object)this.mFilter);
            }
            if (this.mEmptyViewConfig != null) {
                jSONObject.put(JSON_KEY_EMPTY, (Object)this.mEmptyViewConfig.toJSON());
            }
            if (this.mFlags.contains((Object)Flags.REFRESH_ENABLED)) {
                jSONObject.put(JSON_KEY_REFRESH_ENABLED, true);
            }
            return jSONObject;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.mIndex);
            parcel.writeParcelable((Parcelable)this.mType, 0);
            parcel.writeString(this.mDatasetId);
            parcel.writeParcelable((Parcelable)this.mItemType, 0);
            parcel.writeParcelable((Parcelable)this.mItemHandler, 0);
            parcel.writeString(this.mBackImageUrl);
            parcel.writeString(this.mFilter);
            parcel.writeParcelable((Parcelable)this.mEmptyViewConfig, 0);
            parcel.writeSerializable(this.mFlags);
        }

        public static enum Flags {
            REFRESH_ENABLED;

        }
    }

    public static enum ItemHandler implements Parcelable
    {
        BROWSER("browser"),
        INTENT("intent");

        private final String mId;
        public static final Parcelable.Creator<ItemHandler> CREATOR;

        private ItemHandler(String string3) {
            this.mId = string3;
        }

        public static ItemHandler fromId(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Could not convert null String to ItemHandler");
            }
            for (ItemHandler itemHandler : ItemHandler.values()) {
                if (!TextUtils.equals((CharSequence)itemHandler.mId, (CharSequence)string2.toLowerCase())) continue;
                return itemHandler;
            }
            throw new IllegalArgumentException("Could not convert String id to ItemHandler");
        }

        public String toString() {
            return this.mId;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<ItemHandler>(){

                public ItemHandler createFromParcel(Parcel parcel) {
                    return ItemHandler.values()[parcel.readInt()];
                }

                public ItemHandler[] newArray(int n) {
                    return new ItemHandler[n];
                }
            };
        }
    }

    public static enum ItemType implements Parcelable
    {
        ARTICLE("article"),
        IMAGE("image");

        private final String mId;
        public static final Parcelable.Creator<ItemType> CREATOR;

        private ItemType(String string3) {
            this.mId = string3;
        }

        public static ItemType fromId(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Could not convert null String to ItemType");
            }
            for (ItemType itemType : ItemType.values()) {
                if (!TextUtils.equals((CharSequence)itemType.mId, (CharSequence)string2.toLowerCase())) continue;
                return itemType;
            }
            throw new IllegalArgumentException("Could not convert String id to ItemType");
        }

        public String toString() {
            return this.mId;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<ItemType>(){

                public ItemType createFromParcel(Parcel parcel) {
                    return ItemType.values()[parcel.readInt()];
                }

                public ItemType[] newArray(int n) {
                    return new ItemType[n];
                }
            };
        }
    }

    public static enum ViewType implements Parcelable
    {
        LIST("list"),
        GRID("grid");

        private final String mId;
        public static final Parcelable.Creator<ViewType> CREATOR;

        private ViewType(String string3) {
            this.mId = string3;
        }

        public static ViewType fromId(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Could not convert null String to ViewType");
            }
            for (ViewType viewType : ViewType.values()) {
                if (!TextUtils.equals((CharSequence)viewType.mId, (CharSequence)string2.toLowerCase())) continue;
                return viewType;
            }
            throw new IllegalArgumentException("Could not convert String id to ViewType");
        }

        public String toString() {
            return this.mId;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<ViewType>(){

                public ViewType createFromParcel(Parcel parcel) {
                    return ViewType.values()[parcel.readInt()];
                }

                public ViewType[] newArray(int n) {
                    return new ViewType[n];
                }
            };
        }
    }

    public static enum LayoutType implements Parcelable
    {
        FRAME("frame");

        private final String mId;
        public static final Parcelable.Creator<LayoutType> CREATOR;

        private LayoutType(String string3) {
            this.mId = string3;
        }

        public static LayoutType fromId(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Could not convert null String to LayoutType");
            }
            for (LayoutType layoutType : LayoutType.values()) {
                if (!TextUtils.equals((CharSequence)layoutType.mId, (CharSequence)string2.toLowerCase())) continue;
                return layoutType;
            }
            throw new IllegalArgumentException("Could not convert String id to LayoutType");
        }

        public String toString() {
            return this.mId;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<LayoutType>(){

                public LayoutType createFromParcel(Parcel parcel) {
                    return LayoutType.values()[parcel.readInt()];
                }

                public LayoutType[] newArray(int n) {
                    return new LayoutType[n];
                }
            };
        }
    }

    public static class PanelConfig
    implements Parcelable {
        private final PanelType mType;
        private final String mTitle;
        private final String mId;
        private final LayoutType mLayoutType;
        private final List<ViewConfig> mViews;
        private final AuthConfig mAuthConfig;
        private final EnumSet<Flags> mFlags;
        private final int mPosition;
        static final String JSON_KEY_TYPE = "type";
        static final String JSON_KEY_TITLE = "title";
        static final String JSON_KEY_ID = "id";
        static final String JSON_KEY_LAYOUT = "layout";
        static final String JSON_KEY_VIEWS = "views";
        static final String JSON_KEY_AUTH_CONFIG = "authConfig";
        static final String JSON_KEY_DEFAULT = "default";
        static final String JSON_KEY_DISABLED = "disabled";
        static final String JSON_KEY_POSITION = "position";
        public static final Parcelable.Creator<PanelConfig> CREATOR = new Parcelable.Creator<PanelConfig>(){

            public PanelConfig createFromParcel(Parcel parcel) {
                return new PanelConfig(parcel);
            }

            public PanelConfig[] newArray(int n) {
                return new PanelConfig[n];
            }
        };

        public PanelConfig(JSONObject jSONObject) throws JSONException, IllegalArgumentException {
            JSONObject jSONObject2;
            String string2 = jSONObject.optString(JSON_KEY_TYPE, null);
            this.mType = TextUtils.isEmpty((CharSequence)string2) ? PanelType.DYNAMIC : PanelType.fromId(string2);
            this.mTitle = jSONObject.getString(JSON_KEY_TITLE);
            this.mId = jSONObject.getString(JSON_KEY_ID);
            String string3 = jSONObject.optString(JSON_KEY_LAYOUT, null);
            this.mLayoutType = string3 != null ? LayoutType.fromId(string3) : null;
            JSONArray jSONArray = jSONObject.optJSONArray(JSON_KEY_VIEWS);
            if (jSONArray != null) {
                this.mViews = new ArrayList<ViewConfig>();
                int n = jSONArray.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject jSONObject3 = (JSONObject)jSONArray.get(i);
                    ViewConfig viewConfig = new ViewConfig(i, jSONObject3);
                    this.mViews.add(viewConfig);
                }
            } else {
                this.mViews = null;
            }
            this.mAuthConfig = (jSONObject2 = jSONObject.optJSONObject(JSON_KEY_AUTH_CONFIG)) != null ? new AuthConfig(jSONObject2) : null;
            this.mFlags = EnumSet.noneOf(Flags.class);
            if (jSONObject.optBoolean(JSON_KEY_DEFAULT, false)) {
                this.mFlags.add(Flags.DEFAULT_PANEL);
            }
            if (jSONObject.optBoolean(JSON_KEY_DISABLED, false)) {
                this.mFlags.add(Flags.DISABLED_PANEL);
            }
            this.mPosition = jSONObject.optInt(JSON_KEY_POSITION, -1);
            this.validate();
        }

        public PanelConfig(Parcel parcel) {
            this.mType = (PanelType)parcel.readParcelable(this.getClass().getClassLoader());
            this.mTitle = parcel.readString();
            this.mId = parcel.readString();
            this.mLayoutType = (LayoutType)parcel.readParcelable(this.getClass().getClassLoader());
            this.mViews = new ArrayList<ViewConfig>();
            parcel.readTypedList(this.mViews, ViewConfig.CREATOR);
            this.mAuthConfig = (AuthConfig)parcel.readParcelable(this.getClass().getClassLoader());
            this.mFlags = (EnumSet)parcel.readSerializable();
            this.mPosition = parcel.readInt();
            this.validate();
        }

        public PanelConfig(PanelConfig panelConfig) {
            this.mType = panelConfig.mType;
            this.mTitle = panelConfig.mTitle;
            this.mId = panelConfig.mId;
            this.mLayoutType = panelConfig.mLayoutType;
            this.mViews = new ArrayList<ViewConfig>();
            List<ViewConfig> list = panelConfig.mViews;
            if (list != null) {
                for (ViewConfig viewConfig : list) {
                    this.mViews.add(new ViewConfig(viewConfig));
                }
            }
            this.mAuthConfig = panelConfig.mAuthConfig;
            this.mFlags = panelConfig.mFlags.clone();
            this.mPosition = panelConfig.mPosition;
            this.validate();
        }

        public PanelConfig(PanelType panelType, String string2, String string3) {
            this(panelType, string2, string3, EnumSet.noneOf(Flags.class));
        }

        public PanelConfig(PanelType panelType, String string2, String string3, EnumSet<Flags> enumSet) {
            this(panelType, string2, string3, null, null, null, enumSet, -1);
        }

        public PanelConfig(PanelType panelType, String string2, String string3, LayoutType layoutType, List<ViewConfig> list, AuthConfig authConfig, EnumSet<Flags> enumSet, int n) {
            this.mType = panelType;
            this.mTitle = string2;
            this.mId = string3;
            this.mLayoutType = layoutType;
            this.mViews = list;
            this.mAuthConfig = authConfig;
            this.mFlags = enumSet;
            this.mPosition = n;
            this.validate();
        }

        private void validate() {
            if (this.mType == null) {
                throw new IllegalArgumentException("Can't create PanelConfig with null type");
            }
            if (TextUtils.isEmpty((CharSequence)this.mTitle)) {
                throw new IllegalArgumentException("Can't create PanelConfig with empty title");
            }
            if (TextUtils.isEmpty((CharSequence)this.mId)) {
                throw new IllegalArgumentException("Can't create PanelConfig with empty id");
            }
            if (this.mLayoutType == null && this.mType == PanelType.DYNAMIC) {
                throw new IllegalArgumentException("Can't create a dynamic PanelConfig with null layout type");
            }
            if ((this.mViews == null || this.mViews.size() == 0) && this.mType == PanelType.DYNAMIC) {
                throw new IllegalArgumentException("Can't create a dynamic PanelConfig with no views");
            }
            if (this.mFlags == null) {
                throw new IllegalArgumentException("Can't create PanelConfig with null flags");
            }
        }

        public PanelType getType() {
            return this.mType;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getId() {
            return this.mId;
        }

        public LayoutType getLayoutType() {
            return this.mLayoutType;
        }

        public int getViewCount() {
            return this.mViews != null ? this.mViews.size() : 0;
        }

        public ViewConfig getViewAt(int n) {
            return this.mViews != null ? this.mViews.get(n) : null;
        }

        public boolean isDynamic() {
            return this.mType == PanelType.DYNAMIC;
        }

        public boolean isDefault() {
            return this.mFlags.contains((Object)Flags.DEFAULT_PANEL);
        }

        private void setIsDefault(boolean bl) {
            if (bl) {
                this.mFlags.add(Flags.DEFAULT_PANEL);
            } else {
                this.mFlags.remove((Object)Flags.DEFAULT_PANEL);
            }
        }

        public boolean isDisabled() {
            return this.mFlags.contains((Object)Flags.DISABLED_PANEL);
        }

        private void setIsDisabled(boolean bl) {
            if (bl) {
                this.mFlags.add(Flags.DISABLED_PANEL);
            } else {
                this.mFlags.remove((Object)Flags.DISABLED_PANEL);
            }
        }

        public AuthConfig getAuthConfig() {
            return this.mAuthConfig;
        }

        public int getPosition() {
            return this.mPosition;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(JSON_KEY_TYPE, (Object)this.mType.toString());
            jSONObject.put(JSON_KEY_TITLE, (Object)this.mTitle);
            jSONObject.put(JSON_KEY_ID, (Object)this.mId);
            if (this.mLayoutType != null) {
                jSONObject.put(JSON_KEY_LAYOUT, (Object)this.mLayoutType.toString());
            }
            if (this.mViews != null) {
                JSONArray jSONArray = new JSONArray();
                int n = this.mViews.size();
                for (int i = 0; i < n; ++i) {
                    ViewConfig viewConfig = this.mViews.get(i);
                    JSONObject jSONObject2 = viewConfig.toJSON();
                    jSONArray.put((Object)jSONObject2);
                }
                jSONObject.put(JSON_KEY_VIEWS, (Object)jSONArray);
            }
            if (this.mAuthConfig != null) {
                jSONObject.put(JSON_KEY_AUTH_CONFIG, (Object)this.mAuthConfig.toJSON());
            }
            if (this.mFlags.contains((Object)Flags.DEFAULT_PANEL)) {
                jSONObject.put(JSON_KEY_DEFAULT, true);
            }
            if (this.mFlags.contains((Object)Flags.DISABLED_PANEL)) {
                jSONObject.put(JSON_KEY_DISABLED, true);
            }
            jSONObject.put(JSON_KEY_POSITION, this.mPosition);
            return jSONObject;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof PanelConfig)) {
                return false;
            }
            PanelConfig panelConfig = (PanelConfig)object;
            return this.mId.equals(panelConfig.mId);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeParcelable((Parcelable)this.mType, 0);
            parcel.writeString(this.mTitle);
            parcel.writeString(this.mId);
            parcel.writeParcelable((Parcelable)this.mLayoutType, 0);
            parcel.writeTypedList(this.mViews);
            parcel.writeParcelable((Parcelable)this.mAuthConfig, 0);
            parcel.writeSerializable(this.mFlags);
            parcel.writeInt(this.mPosition);
        }

        public static enum Flags {
            DEFAULT_PANEL,
            DISABLED_PANEL;

        }
    }

    @RobocopTarget
    public static enum PanelType implements Parcelable
    {
        TOP_SITES("top_sites", TopSitesPanel.class),
        BOOKMARKS("bookmarks", BookmarksPanel.class),
        HISTORY("history", HistoryPanel.class),
        REMOTE_TABS("remote_tabs", RemoteTabsPanel.class),
        READING_LIST("reading_list", ReadingListPanel.class),
        RECENT_TABS("recent_tabs", RecentTabsPanel.class),
        DYNAMIC("dynamic", DynamicPanel.class);

        private final String mId;
        private final Class<?> mPanelClass;
        public static final Parcelable.Creator<PanelType> CREATOR;

        private PanelType(String string3, Class<?> clazz) {
            this.mId = string3;
            this.mPanelClass = clazz;
        }

        public static PanelType fromId(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Could not convert null String to PanelType");
            }
            for (PanelType panelType : PanelType.values()) {
                if (!TextUtils.equals((CharSequence)panelType.mId, (CharSequence)string2.toLowerCase())) continue;
                return panelType;
            }
            throw new IllegalArgumentException("Could not convert String id to PanelType");
        }

        public String toString() {
            return this.mId;
        }

        public Class<?> getPanelClass() {
            return this.mPanelClass;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<PanelType>(){

                public PanelType createFromParcel(Parcel parcel) {
                    return PanelType.values()[parcel.readInt()];
                }

                public PanelType[] newArray(int n) {
                    return new PanelType[n];
                }
            };
        }
    }
}

