/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.ImageLoader;

class PanelItemView
extends LinearLayout {
    private final TextView title;
    private final TextView description;
    private final ImageView image;
    private final LinearLayout titleDescContainer;

    private PanelItemView(Context context, int n) {
        super(context);
        LayoutInflater.from((Context)context).inflate(n, (ViewGroup)this);
        this.title = (TextView)this.findViewById(R.id.title);
        this.description = (TextView)this.findViewById(R.id.description);
        this.image = (ImageView)this.findViewById(R.id.image);
        this.titleDescContainer = (LinearLayout)this.findViewById(R.id.title_desc_container);
    }

    public void updateFromCursor(Cursor cursor) {
        int n;
        String string2;
        int n2 = cursor.getColumnIndexOrThrow("title");
        String string3 = cursor.getString(n2);
        boolean bl = !TextUtils.isEmpty((CharSequence)string3);
        this.title.setVisibility(bl ? 0 : 8);
        this.titleDescContainer.setVisibility(bl ? 0 : 8);
        if (bl) {
            this.title.setText((CharSequence)string3);
        }
        boolean bl2 = !TextUtils.isEmpty((CharSequence)(string2 = cursor.getString(n = cursor.getColumnIndexOrThrow("description"))));
        this.description.setVisibility(bl2 ? 0 : 8);
        if (bl2) {
            this.description.setText((CharSequence)string2);
        }
        this.titleDescContainer.setVisibility(bl || bl2 ? 0 : 8);
        int n3 = cursor.getColumnIndexOrThrow("image_url");
        String string4 = cursor.getString(n3);
        boolean bl3 = !TextUtils.isEmpty((CharSequence)string4);
        this.image.setVisibility(bl3 ? 0 : 8);
        if (bl3) {
            ImageLoader.with(this.getContext()).load(string4).into(this.image);
        }
    }

    public static PanelItemView create(Context context, HomeConfig.ItemType itemType) {
        switch (itemType) {
            case ARTICLE: {
                return new ArticleItemView(context);
            }
            case IMAGE: {
                return new ImageItemView(context);
            }
        }
        throw new IllegalArgumentException("Could not create panel item view from " + (Object)((Object)itemType));
    }

    private static class ImageItemView
    extends PanelItemView {
        private ImageItemView(Context context) {
            super(context, R.layout.panel_image_item);
            this.setOrientation(1);
        }
    }

    private static class ArticleItemView
    extends PanelItemView {
        private ArticleItemView(Context context) {
            super(context, R.layout.panel_article_item);
            this.setOrientation(0);
        }
    }
}

