/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.gecko.sync.Utils;

public class HKDF {
    public static String HMAC_ALGORITHM = "hmacSHA256";
    public static final int BLOCKSIZE = 32;
    public static final byte[] HMAC_INPUT = HKDF.bytes("Sync-AES_256_CBC-HMAC256");

    public static final byte[] bytes(String string2) {
        try {
            return string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] hkdfExtract(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        return HKDF.digestBytes(byArray2, HKDF.makeHMACHasher(byArray));
    }

    public static byte[] hkdfExpand(byte[] byArray, byte[] byArray2, int n) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = HKDF.makeHMACHasher(byArray);
        byte[] byArray3 = new byte[]{};
        byte[] byArray4 = new byte[]{};
        int n2 = (int)Math.ceil((double)n / 32.0);
        for (int i = 0; i < n2; ++i) {
            byArray4 = HKDF.digestBytes(Utils.concatAll(byArray4, byArray2, Utils.hex2Byte(Integer.toHexString(i + 1))), mac);
            byArray3 = Utils.concatAll(byArray3, new byte[][]{byArray4});
        }
        byte[] byArray5 = new byte[n];
        System.arraycopy(byArray3, 0, byArray5, 0, n);
        return byArray5;
    }

    public static Key makeHMACKey(byte[] byArray) {
        if (byArray.length == 0) {
            byArray = new byte[32];
        }
        return new SecretKeySpec(byArray, HMAC_ALGORITHM);
    }

    public static Mac makeHMACHasher(byte[] byArray) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = null;
        mac = Mac.getInstance(HMAC_ALGORITHM);
        assert (mac != null);
        mac.init(HKDF.makeHMACKey(byArray));
        return mac;
    }

    public static byte[] digestBytes(byte[] byArray, Mac mac) {
        mac.update(byArray);
        byte[] byArray2 = mac.doFinal();
        mac.reset();
        return byArray2;
    }

    public static byte[] derive(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        return HKDF.hkdfExpand(HKDF.hkdfExtract(byArray2, byArray), byArray3, n);
    }

    public static void deriveMany(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] ... byArray4) throws InvalidKeyException, NoSuchAlgorithmException {
        int n = 0;
        for (byte[] byArray5 : byArray4) {
            n += byArray5.length;
        }
        byte[] byArray6 = HKDF.hkdfExpand(HKDF.hkdfExtract(byArray2, byArray), byArray3, n);
        int n2 = 0;
        for (byte[] byArray7 : byArray4) {
            System.arraycopy(byArray6, n2, byArray7, 0, byArray7.length);
            n2 += byArray7.length;
        }
    }
}

