/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.widget.DoorHanger;

public class DoorhangerConfig {
    private static final String LOGTAG = "DoorhangerConfig";
    private final int tabId;
    private final String id;
    private final DoorHanger.OnButtonClickListener buttonClickListener;
    private final DoorHanger.Type type;
    private String message;
    private JSONObject options;
    private Link link;
    private JSONArray buttons = new JSONArray();

    public DoorhangerConfig(DoorHanger.Type type, DoorHanger.OnButtonClickListener onButtonClickListener) {
        this(-1, null, type, onButtonClickListener);
    }

    public DoorhangerConfig(int n, String string2, DoorHanger.Type type, DoorHanger.OnButtonClickListener onButtonClickListener) {
        this.tabId = n;
        this.id = string2;
        this.type = type;
        this.buttonClickListener = onButtonClickListener;
    }

    public int getTabId() {
        return this.tabId;
    }

    public String getId() {
        return this.id;
    }

    public DoorHanger.Type getType() {
        return this.type;
    }

    public void setMessage(String string2) {
        this.message = string2;
    }

    public String getMessage() {
        return this.message;
    }

    public void setOptions(JSONObject jSONObject) {
        this.options = jSONObject;
    }

    public JSONObject getOptions() {
        return this.options;
    }

    public void appendButtonsFromJSON(JSONArray jSONArray) {
        try {
            for (int i = 0; i < jSONArray.length(); ++i) {
                this.buttons.put(jSONArray.get(i));
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error parsing buttons from JSON", (Throwable)jSONException);
        }
    }

    public void appendButton(String string2, int n) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("label", (Object)string2);
            jSONObject.put("callback", n);
            this.buttons.put((Object)jSONObject);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error creating button", (Throwable)jSONException);
        }
    }

    public DoorHanger.OnButtonClickListener getButtonClickListener() {
        return this.buttonClickListener;
    }

    public JSONArray getButtons() {
        return this.buttons;
    }

    public void setLink(String string2, String string3, String string4) {
        this.link = new Link(string2, string3, string4);
    }

    public Link getLink() {
        return this.link;
    }

    public static class Link {
        public final String label;
        public final String url;
        public final String delimiter;

        private Link(String string2, String string3, String string4) {
            this.label = string2;
            this.url = string3;
            this.delimiter = string4;
        }
    }
}

