/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Editable;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TransformationMethod;
import android.text.style.ClickableSpan;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.PasswordStretcher;
import org.mozilla.gecko.background.fxa.QuickPasswordStretcher;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractActivity;
import org.mozilla.gecko.fxa.activities.FxAccountConfirmAccountActivity;
import org.mozilla.gecko.fxa.activities.FxAccountVerifiedAccountActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.fxa.tasks.FxAccountSetupTask;
import org.mozilla.gecko.fxa.tasks.FxAccountUnlockCodeResender;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;

public abstract class FxAccountAbstractSetupActivity
extends FxAccountAbstractActivity
implements FxAccountSetupTask.ProgressDisplay {
    public static final String EXTRA_EMAIL = "email";
    public static final String EXTRA_PASSWORD = "password";
    public static final String EXTRA_PASSWORD_SHOWN = "password_shown";
    public static final String EXTRA_YEAR = "year";
    public static final String EXTRA_MONTH = "month";
    public static final String EXTRA_DAY = "day";
    public static final String EXTRA_EXTRAS = "extras";
    public static final String JSON_KEY_AUTH = "auth";
    public static final String JSON_KEY_SERVICES = "services";
    public static final String JSON_KEY_SYNC = "sync";
    private static final String LOG_TAG = FxAccountAbstractSetupActivity.class.getSimpleName();
    private static final boolean ALWAYS_SHOW_CUSTOM_SERVER_LAYOUT = false;
    protected int minimumPasswordLength = 8;
    protected AutoCompleteTextView emailEdit;
    protected EditText passwordEdit;
    protected Button showPasswordButton;
    protected TextView remoteErrorTextView;
    protected Button button;
    protected ProgressBar progressBar;
    private String authServerEndpoint;
    private String syncServerEndpoint;

    public FxAccountAbstractSetupActivity() {
        super(5);
    }

    protected FxAccountAbstractSetupActivity(int n) {
        super(n);
    }

    protected String getAuthServerEndpoint() {
        return this.authServerEndpoint;
    }

    protected String getTokenServerEndpoint() {
        return this.syncServerEndpoint;
    }

    protected void createShowPasswordButton() {
        this.showPasswordButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean bl = FxAccountAbstractSetupActivity.this.passwordEdit.getTransformationMethod() instanceof SingleLineTransformationMethod;
                FxAccountAbstractSetupActivity.this.setPasswordButtonShown(!bl);
            }
        });
    }

    protected void setPasswordButtonShown(boolean bl) {
        int n = this.passwordEdit.getSelectionStart();
        int n2 = this.passwordEdit.getSelectionEnd();
        if (!bl) {
            this.passwordEdit.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            this.showPasswordButton.setText(R.string.fxaccount_password_show);
            this.showPasswordButton.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.fxaccount_password_button_show_background));
            this.showPasswordButton.setTextColor(this.getResources().getColor(R.color.fxaccount_password_show_textcolor));
        } else {
            this.passwordEdit.setTransformationMethod((TransformationMethod)SingleLineTransformationMethod.getInstance());
            this.showPasswordButton.setText(R.string.fxaccount_password_hide);
            this.showPasswordButton.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.fxaccount_password_button_hide_background));
            this.showPasswordButton.setTextColor(this.getResources().getColor(R.color.fxaccount_password_hide_textcolor));
        }
        this.passwordEdit.setSelection(n, n2);
    }

    protected void linkifyPolicy() {
        TextView textView = (TextView)this.ensureFindViewById(null, R.id.policy, "policy links");
        String string2 = this.getString(R.string.fxaccount_link_tos);
        String string3 = this.getString(R.string.fxaccount_link_pn);
        String string4 = "<a href=\"" + string2 + "\">" + this.getString(R.string.fxaccount_policy_linktos) + "</a>";
        String string5 = "<a href=\"" + string3 + "\">" + this.getString(R.string.fxaccount_policy_linkprivacy) + "</a>";
        textView.setText((CharSequence)this.getString(R.string.fxaccount_create_account_policy_text, new Object[]{string4, string5}));
        ActivityUtils.linkifyTextView(textView, true);
    }

    protected void hideRemoteError() {
        if (AppConstants.Versions.feature11Plus) {
            this.remoteErrorTextView.setVisibility(8);
        } else {
            this.remoteErrorTextView.setVisibility(4);
        }
    }

    protected void showRemoteError(Exception exception, int n) {
        if (exception instanceof IOException) {
            this.remoteErrorTextView.setText(R.string.fxaccount_remote_error_COULD_NOT_CONNECT);
        } else if (exception instanceof FxAccountClientException.FxAccountClientRemoteException) {
            this.showClientRemoteException((FxAccountClientException.FxAccountClientRemoteException)exception);
        } else {
            this.remoteErrorTextView.setText(n);
        }
        Logger.warn(LOG_TAG, "Got exception; showing error message: " + this.remoteErrorTextView.getText().toString(), exception);
        this.remoteErrorTextView.setVisibility(0);
    }

    protected void showClientRemoteException(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
        if (!fxAccountClientRemoteException.isAccountLocked()) {
            this.remoteErrorTextView.setText(fxAccountClientRemoteException.getErrorMessageStringResource());
            return;
        }
        int n = fxAccountClientRemoteException.getErrorMessageStringResource();
        int n2 = R.string.fxaccount_resend_unlock_code_button_label;
        Spannable spannable = Utils.interpolateClickableSpan((Context)this, n, n2, new ClickableSpan(){

            public void onClick(View view) {
                String string2 = FxAccountAbstractSetupActivity.this.emailEdit.getText().toString();
                byte[] byArray = null;
                try {
                    byArray = string2.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                FxAccountUnlockCodeResender.resendUnlockCode((Context)FxAccountAbstractSetupActivity.this, FxAccountAbstractSetupActivity.this.getAuthServerEndpoint(), byArray);
            }
        });
        this.remoteErrorTextView.setMovementMethod(LinkMovementMethod.getInstance());
        this.remoteErrorTextView.setText((CharSequence)spannable);
    }

    protected void addListeners() {
        TextChangedListener textChangedListener = new TextChangedListener();
        EditorActionListener editorActionListener = new EditorActionListener();
        FocusChangeListener focusChangeListener = new FocusChangeListener();
        this.emailEdit.addTextChangedListener((TextWatcher)textChangedListener);
        this.emailEdit.setOnEditorActionListener((TextView.OnEditorActionListener)editorActionListener);
        this.emailEdit.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
        this.passwordEdit.addTextChangedListener((TextWatcher)textChangedListener);
        this.passwordEdit.setOnEditorActionListener((TextView.OnEditorActionListener)editorActionListener);
        this.passwordEdit.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
    }

    protected boolean shouldButtonBeEnabled() {
        String string2 = this.emailEdit.getText().toString();
        String string3 = this.passwordEdit.getText().toString();
        boolean bl = string2.length() > 0 && Patterns.EMAIL_ADDRESS.matcher(string2).matches() && string3.length() >= this.minimumPasswordLength;
        return bl;
    }

    protected boolean updateButtonState() {
        boolean bl = this.shouldButtonBeEnabled();
        if (!bl) {
            this.hideRemoteError();
        }
        if (bl != this.button.isEnabled()) {
            Logger.debug(LOG_TAG, (bl ? "En" : "Dis") + "abling button.");
            this.button.setEnabled(bl);
        }
        return bl;
    }

    @Override
    public void showProgress() {
        this.progressBar.setVisibility(0);
        this.button.setVisibility(4);
    }

    @Override
    public void dismissProgress() {
        this.progressBar.setVisibility(4);
        this.button.setVisibility(0);
    }

    public Intent makeSuccessIntent(String string2, FxAccountClient20.LoginResponse loginResponse) {
        Intent intent = loginResponse.verified ? new Intent((Context)this, FxAccountVerifiedAccountActivity.class) : new Intent((Context)this, FxAccountConfirmAccountActivity.class);
        intent.setFlags(65536);
        return intent;
    }

    protected PasswordStretcher makePasswordStretcher(String string2) {
        return new QuickPasswordStretcher(string2);
    }

    protected void populateEmailAddressAutocomplete(Account[] accountArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Account account : accountArray) {
            if (!Patterns.EMAIL_ADDRESS.matcher(account.name).matches()) continue;
            hashSet.add(account.name);
        }
        Object[] objectArray = hashSet.toArray(new String[hashSet.size()]);
        Arrays.sort(objectArray);
        ArrayAdapter arrayAdapter = new ArrayAdapter((Context)this, 17367050, objectArray);
        this.emailEdit.setAdapter((ListAdapter)arrayAdapter);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
    }

    @SuppressLint(value={"NewApi"})
    protected void maybeEnableAnimations() {
        if (AppConstants.Versions.feature11Plus) {
            ViewGroup viewGroup = (ViewGroup)this.remoteErrorTextView.getParent();
            viewGroup.setLayoutTransition(new LayoutTransition());
        }
    }

    protected void updateFromIntentExtras() {
        if (this.getIntent() != null && this.getIntent().getExtras() != null) {
            Bundle bundle = this.getIntent().getExtras();
            this.emailEdit.setText((CharSequence)bundle.getString(EXTRA_EMAIL));
            this.passwordEdit.setText((CharSequence)bundle.getString(EXTRA_PASSWORD));
            this.setPasswordButtonShown(bundle.getBoolean(EXTRA_PASSWORD_SHOWN, false));
        }
        this.updateServersFromIntentExtras(this.getIntent());
        if (FxAccountUtils.LOG_PERSONAL_INFORMATION) {
            FxAccountUtils.pii(LOG_TAG, "Using auth server: " + this.authServerEndpoint);
            FxAccountUtils.pii(LOG_TAG, "Using sync server: " + this.syncServerEndpoint);
        }
        this.updateCustomServerView();
    }

    @Override
    public void onResume() {
        super.onResume();
        GetAccountsAsyncTask getAccountsAsyncTask = new GetAccountsAsyncTask((Context)this){

            public void onPostExecute(Account[] accountArray) {
                FxAccountAbstractSetupActivity.this.populateEmailAddressAutocomplete(accountArray);
            }
        };
        getAccountsAsyncTask.execute(new Void[0]);
    }

    protected Bundle makeExtrasBundle(String string2, String string3) {
        Bundle bundle = new Bundle();
        if (this.getIntent() != null && this.getIntent().getExtras() != null) {
            bundle.putAll(this.getIntent().getExtras());
        }
        if (string2 == null) {
            string2 = this.emailEdit.getText().toString();
        }
        if (string3 == null) {
            string3 = this.passwordEdit.getText().toString();
        }
        bundle.putString(EXTRA_EMAIL, string2);
        bundle.putString(EXTRA_PASSWORD, string3);
        boolean bl = this.passwordEdit.getTransformationMethod() instanceof SingleLineTransformationMethod;
        bundle.putBoolean(EXTRA_PASSWORD_SHOWN, bl);
        return bundle;
    }

    protected void startActivityInstead(Class<?> clazz, int n, Bundle bundle) {
        Intent intent = new Intent((Context)this, clazz);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        intent.setFlags(65536);
        this.startActivityForResult(intent, n);
    }

    protected void updateServersFromIntentExtras(Intent intent) {
        String string2;
        ExtendedJSONObject extendedJSONObject;
        ExtendedJSONObject extendedJSONObject2;
        this.authServerEndpoint = "https://api.accounts.firefox.com/v1";
        this.syncServerEndpoint = "https://token.services.mozilla.com/1.0/sync/1.5";
        if (intent == null) {
            Logger.warn(LOG_TAG, "Intent is null; ignoring and using default servers.");
            return;
        }
        String string3 = intent.getStringExtra(EXTRA_EXTRAS);
        if (string3 == null) {
            return;
        }
        try {
            extendedJSONObject2 = new ExtendedJSONObject(string3);
            extendedJSONObject = extendedJSONObject2.getObject(JSON_KEY_SERVICES);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception parsing extras; ignoring and using default servers.");
            return;
        }
        String string4 = extendedJSONObject2.getString(JSON_KEY_AUTH);
        String string5 = string2 = extendedJSONObject == null ? null : extendedJSONObject.getString(JSON_KEY_SYNC);
        if (string4 != null) {
            this.authServerEndpoint = string4;
        }
        if (string2 != null) {
            this.syncServerEndpoint = string2;
        }
        if ("https://token.services.mozilla.com/1.0/sync/1.5".equals(this.syncServerEndpoint) && !"https://api.accounts.firefox.com/v1".equals(this.authServerEndpoint)) {
            Logger.warn(LOG_TAG, "Mozilla's Sync token servers only works with Mozilla's auth servers. Sync will likely be mis-configured.");
        }
    }

    protected void updateCustomServerView() {
        boolean bl;
        boolean bl2 = bl = !"https://api.accounts.firefox.com/v1".equals(this.authServerEndpoint) || !"https://token.services.mozilla.com/1.0/sync/1.5".equals(this.syncServerEndpoint);
        if (!bl) {
            this.setCustomServerViewVisibility(8);
            return;
        }
        TextView textView = (TextView)this.ensureFindViewById(null, R.id.account_server_summary, "account server");
        TextView textView2 = (TextView)this.ensureFindViewById(null, R.id.sync_server_summary, "Sync server");
        textView.setText((CharSequence)this.authServerEndpoint);
        textView2.setText((CharSequence)this.syncServerEndpoint);
        this.setCustomServerViewVisibility(0);
    }

    protected void setCustomServerViewVisibility(int n) {
        this.ensureFindViewById(null, R.id.account_server_layout, "account server layout").setVisibility(n);
        this.ensureFindViewById(null, R.id.sync_server_layout, "sync server layout").setVisibility(n);
    }

    protected Map<String, String> getQueryParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("service", JSON_KEY_SYNC);
        return hashMap;
    }

    protected static abstract class GetAccountsAsyncTask
    extends AsyncTask<Void, Void, Account[]> {
        protected final Context context;

        public GetAccountsAsyncTask(Context context) {
            this.context = context;
        }

        protected Account[] doInBackground(Void ... voidArray) {
            return AccountManager.get((Context)this.context).getAccounts();
        }
    }

    protected abstract class AddAccountDelegate
    implements FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse> {
        public final String email;
        public final PasswordStretcher passwordStretcher;
        public final String serverURI;
        public final Map<String, Boolean> selectedEngines;
        public final Map<String, Boolean> authoritiesToSyncAutomaticallyMap;

        public AddAccountDelegate(String string2, PasswordStretcher passwordStretcher, String string3) {
            this(string2, passwordStretcher, string3, null, AndroidFxAccount.DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP);
        }

        public AddAccountDelegate(String string2, PasswordStretcher passwordStretcher, String string3, Map<String, Boolean> map, Map<String, Boolean> map2) {
            if (string2 == null) {
                throw new IllegalArgumentException("email must not be null");
            }
            if (passwordStretcher == null) {
                throw new IllegalArgumentException("passwordStretcher must not be null");
            }
            if (string3 == null) {
                throw new IllegalArgumentException("serverURI must not be null");
            }
            if (map2 == null) {
                throw new IllegalArgumentException("authoritiesToSyncAutomaticallyMap must not be null");
            }
            this.email = string2;
            this.passwordStretcher = passwordStretcher;
            this.serverURI = string3;
            this.selectedEngines = map;
            this.authoritiesToSyncAutomaticallyMap = map2;
        }

        @Override
        public void handleSuccess(FxAccountClient20.LoginResponse loginResponse) {
            AndroidFxAccount androidFxAccount;
            String string2;
            Logger.info(LOG_TAG, "Got success response; adding Android account.");
            try {
                string2 = FxAccountAbstractSetupActivity.this.getTokenServerEndpoint();
                byte[] byArray = this.passwordStretcher.getQuickStretchedPW(loginResponse.remoteEmail.getBytes("UTF-8"));
                byte[] byArray2 = FxAccountUtils.generateUnwrapBKey(byArray);
                Engaged engaged = new Engaged(this.email, loginResponse.uid, loginResponse.verified, byArray2, loginResponse.sessionToken, loginResponse.keyFetchToken);
                androidFxAccount = AndroidFxAccount.addAndroidAccount(FxAccountAbstractSetupActivity.this.getApplicationContext(), this.email, "default", this.serverURI, string2, engaged, this.authoritiesToSyncAutomaticallyMap);
                if (androidFxAccount == null) {
                    throw new RuntimeException("Could not add Android account.");
                }
                if (this.selectedEngines != null) {
                    Logger.info(LOG_TAG, "User has selected engines; storing to prefs.");
                    SyncConfiguration.storeSelectedEnginesToPrefs(androidFxAccount.getSyncPrefs(), this.selectedEngines);
                }
            }
            catch (Exception exception) {
                this.handleError(exception);
                return;
            }
            if (FxAccountUtils.LOG_PERSONAL_INFORMATION) {
                androidFxAccount.dump();
            }
            Intent intent = new Intent();
            intent.putExtra("authAccount", this.email);
            intent.putExtra("accountType", "org.mozilla.fennec_fxaccount");
            FxAccountAbstractSetupActivity.this.setResult(-1, intent);
            string2 = FxAccountAbstractSetupActivity.this.makeSuccessIntent(this.email, loginResponse);
            FxAccountAbstractSetupActivity.this.startActivity((Intent)string2);
            FxAccountAbstractSetupActivity.this.finish();
        }
    }

    protected class TextChangedListener
    implements TextWatcher {
        protected TextChangedListener() {
        }

        public void afterTextChanged(Editable editable) {
            FxAccountAbstractSetupActivity.this.updateButtonState();
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    protected class EditorActionListener
    implements TextView.OnEditorActionListener {
        protected EditorActionListener() {
        }

        public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
            FxAccountAbstractSetupActivity.this.updateButtonState();
            return false;
        }
    }

    protected class FocusChangeListener
    implements View.OnFocusChangeListener {
        protected FocusChangeListener() {
        }

        public void onFocusChange(View view, boolean bl) {
            if (bl) {
                return;
            }
            FxAccountAbstractSetupActivity.this.updateButtonState();
        }
    }
}

