/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Bitmap;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.mozglue.DirectBufferAllocator;

public class BufferedImage {
    private ByteBuffer mBuffer;
    private IntSize mSize;
    private int mFormat;
    private static final String LOGTAG = "GeckoBufferedImage";
    public static final int FORMAT_INVALID = -1;
    public static final int FORMAT_ARGB32 = 0;
    public static final int FORMAT_RGB24 = 1;
    public static final int FORMAT_A8 = 2;
    public static final int FORMAT_A1 = 3;
    public static final int FORMAT_RGB16_565 = 4;

    public BufferedImage() {
        this.mSize = new IntSize(0, 0);
    }

    public BufferedImage(Bitmap bitmap) {
        this.mFormat = BufferedImage.bitmapConfigToFormat(bitmap.getConfig());
        this.mSize = new IntSize(bitmap.getWidth(), bitmap.getHeight());
        int n = BufferedImage.bitsPerPixelForFormat(this.mFormat);
        this.mBuffer = DirectBufferAllocator.allocate((int)(this.mSize.getArea() * n));
        bitmap.copyPixelsToBuffer((Buffer)this.mBuffer.asIntBuffer());
    }

    private synchronized void freeBuffer() {
        this.mBuffer = DirectBufferAllocator.free((ByteBuffer)this.mBuffer);
    }

    public void destroy() {
        try {
            this.freeBuffer();
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"error clearing buffer: ", (Throwable)exception);
        }
    }

    public ByteBuffer getBuffer() {
        return this.mBuffer;
    }

    public IntSize getSize() {
        return this.mSize;
    }

    public int getFormat() {
        return this.mFormat;
    }

    private static int bitsPerPixelForFormat(int n) {
        switch (n) {
            case 3: {
                return 1;
            }
            case 2: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 1: {
                return 24;
            }
            case 0: {
                return 32;
            }
        }
        throw new RuntimeException("Unknown Cairo format");
    }

    private static int bitmapConfigToFormat(Bitmap.Config config) {
        if (config == null) {
            return 0;
        }
        switch (config) {
            case ALPHA_8: {
                return 2;
            }
            case ARGB_4444: {
                throw new RuntimeException("ARGB_444 unsupported");
            }
            case ARGB_8888: {
                return 0;
            }
            case RGB_565: {
                return 4;
            }
        }
        throw new RuntimeException("Unknown Skia bitmap config");
    }
}

