/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.HandleProgressException;
import org.mozilla.gecko.sync.net.SyncStorageCollectionRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageRequest;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class SyncStorageCollectionRequest
extends SyncStorageRequest {
    private static final String LOG_TAG = "CollectionRequest";
    protected volatile boolean aborting = false;

    public SyncStorageCollectionRequest(URI uRI) {
        super(uRI);
    }

    public void abort() {
        this.aborting = true;
        try {
            this.resource.request.abort();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception in abort: " + exception);
        }
    }

    @Override
    protected BaseResourceDelegate makeResourceDelegate(SyncStorageRequest syncStorageRequest) {
        return new SyncCollectionResourceDelegate((SyncStorageCollectionRequest)syncStorageRequest);
    }

    public class SyncCollectionResourceDelegate
    extends SyncStorageRequest.SyncStorageResourceDelegate {
        private static final String CONTENT_TYPE_INCREMENTAL = "application/newlines";
        private static final int FETCH_BUFFER_SIZE = 16384;

        SyncCollectionResourceDelegate(SyncStorageCollectionRequest syncStorageCollectionRequest2) {
            super(SyncStorageCollectionRequest.this, syncStorageCollectionRequest2);
        }

        @Override
        public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
            super.addHeaders(httpRequestBase, defaultHttpClient);
            httpRequestBase.setHeader("Accept", CONTENT_TYPE_INCREMENTAL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleHttpResponse(HttpResponse httpResponse) {
            if (SyncStorageCollectionRequest.this.aborting) {
                return;
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                super.handleHttpResponse(httpResponse);
                return;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            Header header = httpEntity.getContentType();
            if (!header.getValue().startsWith(CONTENT_TYPE_INCREMENTAL)) {
                super.handleHttpResponse(httpResponse);
                return;
            }
            SyncStorageCollectionRequestDelegate syncStorageCollectionRequestDelegate = (SyncStorageCollectionRequestDelegate)this.request.delegate;
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            try {
                String string2;
                inputStream = httpEntity.getContent();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 16384);
                while (!SyncStorageCollectionRequest.this.aborting && null != (string2 = bufferedReader.readLine())) {
                    try {
                        syncStorageCollectionRequestDelegate.handleRequestProgress(string2);
                    }
                    catch (Exception exception) {
                        syncStorageCollectionRequestDelegate.handleRequestError(new HandleProgressException(exception));
                        BaseResource.consumeEntity(httpEntity);
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
                if (SyncStorageCollectionRequest.this.aborting) {
                    return;
                }
            }
            catch (IOException iOException) {
                if (!SyncStorageCollectionRequest.this.aborting) {
                    syncStorageCollectionRequestDelegate.handleRequestError(iOException);
                }
                BaseResource.consumeEntity(httpEntity);
                return;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            BaseResource.consumeEntity(httpEntity);
            syncStorageCollectionRequestDelegate.handleRequestSuccess(new SyncStorageResponse(httpResponse));
        }
    }
}

