/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories;

import android.content.Context;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.mozilla.gecko.sync.InfoCollections;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.Server11RepositorySession;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCreationDelegate;

public class Server11Repository
extends Repository {
    protected String collection;
    protected URI collectionURI;
    protected final AuthHeaderProvider authHeaderProvider;
    protected final InfoCollections infoCollections;

    public Server11Repository(String string2, String string3, AuthHeaderProvider authHeaderProvider, InfoCollections infoCollections) throws URISyntaxException {
        if (string2 == null) {
            throw new IllegalArgumentException("collection must not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("storageURL must not be null");
        }
        if (infoCollections == null) {
            throw new IllegalArgumentException("infoCollections must not be null");
        }
        this.collection = string2;
        this.collectionURI = new URI(string3 + (string3.endsWith("/") ? string2 : "/" + string2));
        this.authHeaderProvider = authHeaderProvider;
        this.infoCollections = infoCollections;
    }

    @Override
    public void createSession(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
        repositorySessionCreationDelegate.onSessionCreated(new Server11RepositorySession(this));
    }

    public URI collectionURI() {
        return this.collectionURI;
    }

    public URI collectionURI(boolean bl, long l, long l2, String string2, String string3) throws URISyntaxException {
        CharSequence charSequence;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("full=1");
        }
        if (l >= 0L) {
            charSequence = Utils.millisecondsToDecimalSecondsString(l);
            arrayList.add("newer=" + (String)charSequence);
        }
        if (l2 > 0L) {
            arrayList.add("limit=" + l2);
        }
        if (string2 != null) {
            arrayList.add("sort=" + string2);
        }
        if (string3 != null) {
            arrayList.add("ids=" + string3);
        }
        if (arrayList.size() == 0) {
            return this.collectionURI;
        }
        charSequence = new StringBuilder();
        int n = 63;
        for (String string4 : arrayList) {
            ((StringBuilder)charSequence).append((char)n);
            n = 38;
            ((StringBuilder)charSequence).append(string4);
        }
        String string5 = this.collectionURI + ((StringBuilder)charSequence).toString();
        return new URI(string5);
    }

    public URI wboURI(String string2) throws URISyntaxException {
        return new URI(this.collectionURI + "/" + string2);
    }

    protected long getDefaultFetchLimit() {
        return -1L;
    }

    protected String getDefaultSort() {
        return null;
    }

    public AuthHeaderProvider getAuthHeaderProvider() {
        return this.authHeaderProvider;
    }

    public boolean updateNeeded(long l) {
        return this.infoCollections.updateNeeded(this.collection, l);
    }
}

