/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabqueue;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.animation.TransitionsTracker;

public class TabQueuePrompt
extends Locales.LocaleAwareActivity {
    public static final String LOGTAG = "Gecko" + TabQueuePrompt.class.getSimpleName();
    private boolean isAnimating;
    private View containerView;
    private View buttonContainer;
    private View enabledConfirmation;

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.showTabQueueEnablePrompt();
    }

    private void showTabQueueEnablePrompt() {
        this.setContentView(R.layout.tab_queue_prompt);
        final int n = GeckoSharedPrefs.forApp((Context)this).getInt("tab_queue_times_prompt_shown", 0);
        this.findViewById(R.id.ok_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabQueuePrompt.this.onConfirmButtonPressed();
                Telemetry.addToHistogram("FENNEC_TABQUEUE_PROMPT_ENABLE_YES", n);
            }
        });
        this.findViewById(R.id.cancel_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Telemetry.addToHistogram("FENNEC_TABQUEUE_PROMPT_ENABLE_NO", n);
                TabQueuePrompt.this.setResult(202);
                TabQueuePrompt.this.finish();
            }
        });
        this.containerView = this.findViewById(R.id.tab_queue_container);
        this.buttonContainer = this.findViewById(R.id.button_container);
        this.enabledConfirmation = this.findViewById(R.id.enabled_confirmation);
        ViewHelper.setTranslationY((View)this.containerView, (float)500.0f);
        ViewHelper.setAlpha((View)this.containerView, (float)0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{0.0f});
        objectAnimator.setDuration(400L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.containerView, (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator2.setStartDelay(200L);
        objectAnimator2.setDuration(600L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator2, objectAnimator});
        animatorSet.setStartDelay(400L);
        TransitionsTracker.track((Animator)animatorSet);
        animatorSet.start();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    private void onConfirmButtonPressed() {
        this.enabledConfirmation.setVisibility(0);
        ViewHelper.setAlpha((View)this.enabledConfirmation, (float)0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.buttonContainer, (String)"alpha", (float[])new float[]{0.0f});
        objectAnimator.setDuration(300L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.enabledConfirmation, (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator2.setDuration(300L);
        objectAnimator2.setStartDelay(200L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, objectAnimator2});
        TransitionsTracker.track((Animator)animatorSet);
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TabQueuePrompt.this.slideOut();
                        TabQueuePrompt.this.setResult(201);
                    }
                }, 1000L);
            }
        });
        animatorSet.start();
    }

    private void slideOut() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getHeight()});
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                TabQueuePrompt.this.finish();
            }
        });
        objectAnimator.start();
    }

    public void onBackPressed() {
        this.slideOut();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.slideOut();
        return true;
    }
}

