/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.AnchoredPopup;
import org.mozilla.gecko.widget.DoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;
import org.mozilla.gecko.widget.SiteLogins;

public class SiteIdentityPopup
extends AnchoredPopup
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoSiteIdentityPopup";
    private static final String MIXED_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android";
    private static final String TRACKING_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/firefox-android-tracking-protection";
    private static final String FORMAT_S = "%s";
    private SiteIdentity mSiteIdentity;
    private LinearLayout mIdentity;
    private LinearLayout mIdentityKnownContainer;
    private LinearLayout mIdentityUnknownContainer;
    private TextView mHost;
    private TextView mOwnerLabel;
    private TextView mOwner;
    private TextView mVerifier;
    private View mDivider;
    private DoorHanger mMixedContentNotification;
    private DoorHanger mTrackingContentNotification;
    private DoorHanger mSelectLoginDoorhanger;
    private final DoorHanger.OnButtonClickListener mContentButtonClickListener = new ContentNotificationButtonListener();

    public SiteIdentityPopup(Context context) {
        super(context);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Doorhanger:Logins");
    }

    @Override
    protected void init() {
        super.init();
        this.setFocusable(true);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mIdentity = (LinearLayout)layoutInflater.inflate(R.layout.site_identity, null);
        this.mContent.addView((View)this.mIdentity);
        this.mIdentityKnownContainer = (LinearLayout)this.mIdentity.findViewById(R.id.site_identity_known_container);
        this.mIdentityUnknownContainer = (LinearLayout)this.mIdentity.findViewById(R.id.site_identity_unknown_container);
        this.mHost = (TextView)this.mIdentityKnownContainer.findViewById(R.id.host);
        this.mOwnerLabel = (TextView)this.mIdentityKnownContainer.findViewById(R.id.owner_label);
        this.mOwner = (TextView)this.mIdentityKnownContainer.findViewById(R.id.owner);
        this.mVerifier = (TextView)this.mIdentityKnownContainer.findViewById(R.id.verifier);
        this.mDivider = this.mIdentity.findViewById(R.id.divider_doorhanger);
        TextView textView = (TextView)this.mIdentity.findViewById(R.id.site_settings_link);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Permissions:Get", null));
                SiteIdentityPopup.this.dismiss();
            }
        });
    }

    private void updateIdentity(SiteIdentity siteIdentity) {
        if (!this.mInflated) {
            this.init();
        }
        boolean bl = siteIdentity.getSecurityMode() != SiteIdentity.SecurityMode.UNKNOWN;
        this.toggleIdentityKnownContainerVisibility(bl);
        if (bl) {
            this.updateIdentityInformation(siteIdentity);
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if ("Doorhanger:Logins".equals(string2)) {
            try {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                    this.addLoginsToTab(jSONObject2);
                }
                if (this.isShowing()) {
                    this.addSelectLoginDoorhanger(tab);
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error accessing logins in Doorhanger:Logins message", (Throwable)jSONException);
            }
        }
    }

    private void addLoginsToTab(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject("title");
        JSONArray jSONArray = jSONObject.getJSONArray("logins");
        SiteLogins siteLogins = new SiteLogins(jSONObject2, jSONArray);
        Tabs.getInstance().getSelectedTab().setSiteLogins(siteLogins);
    }

    private void addSelectLoginDoorhanger(Tab tab) throws JSONException {
        SiteLogins siteLogins = tab.getSiteLogins();
        if (siteLogins == null) {
            return;
        }
        JSONArray jSONArray = siteLogins.getLogins();
        if (jSONArray.length() == 0) {
            return;
        }
        final JSONObject jSONObject = (JSONObject)jSONArray.get(0);
        DoorHanger.OnButtonClickListener onButtonClickListener = new DoorHanger.OnButtonClickListener(){

            @Override
            public void onButtonClick(JSONObject jSONObject2, DoorHanger doorHanger) {
                try {
                    int n = jSONObject2.getInt("callback");
                    if (n == ButtonType.COPY.ordinal()) {
                        ClipboardManager clipboardManager = (ClipboardManager)SiteIdentityPopup.this.mContext.getSystemService("clipboard");
                        String string2 = jSONObject2.has("password") ? jSONObject2.optString("password") : jSONObject.getString("password");
                        if (AppConstants.Versions.feature11Plus) {
                            clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)"password", (CharSequence)string2));
                        } else {
                            clipboardManager.setText((CharSequence)string2);
                        }
                        Toast.makeText((Context)SiteIdentityPopup.this.mContext, (int)R.string.doorhanger_login_select_toast_copy, (int)0).show();
                    }
                    SiteIdentityPopup.this.dismiss();
                }
                catch (JSONException jSONException) {
                    Log.e((String)SiteIdentityPopup.LOGTAG, (String)"Error handling Select login button click", (Throwable)jSONException);
                    Toast.makeText((Context)SiteIdentityPopup.this.mContext, (int)R.string.doorhanger_login_select_toast_copy_error, (int)0).show();
                }
            }
        };
        final DoorhangerConfig doorhangerConfig = new DoorhangerConfig(DoorHanger.Type.LOGIN, onButtonClickListener);
        doorhangerConfig.setButton(this.mContext.getString(R.string.button_cancel), ButtonType.CANCEL.ordinal(), false);
        doorhangerConfig.setButton(this.mContext.getString(R.string.button_copy), ButtonType.COPY.ordinal(), true);
        String string2 = ((JSONObject)jSONArray.get(0)).getString("username");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = this.mContext.getString(R.string.doorhanger_login_no_username);
        }
        String string3 = this.mContext.getString(R.string.doorhanger_login_select_message).replace(FORMAT_S, string2);
        doorhangerConfig.setMessage(string3);
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = siteLogins.getTitle();
        jSONObject2.put("title", (Object)jSONObject3);
        if (jSONArray.length() > 1) {
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("type", (Object)"SELECT");
            JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("logins", (Object)jSONArray);
            jSONObject4.put("bundle", (Object)jSONObject5);
            jSONObject2.put("actionText", (Object)jSONObject4);
        }
        doorhangerConfig.setOptions(jSONObject2);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!SiteIdentityPopup.this.mInflated) {
                    SiteIdentityPopup.this.init();
                }
                SiteIdentityPopup.this.removeSelectLoginDoorhanger();
                SiteIdentityPopup.this.mSelectLoginDoorhanger = DoorHanger.Get(SiteIdentityPopup.this.mContext, doorhangerConfig);
                SiteIdentityPopup.this.mContent.addView((View)SiteIdentityPopup.this.mSelectLoginDoorhanger);
                SiteIdentityPopup.this.mDivider.setVisibility(0);
            }
        });
    }

    private void removeSelectLoginDoorhanger() {
        if (this.mSelectLoginDoorhanger != null) {
            this.mContent.removeView((View)this.mSelectLoginDoorhanger);
            this.mSelectLoginDoorhanger = null;
        }
    }

    private void toggleIdentityKnownContainerVisibility(boolean bl) {
        if (bl) {
            this.mIdentityKnownContainer.setVisibility(0);
            this.mIdentityUnknownContainer.setVisibility(8);
        } else {
            this.mIdentityKnownContainer.setVisibility(8);
            this.mIdentityUnknownContainer.setVisibility(0);
        }
    }

    private void updateIdentityInformation(SiteIdentity siteIdentity) {
        String string2;
        this.mHost.setText((CharSequence)siteIdentity.getHost());
        String string3 = siteIdentity.getOwner();
        if (string3 == null) {
            this.mOwnerLabel.setVisibility(8);
            this.mOwner.setVisibility(8);
        } else {
            this.mOwnerLabel.setVisibility(0);
            this.mOwner.setVisibility(0);
            string2 = siteIdentity.getSupplemental();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string3 = string3 + "\n" + string2;
            }
            this.mOwner.setText((CharSequence)string3);
        }
        string2 = siteIdentity.getVerifier();
        String string4 = siteIdentity.getEncrypted();
        this.mVerifier.setText((CharSequence)(string2 + "\n" + string4));
    }

    private void addMixedContentNotification(boolean bl) {
        int n;
        this.removeMixedContentNotification();
        DoorhangerConfig doorhangerConfig = new DoorhangerConfig(DoorHanger.Type.MIXED_CONTENT, this.mContentButtonClickListener);
        if (bl) {
            n = R.drawable.shield_enabled_doorhanger;
            doorhangerConfig.setMessage(this.mContext.getString(R.string.blocked_mixed_content_message_top) + "\n\n" + this.mContext.getString(R.string.blocked_mixed_content_message_bottom));
        } else {
            n = R.drawable.shield_disabled_doorhanger;
            doorhangerConfig.setMessage(this.mContext.getString(R.string.loaded_mixed_content_message));
        }
        doorhangerConfig.setLink(this.mContext.getString(R.string.learn_more), MIXED_CONTENT_SUPPORT_URL, "\n\n");
        this.addNotificationButtons(doorhangerConfig, bl);
        this.mMixedContentNotification = DoorHanger.Get(this.mContext, doorhangerConfig);
        this.mMixedContentNotification.setIcon(n);
        this.mContent.addView((View)this.mMixedContentNotification);
        this.mDivider.setVisibility(0);
    }

    private void removeMixedContentNotification() {
        if (this.mMixedContentNotification != null) {
            this.mContent.removeView((View)this.mMixedContentNotification);
            this.mMixedContentNotification = null;
        }
    }

    private void addTrackingContentNotification(boolean bl) {
        int n;
        this.removeTrackingContentNotification();
        DoorhangerConfig doorhangerConfig = new DoorhangerConfig(DoorHanger.Type.TRACKING, this.mContentButtonClickListener);
        if (bl) {
            n = R.drawable.shield_enabled_doorhanger;
            doorhangerConfig.setMessage(this.mContext.getString(R.string.blocked_tracking_content_message_top) + "\n\n" + this.mContext.getString(R.string.blocked_tracking_content_message_bottom));
        } else {
            n = R.drawable.shield_disabled_doorhanger;
            doorhangerConfig.setMessage(this.mContext.getString(R.string.loaded_tracking_content_message_top) + "\n\n" + this.mContext.getString(R.string.loaded_tracking_content_message_bottom));
        }
        doorhangerConfig.setLink(this.mContext.getString(R.string.learn_more), TRACKING_CONTENT_SUPPORT_URL, "\n\n");
        this.addNotificationButtons(doorhangerConfig, bl);
        this.mTrackingContentNotification = DoorHanger.Get(this.mContext, doorhangerConfig);
        this.mTrackingContentNotification.setIcon(n);
        this.mContent.addView((View)this.mTrackingContentNotification);
        this.mDivider.setVisibility(0);
    }

    private void removeTrackingContentNotification() {
        if (this.mTrackingContentNotification != null) {
            this.mContent.removeView((View)this.mTrackingContentNotification);
            this.mTrackingContentNotification = null;
        }
    }

    private void addNotificationButtons(DoorhangerConfig doorhangerConfig, boolean bl) {
        if (bl) {
            doorhangerConfig.setButton(this.mContext.getString(R.string.disable_protection), ButtonType.DISABLE.ordinal(), false);
            doorhangerConfig.setButton(this.mContext.getString(R.string.keep_blocking), ButtonType.KEEP_BLOCKING.ordinal(), true);
        } else {
            doorhangerConfig.setButton(this.mContext.getString(R.string.enable_protection), ButtonType.ENABLE.ordinal(), true);
        }
    }

    void setSiteIdentity(SiteIdentity siteIdentity) {
        this.mSiteIdentity = siteIdentity;
    }

    @Override
    public void show() {
        SiteIdentity.TrackingMode trackingMode;
        if (this.mSiteIdentity == null) {
            Log.e((String)LOGTAG, (String)"Can't show site identity popup for undefined state");
            return;
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null && AboutPages.isAboutPage(tab.getURL())) {
            Log.d((String)LOGTAG, (String)"We don't show site identity popups for about: pages");
            return;
        }
        this.updateIdentity(this.mSiteIdentity);
        SiteIdentity.MixedMode mixedMode = this.mSiteIdentity.getMixedMode();
        if (mixedMode != SiteIdentity.MixedMode.UNKNOWN) {
            this.addMixedContentNotification(mixedMode == SiteIdentity.MixedMode.MIXED_CONTENT_BLOCKED);
        }
        if ((trackingMode = this.mSiteIdentity.getTrackingMode()) != SiteIdentity.TrackingMode.UNKNOWN) {
            this.addTrackingContentNotification(trackingMode == SiteIdentity.TrackingMode.TRACKING_CONTENT_BLOCKED);
        }
        try {
            this.addSelectLoginDoorhanger(tab);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error adding selectLogin doorhanger", (Throwable)jSONException);
        }
        this.showDividers();
        super.show();
    }

    private void showDividers() {
        int n = this.mContent.getChildCount();
        DoorHanger doorHanger = null;
        for (int i = 0; i < n; ++i) {
            View view = this.mContent.getChildAt(i);
            if (!(view instanceof DoorHanger)) continue;
            DoorHanger doorHanger2 = (DoorHanger)view;
            doorHanger2.showDivider();
            if (doorHanger2.getVisibility() != 0) continue;
            doorHanger = doorHanger2;
        }
        if (doorHanger != null) {
            doorHanger.hideDivider();
        }
    }

    void destroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Doorhanger:Logins");
    }

    public void dismiss() {
        super.dismiss();
        this.removeMixedContentNotification();
        this.removeTrackingContentNotification();
        this.removeSelectLoginDoorhanger();
        this.mDivider.setVisibility(8);
    }

    private class ContentNotificationButtonListener
    implements DoorHanger.OnButtonClickListener {
        private ContentNotificationButtonListener() {
        }

        @Override
        public void onButtonClick(JSONObject jSONObject, DoorHanger doorHanger) {
            GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:Reload", jSONObject.toString());
            GeckoAppShell.sendEventToGecko(geckoEvent);
            SiteIdentityPopup.this.dismiss();
        }
    }

    public static enum ButtonType {
        DISABLE,
        ENABLE,
        KEEP_BLOCKING,
        CANCEL,
        COPY;

    }
}

