/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport.upload;

import android.content.SharedPreferences;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.HealthReportUtils;
import org.mozilla.gecko.background.healthreport.upload.ObsoleteDocumentTracker;
import org.mozilla.gecko.background.healthreport.upload.SubmissionClient;

public class SubmissionPolicy {
    public static final String LOG_TAG = SubmissionPolicy.class.getSimpleName();
    protected final SharedPreferences sharedPreferences;
    protected final SubmissionClient client;
    protected final boolean uploadEnabled;
    protected final ObsoleteDocumentTracker tracker;

    public SubmissionPolicy(SharedPreferences sharedPreferences, SubmissionClient submissionClient, ObsoleteDocumentTracker obsoleteDocumentTracker, boolean bl) {
        if (sharedPreferences == null) {
            throw new IllegalArgumentException("sharedPreferences must not be null");
        }
        this.sharedPreferences = sharedPreferences;
        this.client = submissionClient;
        this.tracker = obsoleteDocumentTracker;
        this.uploadEnabled = bl;
    }

    public boolean tick(long l) {
        long l2 = this.getNextSubmission();
        if (l2 >= l + 3L * this.getMinimumTimeBetweenUploads()) {
            Logger.warn(LOG_TAG, "Next upload scheduled far in the future; system clock reset? " + l2 + " > " + l);
            this.editor().setNextSubmission(l + this.getMinimumTimeBetweenUploads()).commit();
            return false;
        }
        if (l < l2) {
            Logger.debug(LOG_TAG, "We uploaded less than an interval ago; skipping. " + l2 + " > " + l);
            return false;
        }
        if (!this.uploadEnabled) {
            String string2 = this.tracker.getNextObsoleteId();
            if (string2 == null) {
                return false;
            }
            Editor editor = this.editor();
            editor.setLastDeleteRequested(l);
            this.client.delete(l, string2, new DeleteDelegate(editor));
            return true;
        }
        long l3 = this.getFirstRunLocalTime();
        if (l3 < 0L) {
            l3 = l;
            this.editor().setFirstRunLocalTime(l3).setNextSubmission(l + this.getMinimumTimeBeforeFirstSubmission()).setCurrentDayFailureCount(0).commit();
        }
        if (l < l3 + this.getMinimumTimeBeforeFirstSubmission()) {
            Logger.info(LOG_TAG, "Need to wait " + this.getMinimumTimeBeforeFirstSubmission() + " before first upload.");
            return false;
        }
        if (l >= this.getCurrentDayResetTime()) {
            this.editor().setCurrentDayResetTime(l + this.getMinimumTimeBetweenUploads()).setCurrentDayFailureCount(0).commit();
        }
        String string3 = HealthReportUtils.generateDocumentId();
        Collection<String> collection = this.tracker.getBatchOfObsoleteIds();
        this.tracker.addObsoleteId(string3);
        Editor editor = this.editor();
        editor.setLastUploadRequested(l);
        this.client.upload(l, string3, collection, new UploadDelegate(editor, collection));
        return true;
    }

    protected boolean isLocalException(Exception exception) {
        return exception instanceof MalformedURLException || exception instanceof SocketException || exception instanceof UnknownHostException;
    }

    public SharedPreferences getSharedPreferences() {
        return this.sharedPreferences;
    }

    public long getMinimumTimeBetweenUploads() {
        return this.getSharedPreferences().getLong("healthreport_time_between_uploads", 86400000L);
    }

    public long getMinimumTimeBeforeFirstSubmission() {
        return this.getSharedPreferences().getLong("healthreport_time_before_first_submission", 86400000L);
    }

    public long getMinimumTimeAfterFailure() {
        return this.getSharedPreferences().getLong("healthreport_time_after_failure", 3600000L);
    }

    public long getMaximumFailuresPerDay() {
        return this.getSharedPreferences().getLong("healthreport_maximum_failures_per_day", 2L);
    }

    public long getFirstRunLocalTime() {
        return this.getSharedPreferences().getLong("healthreport_first_run", -1L);
    }

    public long getNextSubmission() {
        return this.getSharedPreferences().getLong("healthreport_next_submission", -1L);
    }

    public int getCurrentDayFailureCount() {
        return this.getSharedPreferences().getInt("healthreport_current_day_failure_count", 0);
    }

    public long getCurrentDayResetTime() {
        return this.getSharedPreferences().getLong("healthreport_current_day_reset_time", -1L);
    }

    protected Editor editor() {
        return new Editor(this.getSharedPreferences().edit());
    }

    public long getLastUploadRequested() {
        return this.getSharedPreferences().getLong("healthreport_last_upload_requested", -1L);
    }

    public long getLastUploadSucceeded() {
        return this.getSharedPreferences().getLong("healthreport_last_upload_succeeded", -1L);
    }

    public long getLastUploadFailed() {
        return this.getSharedPreferences().getLong("healthreport_last_upload_failed", -1L);
    }

    public long getLastDeleteRequested() {
        return this.getSharedPreferences().getLong("healthreport_last_delete_requested", -1L);
    }

    public long getLastDeleteSucceeded() {
        return this.getSharedPreferences().getLong("healthreport_last_delete_succeeded", -1L);
    }

    public long getLastDeleteFailed() {
        return this.getSharedPreferences().getLong("healthreport_last_delete_failed", -1L);
    }

    public long getMinimumTimeBetweenDeletes() {
        return this.getSharedPreferences().getLong("healthreport_time_between_deletes", 3600000L);
    }

    protected static class Editor {
        protected final SharedPreferences.Editor editor;

        public Editor(SharedPreferences.Editor editor) {
            this.editor = editor;
        }

        public void commit() {
            this.editor.commit();
        }

        public Editor setFirstRunLocalTime(long l) {
            this.editor.putLong("healthreport_first_run", l);
            return this;
        }

        public Editor setNextSubmission(long l) {
            this.editor.putLong("healthreport_next_submission", l);
            return this;
        }

        public Editor setCurrentDayFailureCount(int n) {
            this.editor.putInt("healthreport_current_day_failure_count", n);
            return this;
        }

        public Editor setCurrentDayResetTime(long l) {
            this.editor.putLong("healthreport_current_day_reset_time", l);
            return this;
        }

        public Editor clearCurrentDayResetTime() {
            this.editor.putLong("healthreport_current_day_reset_time", -1L);
            return this;
        }

        public Editor setLastUploadRequested(long l) {
            this.editor.putLong("healthreport_last_upload_requested", l);
            return this;
        }

        public Editor setLastUploadSucceeded(long l) {
            this.editor.putLong("healthreport_last_upload_succeeded", l);
            return this;
        }

        public Editor setLastUploadFailed(long l) {
            this.editor.putLong("healthreport_last_upload_failed", l);
            return this;
        }

        public Editor setLastDeleteRequested(long l) {
            this.editor.putLong("healthreport_last_delete_requested", l);
            return this;
        }

        public Editor setLastDeleteSucceeded(long l) {
            this.editor.putLong("healthreport_last_delete_succeeded", l);
            return this;
        }

        public Editor setLastDeleteFailed(long l) {
            this.editor.putLong("healthreport_last_delete_failed", l);
            return this;
        }
    }

    protected class DeleteDelegate
    implements SubmissionClient.Delegate {
        protected final Editor editor;

        public DeleteDelegate(Editor editor) {
            this.editor = editor;
        }

        @Override
        public void onSoftFailure(long l, String string2, String string3, Exception exception) {
            long l2 = l + SubmissionPolicy.this.getMinimumTimeBetweenDeletes();
            if (SubmissionPolicy.this.isLocalException(exception)) {
                Logger.info(LOG_TAG, "Soft failure caused by local exception; not decrementing attempts.");
            } else {
                SubmissionPolicy.this.tracker.decrementObsoleteIdAttempts(string2);
            }
            this.editor.setNextSubmission(l2).setLastDeleteFailed(l).commit();
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.info(LOG_TAG, "Got soft failure at " + l + " deleting obsolete document with id " + string2 + ": " + string3 + " Trying again later.");
            } else {
                Logger.info(LOG_TAG, "Got soft failure at " + l + " deleting obsolete document: " + string3 + " Trying again later.");
            }
        }

        @Override
        public void onHardFailure(long l, String string2, String string3, Exception exception) {
            long l2 = l + SubmissionPolicy.this.getMinimumTimeBetweenDeletes();
            SubmissionPolicy.this.tracker.removeObsoleteId(string2);
            this.editor.setNextSubmission(l2).setLastDeleteFailed(l).commit();
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.warn(LOG_TAG, "Got hard failure at " + l + " deleting obsolete document with id " + string2 + ": " + string3 + " Abandoning delete request.", exception);
            } else {
                Logger.warn(LOG_TAG, "Got hard failure at " + l + " deleting obsolete document: " + string3 + " Abandoning delete request.", exception);
            }
        }

        @Override
        public void onSuccess(long l, String string2) {
            long l2 = l + SubmissionPolicy.this.getMinimumTimeBetweenDeletes();
            SubmissionPolicy.this.tracker.removeObsoleteId(string2);
            this.editor.setNextSubmission(l2).setLastDeleteSucceeded(l).commit();
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.pii(LOG_TAG, "Deleted an obsolete document with id " + string2 + " at " + l + ".");
            } else {
                Logger.info(LOG_TAG, "Deleted an obsolete document at " + l + ".");
            }
        }
    }

    protected class UploadDelegate
    implements SubmissionClient.Delegate {
        protected final Editor editor;
        protected final Collection<String> oldIds;

        public UploadDelegate(Editor editor, Collection<String> collection) {
            this.editor = editor;
            this.oldIds = collection;
        }

        @Override
        public void onSuccess(long l, String string2) {
            long l2 = l + SubmissionPolicy.this.getMinimumTimeBetweenUploads();
            SubmissionPolicy.this.tracker.markIdAsUploaded(string2);
            SubmissionPolicy.this.tracker.purgeObsoleteIds(this.oldIds);
            this.editor.setNextSubmission(l2).setLastUploadSucceeded(l).setCurrentDayFailureCount(0).clearCurrentDayResetTime().commit();
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.pii(LOG_TAG, "Successful upload with id " + string2 + " obsoleting " + this.oldIds.size() + " old records reported at " + l + "; next upload at " + l2 + ".");
            } else {
                Logger.info(LOG_TAG, "Successful upload obsoleting " + this.oldIds.size() + " old records reported at " + l + "; next upload at " + l2 + ".");
            }
        }

        @Override
        public void onHardFailure(long l, String string2, String string3, Exception exception) {
            long l2 = l + SubmissionPolicy.this.getMinimumTimeBetweenUploads();
            if (SubmissionPolicy.this.isLocalException(exception)) {
                Logger.info(LOG_TAG, "Hard failure caused by local exception; not tracking id and not decrementing attempts.");
                SubmissionPolicy.this.tracker.removeObsoleteId(string2);
            } else {
                SubmissionPolicy.this.tracker.decrementObsoleteIdAttempts(this.oldIds);
            }
            this.editor.setNextSubmission(l2).setLastUploadFailed(l).setCurrentDayFailureCount(0).clearCurrentDayResetTime().commit();
            Logger.warn(LOG_TAG, "Hard failure reported at " + l + ": " + string3 + " Next upload at " + l2 + ".", exception);
        }

        @Override
        public void onSoftFailure(long l, String string2, String string3, Exception exception) {
            int n = SubmissionPolicy.this.getCurrentDayFailureCount();
            Logger.warn(LOG_TAG, "Soft failure reported at " + l + ": " + string3 + " Previously failed " + n + " time(s) today.");
            if ((long)n >= SubmissionPolicy.this.getMaximumFailuresPerDay()) {
                this.onHardFailure(l, string2, "Reached the limit of daily upload attempts: " + n, exception);
                return;
            }
            long l2 = l + SubmissionPolicy.this.getMinimumTimeAfterFailure();
            if (SubmissionPolicy.this.isLocalException(exception)) {
                Logger.info(LOG_TAG, "Soft failure caused by local exception; not tracking id and not decrementing attempts.");
                SubmissionPolicy.this.tracker.removeObsoleteId(string2);
            } else {
                SubmissionPolicy.this.tracker.decrementObsoleteIdAttempts(this.oldIds);
            }
            this.editor.setNextSubmission(l2).setLastUploadFailed(l).setCurrentDayFailureCount(n + 1).commit();
            Logger.info(LOG_TAG, "Retrying upload at " + l2 + ".");
        }
    }
}

