/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.authenticator;

import android.content.Context;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.FxAccountLoginStateMachine;
import org.mozilla.gecko.fxa.login.FxAccountLoginTransition;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.login.StateFactory;
import org.mozilla.gecko.fxa.sync.FxAccountNotificationManager;
import org.mozilla.gecko.fxa.sync.FxAccountSyncAdapter;

public abstract class FxADefaultLoginStateMachineDelegate
implements FxAccountLoginStateMachine.LoginStateMachineDelegate {
    protected static final String LOG_TAG = FxAccountLoginStateMachine.LoginStateMachineDelegate.class.getSimpleName();
    protected final Context context;
    protected final AndroidFxAccount fxAccount;
    protected final Executor executor;
    protected final FxAccountClient client;

    public FxADefaultLoginStateMachineDelegate(Context context, AndroidFxAccount androidFxAccount) {
        this.context = context;
        this.fxAccount = androidFxAccount;
        this.executor = Executors.newSingleThreadExecutor();
        this.client = new FxAccountClient20(androidFxAccount.getAccountServerURI(), this.executor);
    }

    public abstract void handleNotMarried(State var1);

    public abstract void handleMarried(Married var1);

    @Override
    public FxAccountClient getClient() {
        return this.client;
    }

    @Override
    public long getCertificateDurationInMilliseconds() {
        return 43200000L;
    }

    @Override
    public long getAssertionDurationInMilliseconds() {
        return 900000L;
    }

    @Override
    public BrowserIDKeyPair generateKeyPair() throws NoSuchAlgorithmException {
        return StateFactory.generateKeyPair();
    }

    @Override
    public void handleTransition(FxAccountLoginTransition.Transition transition, State state) {
        Logger.info(LOG_TAG, "handleTransition: " + transition + " to " + (Object)((Object)state.getStateLabel()));
    }

    @Override
    public void handleFinal(State state) {
        Logger.info(LOG_TAG, "handleFinal: in " + (Object)((Object)state.getStateLabel()));
        this.fxAccount.setState(state);
        FxAccountNotificationManager fxAccountNotificationManager = new FxAccountNotificationManager(FxAccountSyncAdapter.NOTIFICATION_ID);
        fxAccountNotificationManager.update(this.context, this.fxAccount);
        if (state.getStateLabel() != State.StateLabel.Married) {
            this.handleNotMarried(state);
            return;
        }
        this.handleMarried((Married)state);
    }
}

