/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.FrameLayout;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.mozilla.gecko.AndroidGamepadManager;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAccessibility;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.ZoomConstraints;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.FullScreenState;
import org.mozilla.gecko.gfx.GLController;
import org.mozilla.gecko.gfx.GeckoLayerClient;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.InputConnectionHandler;
import org.mozilla.gecko.gfx.JavaPanZoomController;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerMarginsAnimator;
import org.mozilla.gecko.gfx.LayerRenderer;
import org.mozilla.gecko.gfx.Overscroll;
import org.mozilla.gecko.gfx.OverscrollEdgeEffect;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.gfx.PointUtils;
import org.mozilla.gecko.gfx.RenderTask;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;

public class LayerView
extends FrameLayout
implements Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "GeckoLayerView";
    private GeckoLayerClient mLayerClient;
    private PanZoomController mPanZoomController;
    private LayerMarginsAnimator mMarginsAnimator;
    private final GLController mGLController = GLController.getInstance(this);
    private InputConnectionHandler mInputConnectionHandler;
    private LayerRenderer mRenderer;
    private int mPaintState = 0;
    private int mBackgroundColor = -1;
    private FullScreenState mFullScreenState = FullScreenState.NONE;
    private SurfaceView mSurfaceView;
    private TextureView mTextureView;
    private Listener mListener;
    private PointF mInitialTouchPoint;
    private boolean mGeckoIsReady;
    private final Overscroll mOverscroll = AppConstants.Versions.feature14Plus ? new OverscrollEdgeEffect((View)this) : null;
    public static final int PAINT_START = 0;
    public static final int PAINT_BEFORE_FIRST = 1;
    public static final int PAINT_AFTER_FIRST = 2;

    public boolean shouldUseTextureView() {
        return false;
    }

    public LayerView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Tabs.registerOnTabsChangedListener(this);
    }

    public LayerView(Context context) {
        this(context, null);
    }

    public void initializeView(EventDispatcher eventDispatcher) {
        this.mLayerClient = new GeckoLayerClient(this.getContext(), this, eventDispatcher);
        if (this.mOverscroll != null) {
            this.mLayerClient.setOverscrollHandler(this.mOverscroll);
        }
        this.mPanZoomController = this.mLayerClient.getPanZoomController();
        this.mMarginsAnimator = this.mLayerClient.getLayerMarginsAnimator();
        this.mRenderer = new LayerRenderer(this);
        this.mInputConnectionHandler = null;
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        GeckoAccessibility.setDelegate(this);
        GeckoAccessibility.setAccessibilityStateChangeListener(this.getContext());
    }

    public void setIsLongpressEnabled(boolean bl) {
        ((JavaPanZoomController)this.mPanZoomController).setIsLongpressEnabled(bl);
    }

    private static Point getEventRadius(MotionEvent motionEvent) {
        return new Point((int)motionEvent.getToolMajor() / 2, (int)motionEvent.getToolMinor() / 2);
    }

    public void geckoConnected() {
        PrefsHelper.getPref("gfx.android.rgb16.force", new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, boolean bl) {
                if (bl) {
                    GeckoAppShell.setScreenDepthOverride(16);
                }
            }
        });
        this.mLayerClient.notifyGeckoReady();
        this.mInitialTouchPoint = null;
        this.mGeckoIsReady = true;
    }

    private boolean sendEventToGecko(MotionEvent motionEvent) {
        if (!this.mGeckoIsReady) {
            return false;
        }
        int n = motionEvent.getActionMasked();
        PointF pointF = new PointF(motionEvent.getX(), motionEvent.getY());
        if (n == 0) {
            this.mInitialTouchPoint = pointF;
        }
        if (this.mInitialTouchPoint != null && n == 2) {
            Point point = LayerView.getEventRadius(motionEvent);
            if (PointUtils.subtract(pointF, this.mInitialTouchPoint).length() < Math.max(PanZoomController.CLICK_THRESHOLD, Math.min((float)Math.min(point.x, point.y), PanZoomController.PAN_THRESHOLD))) {
                return true;
            }
            this.mInitialTouchPoint = null;
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createMotionEvent(motionEvent, false));
        return true;
    }

    public void showSurface() {
        this.mSurfaceView.setVisibility(0);
    }

    public void hideSurface() {
        this.mSurfaceView.setVisibility(4);
    }

    public void destroy() {
        if (this.mLayerClient != null) {
            this.mLayerClient.destroy();
        }
        if (this.mRenderer != null) {
            this.mRenderer.destroy();
        }
        Tabs.unregisterOnTabsChangedListener(this);
    }

    public void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mLayerClient != null && this.mOverscroll != null) {
            this.mOverscroll.draw(canvas, this.getViewportMetrics());
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getActionMasked() == 0) {
            this.requestFocus();
        }
        if (this.mMarginsAnimator != null && this.mMarginsAnimator.onInterceptTouchEvent(motionEvent)) {
            return true;
        }
        if (this.mPanZoomController != null && this.mPanZoomController.onTouchEvent(motionEvent)) {
            return true;
        }
        return this.sendEventToGecko(motionEvent);
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        if (motionEvent.getSource() == 4098 && !GeckoAccessibility.isEnabled()) {
            return false;
        }
        return this.sendEventToGecko(motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (AndroidGamepadManager.handleMotionEvent(motionEvent)) {
            return true;
        }
        return this.mPanZoomController != null && this.mPanZoomController.onMotionEvent(motionEvent);
    }

    protected void onAttachedToWindow() {
        if (this.shouldUseTextureView()) {
            this.mTextureView = new TextureView(this.getContext());
            this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)new SurfaceTextureListener());
            this.mTextureView.setBackgroundColor(-1);
            this.addView((View)this.mTextureView, -1, -1);
        } else {
            this.setWillNotCacheDrawing(false);
            this.mSurfaceView = new LayerSurfaceView(this.getContext(), this);
            this.mSurfaceView.setBackgroundColor(-1);
            this.addView((View)this.mSurfaceView, -1, -1);
            SurfaceHolder surfaceHolder = this.mSurfaceView.getHolder();
            surfaceHolder.addCallback((SurfaceHolder.Callback)new SurfaceListener());
        }
    }

    GeckoLayerClient getLayerClient() {
        return this.mLayerClient;
    }

    public Object getLayerClientObject() {
        return this.mLayerClient;
    }

    public PanZoomController getPanZoomController() {
        return this.mPanZoomController;
    }

    public LayerMarginsAnimator getLayerMarginsAnimator() {
        return this.mMarginsAnimator;
    }

    public ImmutableViewportMetrics getViewportMetrics() {
        return this.mLayerClient.getViewportMetrics();
    }

    public void abortPanning() {
        if (this.mPanZoomController != null) {
            this.mPanZoomController.abortPanning();
        }
    }

    public PointF convertViewPointToLayerPoint(PointF pointF) {
        return this.mLayerClient.convertViewPointToLayerPoint(pointF);
    }

    int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
        this.requestRender();
    }

    public void setZoomConstraints(ZoomConstraints zoomConstraints) {
        this.mLayerClient.setZoomConstraints(zoomConstraints);
    }

    public void setIsRTL(boolean bl) {
        this.mLayerClient.setIsRTL(bl);
    }

    public void setInputConnectionHandler(InputConnectionHandler inputConnectionHandler) {
        this.mInputConnectionHandler = inputConnectionHandler;
    }

    public Handler getHandler() {
        if (this.mInputConnectionHandler != null) {
            return this.mInputConnectionHandler.getHandler(super.getHandler());
        }
        return super.getHandler();
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        if (this.mInputConnectionHandler != null) {
            return this.mInputConnectionHandler.onCreateInputConnection(editorInfo);
        }
        return null;
    }

    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        return this.mInputConnectionHandler != null && this.mInputConnectionHandler.onKeyPreIme(n, keyEvent);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (this.mPanZoomController != null && this.mPanZoomController.onKeyEvent(keyEvent)) {
            return true;
        }
        return this.mInputConnectionHandler != null && this.mInputConnectionHandler.onKeyDown(n, keyEvent);
    }

    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return this.mInputConnectionHandler != null && this.mInputConnectionHandler.onKeyLongPress(n, keyEvent);
    }

    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return this.mInputConnectionHandler != null && this.mInputConnectionHandler.onKeyMultiple(n, n2, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.mInputConnectionHandler != null && this.mInputConnectionHandler.onKeyUp(n, keyEvent);
    }

    public boolean isIMEEnabled() {
        if (this.mInputConnectionHandler != null) {
            return this.mInputConnectionHandler.isIMEEnabled();
        }
        return false;
    }

    public void requestRender() {
        if (this.mListener != null) {
            this.mListener.renderRequested();
        }
    }

    public void addLayer(Layer layer) {
        this.mRenderer.addLayer(layer);
    }

    public void removeLayer(Layer layer) {
        this.mRenderer.removeLayer(layer);
    }

    public void postRenderTask(RenderTask renderTask) {
        this.mRenderer.postRenderTask(renderTask);
    }

    public void removeRenderTask(RenderTask renderTask) {
        this.mRenderer.removeRenderTask(renderTask);
    }

    public int getMaxTextureSize() {
        return this.mRenderer.getMaxTextureSize();
    }

    @RobocopTarget
    public IntBuffer getPixels() {
        return this.mRenderer.getPixels();
    }

    public void setPaintState(int n) {
        this.mPaintState = n;
    }

    public int getPaintState() {
        return this.mPaintState;
    }

    public LayerRenderer getRenderer() {
        return this.mRenderer;
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    Listener getListener() {
        return this.mListener;
    }

    public GLController getGLController() {
        return this.mGLController;
    }

    private Bitmap getDrawable(String string2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        Context context = this.getContext();
        int n = context.getResources().getIdentifier(string2, "drawable", context.getPackageName());
        return BitmapUtils.decodeResource(context, n, options);
    }

    Bitmap getScrollbarImage() {
        return this.getDrawable("scrollbar");
    }

    private void onSizeChanged(int n, int n2) {
        if (!this.mGLController.isServerSurfaceValid() || this.mSurfaceView == null) {
            this.surfaceChanged(n, n2);
            return;
        }
        if (this.mListener != null) {
            this.mListener.sizeChanged(n, n2);
        }
        if (this.mOverscroll != null) {
            this.mOverscroll.setSize(n, n2);
        }
    }

    private void surfaceChanged(int n, int n2) {
        this.mGLController.serverSurfaceChanged(n, n2);
        if (this.mListener != null) {
            this.mListener.surfaceChanged(n, n2);
        }
        if (this.mOverscroll != null) {
            this.mOverscroll.setSize(n, n2);
        }
    }

    private void onDestroyed() {
        this.mGLController.serverSurfaceDestroyed();
    }

    public Object getNativeWindow() {
        if (this.mSurfaceView != null) {
            return this.mSurfaceView.getHolder();
        }
        return this.mTextureView.getSurfaceTexture();
    }

    @WrapElementForJNI(allowMultithread=true, stubName="RegisterCompositorWrapper")
    public static GLController registerCxxCompositor() {
        try {
            LayerView layerView = GeckoAppShell.getLayerView();
            GLController gLController = layerView.getGLController();
            gLController.compositorCreated();
            return gLController;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error registering compositor!", (Throwable)exception);
            return null;
        }
    }

    @WrapElementForJNI(allowMultithread=true, stubName="updateZoomedView")
    public static void updateZoomedView(ByteBuffer byteBuffer) {
        LayerRenderer layerRenderer;
        LayerView layerView = GeckoAppShell.getLayerView();
        if (layerView != null && (layerRenderer = layerView.getRenderer()) != null) {
            layerRenderer.updateZoomedView(byteBuffer);
        }
    }

    @RobocopTarget
    public void addDrawListener(DrawListener drawListener) {
        this.mLayerClient.addDrawListener(drawListener);
    }

    @RobocopTarget
    public void removeDrawListener(DrawListener drawListener) {
        this.mLayerClient.removeDrawListener(drawListener);
    }

    public void setOverScrollMode(int n) {
        super.setOverScrollMode(n);
        if (this.mPanZoomController != null) {
            this.mPanZoomController.setOverScrollMode(n);
        }
    }

    public int getOverScrollMode() {
        if (this.mPanZoomController != null) {
            return this.mPanZoomController.getOverScrollMode();
        }
        return super.getOverScrollMode();
    }

    public void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        GeckoAccessibility.onLayerViewFocusChanged(this, bl);
    }

    public void setFullScreenState(FullScreenState fullScreenState) {
        this.mFullScreenState = fullScreenState;
    }

    public boolean isFullScreen() {
        return this.mFullScreenState != FullScreenState.NONE;
    }

    public FullScreenState getFullScreenState() {
        return this.mFullScreenState;
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        if (tabEvents == Tabs.TabEvents.VIEWPORT_CHANGE && Tabs.getInstance().isSelectedTab(tab) && this.mLayerClient != null) {
            this.setZoomConstraints(tab.getZoomConstraints());
            this.setIsRTL(tab.getIsRTL());
        }
    }

    public void setOnMetricsChangedDynamicToolbarViewportListener(OnMetricsChangedListener onMetricsChangedListener) {
        this.mLayerClient.setOnMetricsChangedDynamicToolbarViewportListener(onMetricsChangedListener);
    }

    public void setOnMetricsChangedZoomedViewportListener(OnMetricsChangedListener onMetricsChangedListener) {
        this.mLayerClient.setOnMetricsChangedZoomedViewportListener(onMetricsChangedListener);
    }

    public void addZoomedViewListener(ZoomedViewListener zoomedViewListener) {
        this.mRenderer.addZoomedViewListener(zoomedViewListener);
    }

    public void removeZoomedViewListener(ZoomedViewListener zoomedViewListener) {
        this.mRenderer.removeZoomedViewListener(zoomedViewListener);
    }

    public static interface ZoomedViewListener {
        public void requestZoomedViewRender();

        public void updateView(ByteBuffer var1);
    }

    public static interface OnMetricsChangedListener {
        public void onMetricsChanged(ImmutableViewportMetrics var1);

        public void onPanZoomStopped();
    }

    @RobocopTarget
    public static interface DrawListener {
        public void drawFinished();
    }

    private class SurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        private SurfaceTextureListener() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
            LayerView.this.onSizeChanged(n, n2);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            LayerView.this.onDestroyed();
            return true;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
            LayerView.this.onSizeChanged(n, n2);
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }

    private class LayerSurfaceView
    extends SurfaceView {
        LayerView mParent;

        public LayerSurfaceView(Context context, LayerView layerView2) {
            super(context);
            this.mParent = layerView2;
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            if (bl) {
                this.mParent.surfaceChanged(n3 - n, n4 - n2);
            }
        }
    }

    private class SurfaceListener
    implements SurfaceHolder.Callback {
        private SurfaceListener() {
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            LayerView.this.onSizeChanged(n2, n3);
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            LayerView.this.onDestroyed();
        }
    }

    public static interface Listener {
        public void renderRequested();

        public void sizeChanged(int var1, int var2);

        public void surfaceChanged(int var1, int var2);
    }
}

