/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.crypto;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.HKDF;
import org.mozilla.gecko.sync.crypto.HMACVerificationException;
import org.mozilla.gecko.sync.crypto.KeyBundle;

public class CryptoInfo {
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String KEY_ALGORITHM_SPEC = "AES";
    private byte[] message;
    private byte[] iv;
    private byte[] hmac;
    private KeyBundle keys;

    public static CryptoInfo encrypt(byte[] byArray, KeyBundle keyBundle) throws CryptoException {
        CryptoInfo cryptoInfo = new CryptoInfo(byArray, keyBundle);
        cryptoInfo.encrypt();
        return cryptoInfo;
    }

    public static CryptoInfo encrypt(byte[] byArray, byte[] byArray2, KeyBundle keyBundle) throws CryptoException {
        CryptoInfo cryptoInfo = new CryptoInfo(byArray, byArray2, null, keyBundle);
        cryptoInfo.encrypt();
        return cryptoInfo;
    }

    public static CryptoInfo decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, KeyBundle keyBundle) throws CryptoException {
        CryptoInfo cryptoInfo = new CryptoInfo(byArray, byArray2, byArray3, keyBundle);
        cryptoInfo.decrypt();
        return cryptoInfo;
    }

    public CryptoInfo(byte[] byArray, KeyBundle keyBundle) {
        this.setMessage(byArray);
        this.setKeys(keyBundle);
    }

    public CryptoInfo(byte[] byArray, byte[] byArray2, byte[] byArray3, KeyBundle keyBundle) {
        this.setMessage(byArray);
        this.setIV(byArray2);
        this.setHMAC(byArray3);
        this.setKeys(keyBundle);
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] byArray) {
        this.message = byArray;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public void setIV(byte[] byArray) {
        this.iv = byArray;
    }

    public byte[] getHMAC() {
        return this.hmac;
    }

    public void setHMAC(byte[] byArray) {
        this.hmac = byArray;
    }

    public KeyBundle getKeys() {
        return this.keys;
    }

    public void setKeys(KeyBundle keyBundle) {
        this.keys = keyBundle;
    }

    public static byte[] generatedHMACFor(byte[] byArray, KeyBundle keyBundle) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = HKDF.makeHMACHasher(keyBundle.getHMACKey());
        return mac.doFinal(Base64.encodeBase64((byte[])byArray));
    }

    public boolean generatedHMACIsHMAC() throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray = CryptoInfo.generatedHMACFor(this.getMessage(), this.getKeys());
        byte[] byArray2 = this.getHMAC();
        return Arrays.equals(byArray, byArray2);
    }

    private static byte[] commonCrypto(Cipher cipher, byte[] byArray) throws CryptoException {
        byte[] byArray2 = null;
        try {
            byArray2 = cipher.doFinal(byArray);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new CryptoException(generalSecurityException);
        }
        return byArray2;
    }

    public void encrypt() throws CryptoException {
        byte[] byArray;
        Object object;
        byte[] byArray2;
        Cipher cipher = CryptoInfo.getCipher(TRANSFORMATION);
        try {
            byArray2 = this.getKeys().getEncryptionKey();
            object = new SecretKeySpec(byArray2, KEY_ALGORITHM_SPEC);
            if (this.getIV() == null || this.getIV().length == 0) {
                cipher.init(1, (Key)object);
            } else {
                cipher.init(1, (Key)object, new IvParameterSpec(this.getIV()));
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(generalSecurityException);
        }
        byArray2 = CryptoInfo.commonCrypto(cipher, this.getMessage());
        object = cipher.getIV();
        try {
            byArray = CryptoInfo.generatedHMACFor(byArray2, this.keys);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            throw new CryptoException(generalSecurityException);
        }
        this.setHMAC(byArray);
        this.setIV((byte[])object);
        this.setMessage(byArray2);
    }

    public void decrypt() throws CryptoException {
        Object object;
        byte[] byArray;
        try {
            if (!this.generatedHMACIsHMAC()) {
                throw new HMACVerificationException();
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            throw new CryptoException(generalSecurityException);
        }
        Cipher cipher = CryptoInfo.getCipher(TRANSFORMATION);
        try {
            byArray = this.getKeys().getEncryptionKey();
            object = new SecretKeySpec(byArray, KEY_ALGORITHM_SPEC);
            cipher.init(2, (Key)object, new IvParameterSpec(this.getIV()));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(generalSecurityException);
        }
        byArray = CryptoInfo.commonCrypto(cipher, this.getMessage());
        object = cipher.getIV();
        this.setHMAC(null);
        this.setIV((byte[])object);
        this.setMessage(byArray);
    }

    private static Cipher getCipher(String string2) throws CryptoException {
        try {
            return Cipher.getInstance(string2);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new CryptoException(generalSecurityException);
        }
    }
}

