/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search.providers;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Scanner;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.util.FileUtils;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.RawResource;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.search.providers.SearchEngine;
import org.xmlpull.v1.XmlPullParserException;

public class SearchEngineManager
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String LOG_TAG = "GeckoSearchEngineManager";
    private static final String PREF_GECKO_DEFAULT_ENGINE = "browser.search.defaultenginename";
    private static final String PREF_GECKO_DEFAULT_LOCALE = "distribution.searchplugins.defaultLocale";
    private static final String PREF_DEFAULT_ENGINE_KEY = "search.engines.defaultname";
    private static final String PREF_REGION_KEY = "search.region";
    private static final String GEOIP_LOCATION_URL = "https://location.services.mozilla.com/v1/country?key=3b4d27dd-703d-4094-8398-4de2c763505a";
    private static final String USER_AGENT = HardwareUtils.isTablet() ? "Mozilla/5.0 (Android; Tablet; rv:41.0a1) Gecko/41.0a1 Firefox/41.0a1" : "Mozilla/5.0 (Android; Mobile; rv:41.0a1) Gecko/41.0a1 Firefox/41.0a1";
    private Context context;
    private Distribution distribution;
    private SearchEngineCallback changeCallback;
    private SearchEngine engine;
    private String fallbackLocale;
    private String distributionLocale;
    private int ignorePreferenceChange = 0;

    public SearchEngineManager(Context context, Distribution distribution) {
        this.context = context;
        this.distribution = distribution;
        GeckoSharedPrefs.forApp((Context)context).registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void setChangeCallback(SearchEngineCallback searchEngineCallback) {
        this.changeCallback = searchEngineCallback;
    }

    public void getEngine(SearchEngineCallback searchEngineCallback) {
        if (this.engine != null) {
            searchEngineCallback.execute(this.engine);
        } else {
            this.getDefaultEngine(searchEngineCallback);
        }
    }

    public void destroy() {
        GeckoSharedPrefs.forApp((Context)this.context).unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        this.context = null;
        this.distribution = null;
        this.changeCallback = null;
        this.engine = null;
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
        if (!TextUtils.equals((CharSequence)PREF_DEFAULT_ENGINE_KEY, (CharSequence)string2)) {
            return;
        }
        if (this.ignorePreferenceChange > 0) {
            --this.ignorePreferenceChange;
            return;
        }
        this.getDefaultEngine(this.changeCallback);
    }

    private void runCallback(final SearchEngine searchEngine, final SearchEngineCallback searchEngineCallback) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SearchEngineManager.this.engine = searchEngine;
                searchEngineCallback.execute(searchEngine);
            }
        });
    }

    private void getDefaultEngine(final SearchEngineCallback searchEngineCallback) {
        this.distribution.addOnDistributionReadyCallback(new Distribution.ReadyCallback(){

            public void distributionNotFound() {
                this.defaultBehavior();
            }

            public void distributionFound(Distribution distribution) {
                this.defaultBehavior();
            }

            public void distributionArrivedLate(Distribution distribution) {
                String string2 = SearchEngineManager.this.getDefaultEngineNameFromDistribution();
                if (string2 == null) {
                    return;
                }
                SearchEngineManager.this.ignorePreferenceChange++;
                GeckoSharedPrefs.forApp((Context)SearchEngineManager.this.context).edit().putString(SearchEngineManager.PREF_DEFAULT_ENGINE_KEY, string2).apply();
                SearchEngine searchEngine = SearchEngineManager.this.createEngineFromName(string2);
                SearchEngineManager.this.runCallback(searchEngine, searchEngineCallback);
            }

            private void defaultBehavior() {
                String string2 = GeckoSharedPrefs.forApp((Context)SearchEngineManager.this.context).getString(SearchEngineManager.PREF_DEFAULT_ENGINE_KEY, null);
                String string3 = GeckoSharedPrefs.forApp((Context)SearchEngineManager.this.context).getString(SearchEngineManager.PREF_REGION_KEY, null);
                if (string2 != null && string3 != null) {
                    Log.d((String)SearchEngineManager.LOG_TAG, (String)("Found default engine name in SharedPreferences: " + string2));
                } else {
                    string2 = SearchEngineManager.this.getDefaultEngineNameFromDistribution();
                    if (string2 == null) {
                        string2 = SearchEngineManager.this.getDefaultEngineNameFromLocale();
                    }
                    SearchEngineManager.this.ignorePreferenceChange++;
                    GeckoSharedPrefs.forApp((Context)SearchEngineManager.this.context).edit().putString(SearchEngineManager.PREF_DEFAULT_ENGINE_KEY, string2).apply();
                }
                SearchEngine searchEngine = SearchEngineManager.this.createEngineFromName(string2);
                SearchEngineManager.this.runCallback(searchEngine, searchEngineCallback);
            }
        });
    }

    private String getDefaultEngineNameFromDistribution() {
        if (!this.distribution.exists()) {
            return null;
        }
        File file = this.distribution.getDistributionFile("preferences.json");
        if (file == null) {
            return null;
        }
        try {
            JSONObject jSONObject;
            String string2;
            JSONObject jSONObject2 = new JSONObject(FileUtils.getFileContents((File)file));
            if (jSONObject2.has("Preferences") && (string2 = jSONObject2.getJSONObject("Preferences")).has(PREF_GECKO_DEFAULT_LOCALE)) {
                Log.d((String)LOG_TAG, (String)"Found default searchplugin locale in distribution Preferences.");
                this.distributionLocale = string2.getString(PREF_GECKO_DEFAULT_LOCALE);
            }
            string2 = Locales.getLanguageTag((Locale)Locale.getDefault());
            String string3 = "LocalizablePreferences." + string2;
            if (jSONObject2.has(string3) && (jSONObject = jSONObject2.getJSONObject(string3)).has(PREF_GECKO_DEFAULT_ENGINE)) {
                Log.d((String)LOG_TAG, (String)"Found default engine name in distribution LocalizablePreferences override.");
                return jSONObject.getString(PREF_GECKO_DEFAULT_ENGINE);
            }
            if (jSONObject2.has("LocalizablePreferences") && (jSONObject = jSONObject2.getJSONObject("LocalizablePreferences")).has(PREF_GECKO_DEFAULT_ENGINE)) {
                Log.d((String)LOG_TAG, (String)"Found default engine name in distribution LocalizablePreferences.");
                return jSONObject.getString(PREF_GECKO_DEFAULT_ENGINE);
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Error getting search engine name from preferences.json", (Throwable)iOException);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOG_TAG, (String)"Error parsing preferences.json", (Throwable)jSONException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHttpResponse(HttpURLConnection httpURLConnection) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            String string2 = new Scanner(bufferedInputStream).useDelimiter("\\A").next();
            return string2;
        }
        catch (Exception exception) {
            String string3 = "";
            return string3;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException) {
                    Log.e((String)LOG_TAG, (String)"Error closing InputStream", (Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchCountryCode() {
        String string2 = GeckoSharedPrefs.forApp((Context)this.context).getString(PREF_REGION_KEY, null);
        if (string2 != null) {
            return string2;
        }
        try {
            String string3 = null;
            URL uRL = new URL(GEOIP_LOCATION_URL);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            try {
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setConnectTimeout(10000);
                httpURLConnection.setReadTimeout(10000);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("User-Agent", USER_AGENT);
                httpURLConnection.setRequestProperty("Content-Type", "application/json");
                httpURLConnection.setFixedLengthStreamingMode("{}".getBytes().length);
                OutputStream outputStream = httpURLConnection.getOutputStream();
                outputStream.write("{}".getBytes());
                outputStream.close();
                string3 = this.getHttpResponse(httpURLConnection);
            }
            finally {
                httpURLConnection.disconnect();
            }
            if (string3 == null) {
                Log.e((String)LOG_TAG, (String)"Country code fetch failed");
                return null;
            }
            JSONObject jSONObject = new JSONObject(string3);
            return jSONObject.optString("country_code", null);
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Country code fetch failed", (Throwable)exception);
            return null;
        }
    }

    private String getDefaultEngineNameFromLocale() {
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = new JSONObject(RawResource.getAsString((Context)this.context, (int)R.raw.browsersearch));
            String string2 = this.fetchCountryCode();
            GeckoSharedPrefs.forApp((Context)this.context).edit().putString(PREF_REGION_KEY, string2 == null ? "" : string2).apply();
            if (string2 != null && jSONObject2.has("regions") && (jSONObject = jSONObject2.getJSONObject("regions")).has(string2)) {
                JSONObject jSONObject3 = jSONObject.getJSONObject(string2);
                Log.d((String)LOG_TAG, (String)"Found region-specific default engine name in browsersearch.json.");
                return jSONObject3.getString("default");
            }
            if (jSONObject2.has("default")) {
                Log.d((String)LOG_TAG, (String)"Found default engine name in browsersearch.json.");
                return jSONObject2.getString("default");
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Error getting search engine name from browsersearch.json", (Throwable)iOException);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOG_TAG, (String)"Error parsing browsersearch.json", (Throwable)jSONException);
        }
        return null;
    }

    private SearchEngine createEngineFromName(String string2) {
        SearchEngine searchEngine = this.createEngineFromDistribution(string2);
        if (searchEngine == null) {
            searchEngine = this.createEngineFromLocale(string2);
        }
        if (searchEngine == null) {
            searchEngine = this.createEngineFromProfile(string2);
        }
        if (searchEngine == null) {
            Log.e((String)LOG_TAG, (String)("Could not create search engine from name: " + string2));
        }
        return searchEngine;
    }

    private SearchEngine createEngineFromDistribution(String string2) {
        File file;
        if (!this.distribution.exists()) {
            return null;
        }
        File file2 = this.distribution.getDistributionFile("searchplugins");
        if (file2 == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        File[] fileArray = new File(file2, "common").listFiles();
        if (fileArray != null) {
            Collections.addAll(arrayList, fileArray);
        }
        if ((file = new File(file2, "locale")) != null) {
            File[] fileArray2;
            String string3 = Locales.getLanguageTag((Locale)Locale.getDefault());
            File[] fileArray3 = new File(file, string3).listFiles();
            if (fileArray3 != null) {
                Collections.addAll(arrayList, fileArray3);
            } else if (this.distributionLocale != null && (fileArray2 = new File(file, this.distributionLocale).listFiles()) != null) {
                Collections.addAll(arrayList, fileArray2);
            }
        }
        if (arrayList.isEmpty()) {
            Log.e((String)LOG_TAG, (String)"Could not find search plugin files in distribution directory");
            return null;
        }
        return this.createEngineFromFileList(arrayList.toArray(new File[arrayList.size()]), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchEngine createEngineFromLocale(String string2) {
        InputStream inputStream = this.getInputStreamFromSearchPluginsJar("list.txt");
        BufferedReader bufferedReader = this.getBufferedReader(inputStream);
        try {
            while (true) {
                String string3;
                if ((string3 = bufferedReader.readLine()) != null) {
                    InputStream inputStream2 = this.getInputStreamFromSearchPluginsJar(string3 + ".xml");
                    SearchEngine searchEngine = this.createEngineFromInputStream(string3, inputStream2);
                    if (searchEngine == null || !searchEngine.getName().equals(string2)) continue;
                    SearchEngine searchEngine2 = searchEngine;
                    return searchEngine2;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)("Error creating shipped search engine from name: " + string2), (Throwable)iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private SearchEngine createEngineFromProfile(String string2) {
        File file = GeckoProfile.get((Context)this.context).getFile("searchplugins");
        if (file == null) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            Log.e((String)LOG_TAG, (String)"Could not find search plugin files in profile directory");
            return null;
        }
        return this.createEngineFromFileList(fileArray, string2);
    }

    private SearchEngine createEngineFromFileList(File[] fileArray, String string2) {
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                SearchEngine searchEngine = this.createEngineFromInputStream(null, fileInputStream);
                if (searchEngine == null || !searchEngine.getName().equals(string2)) continue;
                return searchEngine;
            }
            catch (IOException iOException) {
                Log.e((String)LOG_TAG, (String)("Error creating search engine from name: " + string2), (Throwable)iOException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchEngine createEngineFromInputStream(String string2, InputStream inputStream) {
        SearchEngine searchEngine;
        try {
            searchEngine = new SearchEngine(string2, inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException | XmlPullParserException throwable2) {
                Log.e((String)LOG_TAG, (String)"Exception creating search engine", (Throwable)throwable2);
                return null;
            }
        }
        inputStream.close();
        return searchEngine;
    }

    private InputStream getInputStreamFromSearchPluginsJar(String string2) {
        Locale locale = Locale.getDefault();
        String string3 = Locales.getLanguageTag((Locale)locale);
        String string4 = SearchEngineManager.getSearchPluginsJarURL(this.context, string3, string2);
        InputStream inputStream = GeckoJarReader.getStream((String)string4);
        if (inputStream != null) {
            return inputStream;
        }
        String string5 = Locales.getLanguage((Locale)locale);
        if (!string3.equals(string5) && (inputStream = GeckoJarReader.getStream((String)(string4 = SearchEngineManager.getSearchPluginsJarURL(this.context, string5, string2)))) != null) {
            return inputStream;
        }
        string4 = SearchEngineManager.getSearchPluginsJarURL(this.context, this.getFallbackLocale(), string2);
        return GeckoJarReader.getStream((String)string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFallbackLocale() {
        if (this.fallbackLocale != null) {
            return this.fallbackLocale;
        }
        InputStream inputStream = GeckoJarReader.getStream((String)GeckoJarReader.getJarURL((Context)this.context, (String)"chrome/chrome.manifest"));
        BufferedReader bufferedReader = this.getBufferedReader(inputStream);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.startsWith("locale global ")) continue;
                this.fallbackLocale = string2.split(" ", 4)[2];
                break;
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Error reading fallback locale from chrome registry", (Throwable)iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return this.fallbackLocale;
    }

    private static String getSearchPluginsJarURL(Context context, String string2, String string3) {
        String string4 = "chrome/" + string2 + "/locale/" + string2 + "/browser/searchplugins/" + string3;
        return GeckoJarReader.getJarURL((Context)context, (String)string4);
    }

    private BufferedReader getBufferedReader(InputStream inputStream) {
        try {
            return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static interface SearchEngineCallback {
        public void execute(SearchEngine var1);
    }
}

