/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.browserid.verifier;

import java.net.URI;
import java.net.URISyntaxException;
import org.mozilla.gecko.browserid.verifier.AbstractBrowserIDRemoteVerifierClient;
import org.mozilla.gecko.browserid.verifier.BrowserIDVerifierDelegate;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.net.BaseResource;

public class BrowserIDRemoteVerifierClient20
extends AbstractBrowserIDRemoteVerifierClient {
    public static final String LOG_TAG = BrowserIDRemoteVerifierClient20.class.getSimpleName();
    public static final String DEFAULT_VERIFIER_URL = "https://verifier.accounts.firefox.com/v2";
    protected static final String JSON_KEY_ASSERTION = "assertion";
    protected static final String JSON_KEY_AUDIENCE = "audience";

    public BrowserIDRemoteVerifierClient20() throws URISyntaxException {
        super(new URI(DEFAULT_VERIFIER_URL));
    }

    public BrowserIDRemoteVerifierClient20(URI uRI) {
        super(uRI);
    }

    @Override
    public void verify(String string2, String string3, BrowserIDVerifierDelegate browserIDVerifierDelegate) {
        if (string2 == null) {
            throw new IllegalArgumentException("audience cannot be null.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("assertion cannot be null.");
        }
        if (browserIDVerifierDelegate == null) {
            throw new IllegalArgumentException("delegate cannot be null.");
        }
        BaseResource baseResource = new BaseResource(this.verifierUri);
        baseResource.delegate = new AbstractBrowserIDRemoteVerifierClient.RemoteVerifierResourceDelegate(baseResource, browserIDVerifierDelegate);
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put(JSON_KEY_AUDIENCE, string2);
        extendedJSONObject.put(JSON_KEY_ASSERTION, string3);
        try {
            baseResource.post(extendedJSONObject);
        }
        catch (Exception exception) {
            browserIDVerifierDelegate.handleError(exception);
        }
    }
}

