/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.gfx.FloatSize;

public class IntSize {
    public final int width;
    public final int height;

    public IntSize(IntSize intSize) {
        this.width = intSize.width;
        this.height = intSize.height;
    }

    public IntSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public IntSize(FloatSize floatSize) {
        this.width = Math.round(floatSize.width);
        this.height = Math.round(floatSize.height);
    }

    public IntSize(JSONObject jSONObject) {
        try {
            this.width = jSONObject.getInt("width");
            this.height = jSONObject.getInt("height");
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public int getArea() {
        return this.width * this.height;
    }

    public boolean equals(IntSize intSize) {
        return intSize.width == this.width && intSize.height == this.height;
    }

    public boolean isPositive() {
        return this.width > 0 && this.height > 0;
    }

    public String toString() {
        return "(" + this.width + "," + this.height + ")";
    }

    public IntSize scale(float f) {
        return new IntSize(Math.round((float)this.width * f), Math.round((float)this.height * f));
    }

    public static int nextPowerOfTwo(int n) {
        if (0 == n--) {
            return 1;
        }
        n = n >> 1 | n;
        n = n >> 2 | n;
        n = n >> 4 | n;
        n = n >> 8 | n;
        n = n >> 16 | n;
        return n + 1;
    }

    public IntSize nextPowerOfTwo() {
        return new IntSize(IntSize.nextPowerOfTwo(this.width), IntSize.nextPowerOfTwo(this.height));
    }

    public static boolean isPowerOfTwo(int n) {
        if (n == 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    public static int largestPowerOfTwoLessThan(float f) {
        int n = (int)Math.floor(f);
        if (n <= 0) {
            throw new IllegalArgumentException("Error: value must be > 0");
        }
        int n2 = n;
        while (n != 0) {
            n2 = n;
            n &= n - 1;
        }
        return n2;
    }
}

