/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.UnexpectedJSONException;
import org.mozilla.gecko.sync.Utils;

public class ExtendedJSONObject {
    public JSONObject object;

    protected static JSONParser getJSONParser() {
        return new JSONParser();
    }

    protected static Object parseRaw(Reader reader) throws ParseException, IOException {
        try {
            return ExtendedJSONObject.getJSONParser().parse(reader);
        }
        catch (Error error) {
            throw new ParseException(2);
        }
    }

    protected static Object parseRaw(String string2) throws ParseException {
        try {
            return ExtendedJSONObject.getJSONParser().parse(string2);
        }
        catch (Error error) {
            throw new ParseException(2);
        }
    }

    public static JSONArray parseJSONArray(Reader reader) throws IOException, ParseException, NonArrayJSONException {
        Object object = ExtendedJSONObject.parseRaw(reader);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new NonArrayJSONException("value must be a JSON array");
    }

    public static JSONArray parseJSONArray(String string2) throws IOException, ParseException, NonArrayJSONException {
        Object object = ExtendedJSONObject.parseRaw(string2);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new NonArrayJSONException("value must be a JSON array");
    }

    public static ExtendedJSONObject parseJSONObject(Reader reader) throws IOException, ParseException, NonObjectJSONException {
        return new ExtendedJSONObject(reader);
    }

    public static ExtendedJSONObject parseJSONObject(String string2) throws IOException, ParseException, NonObjectJSONException {
        return new ExtendedJSONObject(string2);
    }

    public static ExtendedJSONObject parseUTF8AsJSONObject(byte[] byArray) throws ParseException, NonObjectJSONException, IOException {
        return ExtendedJSONObject.parseJSONObject(new String(byArray, "UTF-8"));
    }

    public ExtendedJSONObject() {
        this.object = new JSONObject();
    }

    public ExtendedJSONObject(JSONObject jSONObject) {
        this.object = jSONObject;
    }

    public ExtendedJSONObject deepCopy() {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        Set set = this.object.entrySet();
        for (Map.Entry entry : set) {
            String string2 = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof JSONArray) {
                try {
                    extendedJSONObject.put(string2, new JSONParser().parse(((JSONArray)v).toJSONString()));
                }
                catch (ParseException parseException) {}
                continue;
            }
            if (v instanceof JSONObject) {
                extendedJSONObject.put(string2, new ExtendedJSONObject((JSONObject)((JSONObject)v)).deepCopy().object);
                continue;
            }
            if (v instanceof ExtendedJSONObject) {
                extendedJSONObject.put(string2, ((ExtendedJSONObject)v).deepCopy());
                continue;
            }
            extendedJSONObject.put(string2, v);
        }
        return extendedJSONObject;
    }

    public ExtendedJSONObject(Reader reader) throws IOException, ParseException, NonObjectJSONException {
        if (reader == null) {
            this.object = new JSONObject();
            return;
        }
        Object object = ExtendedJSONObject.parseRaw(reader);
        if (!(object instanceof JSONObject)) {
            throw new NonObjectJSONException("value must be a JSON object");
        }
        this.object = (JSONObject)object;
    }

    public ExtendedJSONObject(String string2) throws IOException, ParseException, NonObjectJSONException {
        this(string2 == null ? null : new StringReader(string2));
    }

    public ExtendedJSONObject clone() {
        return new ExtendedJSONObject((JSONObject)this.object.clone());
    }

    public Object get(String string2) {
        return this.object.get((Object)string2);
    }

    public long getLong(String string2, long l) {
        if (!this.object.containsKey((Object)string2)) {
            return l;
        }
        Long l2 = this.getLong(string2);
        if (l2 == null) {
            return l;
        }
        return l2;
    }

    public Long getLong(String string2) {
        return (Long)this.get(string2);
    }

    public String getString(String string2) {
        return (String)this.get(string2);
    }

    public Boolean getBoolean(String string2) {
        return (Boolean)this.get(string2);
    }

    public Integer getIntegerSafely(String string2) throws NumberFormatException {
        Object object = this.object.get((Object)string2);
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return ((Long)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object, 10);
        }
        throw new NumberFormatException("Expecting Integer, got " + object.getClass());
    }

    public Long getTimestamp(String string2) {
        Object object = this.object.get((Object)string2);
        if (object instanceof Double) {
            double d = (Double)object * 1000.0;
            return Double.valueOf(d).longValue();
        }
        if (object instanceof Float) {
            double d = ((Float)object).doubleValue() * 1000.0;
            return Double.valueOf(d).longValue();
        }
        if (object instanceof Number) {
            return ((Number)object).longValue() * 1000L;
        }
        return null;
    }

    public boolean containsKey(String string2) {
        return this.object.containsKey((Object)string2);
    }

    public String toJSONString() {
        return this.object.toJSONString();
    }

    public String toString() {
        return this.object.toString();
    }

    public void put(String string2, Object object) {
        JSONObject jSONObject = this.object;
        jSONObject.put(string2, object);
    }

    public void putAll(Map map) {
        this.object.putAll(map);
    }

    public boolean remove(String string2) {
        Object object = this.object.remove((Object)string2);
        return object != null;
    }

    public ExtendedJSONObject getObject(String string2) throws NonObjectJSONException {
        Object object = this.object.get((Object)string2);
        if (object == null) {
            return null;
        }
        if (object instanceof ExtendedJSONObject) {
            return (ExtendedJSONObject)object;
        }
        if (object instanceof JSONObject) {
            return new ExtendedJSONObject((JSONObject)object);
        }
        throw new NonObjectJSONException("value must be a JSON object for key: " + string2);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.object.entrySet();
    }

    public Set<String> keySet() {
        return this.object.keySet();
    }

    public JSONArray getArray(String string2) throws NonArrayJSONException {
        Object object = this.object.get((Object)string2);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new NonArrayJSONException("key must be a JSON array: " + string2);
    }

    public int size() {
        return this.object.size();
    }

    public int hashCode() {
        if (this.object == null) {
            return this.getClass().hashCode();
        }
        return this.object.hashCode() ^ this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExtendedJSONObject)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExtendedJSONObject extendedJSONObject = (ExtendedJSONObject)object;
        if (this.object == null) {
            return extendedJSONObject.object == null;
        }
        return this.object.equals((Object)extendedJSONObject.object);
    }

    public void throwIfFieldsMissingOrMisTyped(String[] stringArray, Class<?> clazz) throws UnexpectedJSONException.BadRequiredFieldJSONException {
        for (String string2 : stringArray) {
            Object object = this.get(string2);
            if (object == null) {
                throw new UnexpectedJSONException.BadRequiredFieldJSONException("Expected key not present in result: " + string2);
            }
            if (clazz == null || clazz.isInstance(object)) continue;
            throw new UnexpectedJSONException.BadRequiredFieldJSONException("Value for key not an instance of " + clazz + ": " + string2);
        }
    }

    public byte[] getByteArrayBase64(String string2) {
        String string3 = (String)this.object.get((Object)string2);
        if (string3 == null) {
            return null;
        }
        return Base64.decodeBase64((String)string3);
    }

    public byte[] getByteArrayHex(String string2) {
        String string3 = (String)this.object.get((Object)string2);
        if (string3 == null) {
            return null;
        }
        return Utils.hex2Byte(string3);
    }
}

