/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.config.activities;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.ListView;
import android.widget.Toast;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.setup.SyncAccounts;
import org.mozilla.gecko.sync.syncadapter.SyncAdapter;

public class SelectEnginesActivity
extends Activity
implements DialogInterface.OnClickListener,
DialogInterface.OnMultiChoiceClickListener {
    public static final String LOG_TAG = "SelectEnginesAct";
    protected AccountManager mAccountManager;
    protected Context mContext;
    final String[] _collectionsNames = new String[]{"bookmarks", "passwords", "history", "tabs"};
    protected String[] _options;
    final boolean[] _selections = new boolean[this._collectionsNames.length];
    protected Account account;
    protected SharedPreferences accountPrefs;

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mContext = this.getApplicationContext();
        this.mAccountManager = AccountManager.get((Context)this.mContext);
        this._options = new String[]{this.getString(R.string.sync_configure_engines_title_bookmarks), this.getString(R.string.sync_configure_engines_title_passwords), this.getString(R.string.sync_configure_engines_title_history), this.getString(R.string.sync_configure_engines_title_tabs)};
        ThreadPool.run(new Runnable(){

            @Override
            public void run() {
                Account[] accountArray = SyncAccounts.syncAccounts(SelectEnginesActivity.this.mContext);
                if (accountArray.length == 0) {
                    Logger.error(SelectEnginesActivity.LOG_TAG, "Failed to get account!");
                    SelectEnginesActivity.this.finish();
                    return;
                }
                SelectEnginesActivity.this.account = accountArray[0];
                try {
                    if (SelectEnginesActivity.this.accountPrefs == null) {
                        SelectEnginesActivity.this.accountPrefs = SyncAccounts.blockingPrefsFromDefaultProfileV0(SelectEnginesActivity.this.mContext, SelectEnginesActivity.this.mAccountManager, SelectEnginesActivity.this.account);
                    }
                }
                catch (Exception exception) {
                    Logger.error(SelectEnginesActivity.LOG_TAG, "Failed to get sync account info or shared preferences.", exception);
                    SelectEnginesActivity.this.finish();
                }
                SelectEnginesActivity.this.setSelectionsInArray(SelectEnginesActivity.getEnginesToSelect(SelectEnginesActivity.this.accountPrefs), SelectEnginesActivity.this._selections);
            }
        });
    }

    public void onResume() {
        super.onResume();
        if (this.accountPrefs != null) {
            this.setSelectionsInArray(SelectEnginesActivity.getEnginesToSelect(this.accountPrefs), this._selections);
        }
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).setTitle(R.string.sync_configure_engines_sync_my_title).setMultiChoiceItems((CharSequence[])this._options, this._selections, (DialogInterface.OnMultiChoiceClickListener)this).setIcon(R.drawable.icon).setPositiveButton(17039370, (DialogInterface.OnClickListener)this).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)this).create();
        alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                SelectEnginesActivity.this.finish();
            }
        });
        alertDialog.show();
    }

    private static Set<String> getEnginesFromPrefs(SharedPreferences sharedPreferences) {
        Set<String> set = SyncConfiguration.getEnabledEngineNames(sharedPreferences);
        if (set == null) {
            set = SyncConfiguration.validEngineNames();
        }
        return set;
    }

    public static Set<String> getEnginesToSelect(SharedPreferences sharedPreferences) {
        Set<String> set = SelectEnginesActivity.getEnginesFromPrefs(sharedPreferences);
        Map<String, Boolean> map = SyncConfiguration.getUserSelectedEngines(sharedPreferences);
        if (map != null) {
            for (Map.Entry<String, Boolean> entry : map.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    set.add(entry.getKey());
                    continue;
                }
                set.remove(entry.getKey());
            }
        }
        return set;
    }

    public void setSelectionsInArray(Set<String> set, boolean[] blArray) {
        for (int i = 0; i < this._collectionsNames.length; ++i) {
            blArray[i] = set.contains(this._collectionsNames[i]);
        }
    }

    public void onClick(DialogInterface dialogInterface, int n) {
        if (n == -1) {
            Logger.debug(LOG_TAG, "Saving selected engines.");
            this.saveSelections();
            this.setResult(-1);
            Toast.makeText((Context)this, (int)R.string.sync_notification_savedprefs, (int)0).show();
        } else {
            this.setResult(0);
        }
        this.finish();
    }

    public void onClick(DialogInterface dialogInterface, int n, boolean bl) {
        this._selections[n] = bl;
        ListView listView = ((AlertDialog)dialogInterface).getListView();
        listView.setItemChecked(n, bl);
    }

    private void saveSelections() {
        boolean[] blArray = new boolean[this._options.length];
        this.setSelectionsInArray(SelectEnginesActivity.getEnginesFromPrefs(this.accountPrefs), blArray);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (int i = 0; i < this._selections.length; ++i) {
            if (this._selections[i] == blArray[i]) continue;
            hashMap.put(this._collectionsNames[i], this._selections[i]);
        }
        SyncConfiguration.storeSelectedEnginesToPrefs(this.accountPrefs, hashMap);
        SyncAdapter.requestImmediateSync(this.account, null);
    }
}

