/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentUris;
import android.database.Cursor;
import android.net.Uri;
import android.util.SparseArray;
import java.util.ArrayList;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.InvalidRequestException;
import org.mozilla.gecko.sync.repositories.InvalidSessionTransitionException;
import org.mozilla.gecko.sync.repositories.MultipleRecordsForGuidException;
import org.mozilla.gecko.sync.repositories.NoGuidForIdException;
import org.mozilla.gecko.sync.repositories.NoStoreDelegateException;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.ParentNotFoundException;
import org.mozilla.gecko.sync.repositories.ProfileDatabaseException;
import org.mozilla.gecko.sync.repositories.RecordFilter;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.StoreTrackingRepositorySession;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserRepositoryDataAccessor;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionBeginDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFetchRecordsDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionGuidsSinceDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionWipeDelegate;
import org.mozilla.gecko.sync.repositories.domain.Record;

public abstract class AndroidBrowserRepositorySession
extends StoreTrackingRepositorySession {
    public static final String LOG_TAG = "BrowserRepoSession";
    protected AndroidBrowserRepositoryDataAccessor dbHelper;
    protected SparseArray<String> recordToGuid;
    protected int storeCount = 0;

    public AndroidBrowserRepositorySession(Repository repository) {
        super(repository);
    }

    protected abstract Record retrieveDuringStore(Cursor var1) throws NoGuidForIdException, NullCursorException, ParentNotFoundException;

    protected abstract Record retrieveDuringFetch(Cursor var1) throws NoGuidForIdException, NullCursorException, ParentNotFoundException;

    public boolean shouldIgnore(Record record) {
        return false;
    }

    protected void fixupRecord(Record record) {
    }

    protected Record transformRecord(Record record) throws NullCursorException {
        return record;
    }

    @Override
    public void begin(RepositorySessionBeginDelegate repositorySessionBeginDelegate) throws InvalidSessionTransitionException {
        RepositorySessionBeginDelegate repositorySessionBeginDelegate2 = repositorySessionBeginDelegate.deferredBeginDelegate(this.delegateQueue);
        super.sharedBegin();
        try {
            this.checkDatabase();
        }
        catch (ProfileDatabaseException profileDatabaseException) {
            Logger.error(LOG_TAG, "ProfileDatabaseException from begin. Fennec must be launched once until this error is fixed");
            repositorySessionBeginDelegate2.onBeginFailed(profileDatabaseException);
            return;
        }
        catch (Exception exception) {
            repositorySessionBeginDelegate2.onBeginFailed(exception);
            return;
        }
        this.storeTracker = AndroidBrowserRepositorySession.createStoreTracker();
        repositorySessionBeginDelegate2.onBeginSucceeded(this);
    }

    @Override
    public void finish(RepositorySessionFinishDelegate repositorySessionFinishDelegate) throws InactiveSessionException {
        this.dbHelper = null;
        this.recordToGuid = null;
        super.finish(repositorySessionFinishDelegate);
    }

    protected abstract String buildRecordString(Record var1);

    protected void checkDatabase() throws ProfileDatabaseException, NullCursorException {
        Logger.debug(LOG_TAG, "BEGIN: checking database.");
        try {
            this.dbHelper.fetch(new String[]{"none"}).close();
            Logger.debug(LOG_TAG, "END: checking database.");
        }
        catch (NullPointerException nullPointerException) {
            throw new ProfileDatabaseException(nullPointerException);
        }
    }

    @Override
    public void guidsSince(long l, RepositorySessionGuidsSinceDelegate repositorySessionGuidsSinceDelegate) {
        GuidsSinceRunnable guidsSinceRunnable = new GuidsSinceRunnable(l, repositorySessionGuidsSinceDelegate);
        this.delegateQueue.execute(guidsSinceRunnable);
    }

    @Override
    public void fetch(String[] stringArray, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) throws InactiveSessionException {
        FetchRunnable fetchRunnable = new FetchRunnable(stringArray, AndroidBrowserRepositorySession.now(), null, repositorySessionFetchRecordsDelegate);
        this.executeDelegateCommand(fetchRunnable);
    }

    @Override
    public void fetchSince(long l, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        if (this.storeTracker == null) {
            throw new IllegalStateException("Store tracker not yet initialized!");
        }
        Logger.debug(LOG_TAG, "Running fetchSince(" + l + ").");
        FetchSinceRunnable fetchSinceRunnable = new FetchSinceRunnable(l, AndroidBrowserRepositorySession.now(), this.storeTracker.getFilter(), repositorySessionFetchRecordsDelegate);
        this.delegateQueue.execute(fetchSinceRunnable);
    }

    @Override
    public void fetchAll(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        this.fetchSince(0L, repositorySessionFetchRecordsDelegate);
    }

    @Override
    public void store(final Record record) throws NoStoreDelegateException {
        if (this.delegate == null) {
            throw new NoStoreDelegateException();
        }
        if (record == null) {
            Logger.error(LOG_TAG, "Record sent to store was null");
            throw new IllegalArgumentException("Null record passed to AndroidBrowserRepositorySession.store().");
        }
        ++this.storeCount;
        Logger.debug(LOG_TAG, "Storing record with GUID " + record.guid + " (stored " + this.storeCount + " records this session).");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!AndroidBrowserRepositorySession.this.isActive()) {
                    Logger.warn(AndroidBrowserRepositorySession.LOG_TAG, "AndroidBrowserRepositorySession is inactive. Store failing.");
                    AndroidBrowserRepositorySession.this.delegate.onRecordStoreFailed(new InactiveSessionException(null), record.guid);
                    return;
                }
                if (AndroidBrowserRepositorySession.this.shouldIgnore(record)) {
                    Logger.debug(AndroidBrowserRepositorySession.LOG_TAG, "Ignoring record " + record.guid);
                    return;
                }
                long l = 0L;
                long l2 = 0L;
                boolean bl = record.lastModified > l2;
                try {
                    Record record4 = AndroidBrowserRepositorySession.this.retrieveByGUIDDuringStore(record.guid);
                    if (record.deleted) {
                        boolean bl2;
                        if (record4 == null) {
                            AndroidBrowserRepositorySession.trace("Incoming record " + record.guid + " is deleted, and no local version. Bye!");
                            return;
                        }
                        if (record4.deleted) {
                            AndroidBrowserRepositorySession.trace("Local record already deleted. Bye!");
                            return;
                        }
                        if (!bl) {
                            AndroidBrowserRepositorySession.trace("Ignoring deleted record from the past.");
                            return;
                        }
                        boolean bl3 = bl2 = record4.lastModified > l;
                        if (!bl2) {
                            AndroidBrowserRepositorySession.trace("Remote modified, local not. Deleting.");
                            AndroidBrowserRepositorySession.this.storeRecordDeletion(record, record4);
                            return;
                        }
                        AndroidBrowserRepositorySession.trace("Both local and remote records have been modified.");
                        if (record.lastModified > record4.lastModified) {
                            AndroidBrowserRepositorySession.trace("Remote is newer, and deleted. Deleting local.");
                            AndroidBrowserRepositorySession.this.storeRecordDeletion(record, record4);
                            return;
                        }
                        AndroidBrowserRepositorySession.trace("Remote is older, local is not deleted. Ignoring.");
                        if (!bl2) {
                            Logger.warn(AndroidBrowserRepositorySession.LOG_TAG, "Inconsistency: old remote record is deleted, but local record not modified!");
                        }
                        return;
                    }
                    AndroidBrowserRepositorySession.this.fixupRecord(record);
                    if (record4 == null) {
                        AndroidBrowserRepositorySession.trace("Looking up match for record " + record.guid);
                        record4 = AndroidBrowserRepositorySession.this.findExistingRecord(record);
                    }
                    if (record4 == null) {
                        AndroidBrowserRepositorySession.trace("No match. Inserting.");
                        AndroidBrowserRepositorySession.this.insert(record);
                        return;
                    }
                    AndroidBrowserRepositorySession.trace("Incoming record " + record.guid + " dupes to local record " + record4.guid);
                    record4 = AndroidBrowserRepositorySession.this.transformRecord(record4);
                    Record record2 = AndroidBrowserRepositorySession.this.reconcileRecords(record, record4, l2, l);
                    if (record2 == null) {
                        Logger.debug(AndroidBrowserRepositorySession.LOG_TAG, "Reconciling returned null. Not inserting a record.");
                        return;
                    }
                    Logger.debug(AndroidBrowserRepositorySession.LOG_TAG, "Replacing existing " + record4.guid + (record2.deleted ? " with deleted record " : " with record ") + record2.guid);
                    Record record3 = AndroidBrowserRepositorySession.this.replace(record2, record4);
                    Logger.debug(AndroidBrowserRepositorySession.LOG_TAG, "Calling delegate callback with guid " + record3.guid + "(" + record3.androidID + ")");
                    AndroidBrowserRepositorySession.this.delegate.onRecordStoreSucceeded(record3.guid);
                    return;
                }
                catch (MultipleRecordsForGuidException multipleRecordsForGuidException) {
                    Logger.error(AndroidBrowserRepositorySession.LOG_TAG, "Multiple records returned for given guid: " + record.guid);
                    AndroidBrowserRepositorySession.this.delegate.onRecordStoreFailed(multipleRecordsForGuidException, record.guid);
                    return;
                }
                catch (NoGuidForIdException noGuidForIdException) {
                    Logger.error(AndroidBrowserRepositorySession.LOG_TAG, "Store failed for " + record.guid, noGuidForIdException);
                    AndroidBrowserRepositorySession.this.delegate.onRecordStoreFailed(noGuidForIdException, record.guid);
                    return;
                }
                catch (Exception exception) {
                    Logger.error(AndroidBrowserRepositorySession.LOG_TAG, "Store failed for " + record.guid, exception);
                    AndroidBrowserRepositorySession.this.delegate.onRecordStoreFailed(exception, record.guid);
                    return;
                }
            }
        };
        this.storeWorkQueue.execute(runnable);
    }

    protected void storeRecordDeletion(Record record, Record record2) {
        this.dbHelper.purgeGuid(record.guid);
        this.delegate.onRecordStoreSucceeded(record.guid);
    }

    protected void insert(Record record) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        Record record2 = this.prepareRecord(record);
        Uri uri = this.dbHelper.insert(record2);
        if (uri == null) {
            throw new NullCursorException(new RuntimeException("Got null URI inserting record with guid " + record.guid));
        }
        record2.androidID = ContentUris.parseId((Uri)uri);
        this.updateBookkeeping(record2);
        this.trackRecord(record2);
        this.delegate.onRecordStoreSucceeded(record2.guid);
        Logger.debug(LOG_TAG, "Inserted record with guid " + record2.guid + " as androidID " + record2.androidID);
    }

    protected Record replace(Record record, Record record2) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        Record record3 = this.prepareRecord(record);
        this.dbHelper.update(record2.guid, record3);
        this.updateBookkeeping(record3);
        Logger.debug(LOG_TAG, "replace() returning record " + record3.guid);
        return record3;
    }

    protected Record retrieveByGUIDDuringStore(String string2) throws NoGuidForIdException, NullCursorException, ParentNotFoundException, MultipleRecordsForGuidException {
        try (Cursor cursor = this.dbHelper.fetch(new String[]{string2});){
            if (!cursor.moveToFirst()) {
                Record record = null;
                return record;
            }
            Record record = this.retrieveDuringStore(cursor);
            cursor.moveToNext();
            if (cursor.isAfterLast()) {
                Record record2 = record;
                return record2;
            }
            throw new MultipleRecordsForGuidException(null);
        }
    }

    protected Record findExistingRecord(Record record) throws MultipleRecordsForGuidException, NoGuidForIdException, NullCursorException, ParentNotFoundException {
        Logger.debug(LOG_TAG, "Finding existing record for incoming record with GUID " + record.guid);
        String string2 = this.buildRecordString(record);
        if (string2 == null) {
            Logger.debug(LOG_TAG, "No record string for incoming record " + record.guid);
            return null;
        }
        if (Logger.LOG_PERSONAL_INFORMATION) {
            Logger.pii(LOG_TAG, "Searching with record string " + string2);
        } else {
            Logger.debug(LOG_TAG, "Searching with record string.");
        }
        String string3 = this.getGuidForString(string2);
        if (string3 == null) {
            Logger.debug(LOG_TAG, "Failed to find existing record for " + record.guid);
            return null;
        }
        Logger.debug(LOG_TAG, "Found one. Checking stored record.");
        Record record2 = this.retrieveByGUIDDuringStore(string3);
        String string4 = this.buildRecordString(record);
        if (string2.equals(string4)) {
            Logger.debug(LOG_TAG, "Existing record matches incoming record.  Returning existing record.");
            return record2;
        }
        Logger.debug(LOG_TAG, "Existing record does not match incoming record.  Trying to find record by record string.");
        return this.findByRecordString(string2);
    }

    protected String getGuidForString(String string2) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        if (this.recordToGuid == null) {
            this.createRecordToGuidMap();
        }
        return (String)this.recordToGuid.get(string2.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createRecordToGuidMap() throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        Logger.info(LOG_TAG, "BEGIN: creating record -> GUID map.");
        this.recordToGuid = new SparseArray();
        try (Cursor cursor = this.dbHelper.fetchAll();){
            if (!cursor.moveToFirst()) {
                return;
            }
            while (!cursor.isAfterLast()) {
                String string2;
                Record record = this.retrieveDuringStore(cursor);
                if (record != null && (string2 = this.buildRecordString(record)) != null) {
                    this.recordToGuid.put(string2.hashCode(), (Object)record.guid);
                }
                cursor.moveToNext();
            }
        }
        Logger.info(LOG_TAG, "END: creating record -> GUID map.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Record findByRecordString(String string2) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        try (Cursor cursor = this.dbHelper.fetchAll();){
            Record record;
            if (!cursor.moveToFirst()) {
                Record record2 = null;
                return record2;
            }
            while (!cursor.isAfterLast()) {
                String string3;
                record = this.retrieveDuringStore(cursor);
                if (record != null && string2.equals(string3 = this.buildRecordString(record))) {
                    Record record3 = record;
                    return record3;
                }
                cursor.moveToNext();
            }
            record = null;
            return record;
        }
    }

    public void putRecordToGuidMap(String string2, String string3) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        if (string2 == null) {
            return;
        }
        if (this.recordToGuid == null) {
            this.createRecordToGuidMap();
        }
        this.recordToGuid.put(string2.hashCode(), (Object)string3);
    }

    protected abstract Record prepareRecord(Record var1);

    protected void updateBookkeeping(Record record) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        this.putRecordToGuidMap(this.buildRecordString(record), record.guid);
    }

    protected WipeRunnable getWipeRunnable(RepositorySessionWipeDelegate repositorySessionWipeDelegate) {
        return new WipeRunnable(repositorySessionWipeDelegate);
    }

    @Override
    public void wipe(RepositorySessionWipeDelegate repositorySessionWipeDelegate) {
        WipeRunnable wipeRunnable = this.getWipeRunnable(repositorySessionWipeDelegate);
        this.storeWorkQueue.execute(wipeRunnable);
    }

    public AndroidBrowserRepositoryDataAccessor getDBHelper() {
        return this.dbHelper;
    }

    class WipeRunnable
    implements Runnable {
        protected RepositorySessionWipeDelegate delegate;

        public WipeRunnable(RepositorySessionWipeDelegate repositorySessionWipeDelegate) {
            this.delegate = repositorySessionWipeDelegate;
        }

        @Override
        public void run() {
            if (!AndroidBrowserRepositorySession.this.isActive()) {
                this.delegate.onWipeFailed(new InactiveSessionException(null));
                return;
            }
            AndroidBrowserRepositorySession.this.dbHelper.wipe();
            this.delegate.onWipeSucceeded();
        }
    }

    class FetchSinceRunnable
    extends FetchingRunnable {
        private final long since;
        private final long end;
        private final RecordFilter filter;

        public FetchSinceRunnable(long l, long l2, RecordFilter recordFilter, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
            super(repositorySessionFetchRecordsDelegate);
            this.since = l;
            this.end = l2;
            this.filter = recordFilter;
        }

        @Override
        public void run() {
            if (!AndroidBrowserRepositorySession.this.isActive()) {
                this.delegate.onFetchFailed(new InactiveSessionException(null), null);
                return;
            }
            try {
                Cursor cursor = AndroidBrowserRepositorySession.this.dbHelper.fetchSince(this.since);
                this.fetchFromCursor(cursor, this.filter, this.end);
            }
            catch (NullCursorException nullCursorException) {
                this.delegate.onFetchFailed(nullCursorException, null);
                return;
            }
        }
    }

    public class FetchRunnable
    extends FetchingRunnable {
        private final String[] guids;
        private final long end;
        private final RecordFilter filter;

        public FetchRunnable(String[] stringArray, long l, RecordFilter recordFilter, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
            super(repositorySessionFetchRecordsDelegate);
            this.guids = stringArray;
            this.end = l;
            this.filter = recordFilter;
        }

        @Override
        public void run() {
            if (!AndroidBrowserRepositorySession.this.isActive()) {
                this.delegate.onFetchFailed(new InactiveSessionException(null), null);
                return;
            }
            if (this.guids == null || this.guids.length < 1) {
                Logger.error(AndroidBrowserRepositorySession.LOG_TAG, "No guids sent to fetch");
                this.delegate.onFetchFailed(new InvalidRequestException(null), null);
                return;
            }
            try {
                Cursor cursor = AndroidBrowserRepositorySession.this.dbHelper.fetch(this.guids);
                this.fetchFromCursor(cursor, this.filter, this.end);
            }
            catch (NullCursorException nullCursorException) {
                this.delegate.onFetchFailed(nullCursorException, null);
            }
        }
    }

    abstract class FetchingRunnable
    implements Runnable {
        protected final RepositorySessionFetchRecordsDelegate delegate;

        public FetchingRunnable(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
            this.delegate = repositorySessionFetchRecordsDelegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fetchFromCursor(Cursor cursor, RecordFilter recordFilter, long l) {
            block11: {
                Logger.debug(AndroidBrowserRepositorySession.LOG_TAG, "Fetch from cursor:");
                if (cursor.moveToFirst()) break block11;
                this.delegate.onFetchCompleted(l);
                Logger.trace(AndroidBrowserRepositorySession.LOG_TAG, "Closing cursor after fetch.");
                cursor.close();
                return;
            }
            try {
                try {
                    while (!cursor.isAfterLast()) {
                        Record record = AndroidBrowserRepositorySession.this.retrieveDuringFetch(cursor);
                        if (record != null) {
                            if (recordFilter == null || !recordFilter.excludeRecord(record)) {
                                Logger.trace(AndroidBrowserRepositorySession.LOG_TAG, "Processing record " + record.guid);
                                this.delegate.onFetchedRecord(AndroidBrowserRepositorySession.this.transformRecord(record));
                            } else {
                                Logger.debug(AndroidBrowserRepositorySession.LOG_TAG, "Skipping filtered record " + record.guid);
                            }
                        }
                        cursor.moveToNext();
                    }
                    this.delegate.onFetchCompleted(l);
                }
                catch (NoGuidForIdException noGuidForIdException) {
                    Logger.warn(AndroidBrowserRepositorySession.LOG_TAG, "No GUID for ID.", noGuidForIdException);
                    this.delegate.onFetchFailed(noGuidForIdException, null);
                }
                catch (Exception exception) {
                    Logger.warn(AndroidBrowserRepositorySession.LOG_TAG, "Exception in fetchFromCursor.", exception);
                    this.delegate.onFetchFailed(exception, null);
                    Logger.trace(AndroidBrowserRepositorySession.LOG_TAG, "Closing cursor after fetch.");
                    cursor.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                Logger.trace(AndroidBrowserRepositorySession.LOG_TAG, "Closing cursor after fetch.");
                cursor.close();
            }
        }
    }

    class GuidsSinceRunnable
    implements Runnable {
        private final RepositorySessionGuidsSinceDelegate delegate;
        private final long timestamp;

        public GuidsSinceRunnable(long l, RepositorySessionGuidsSinceDelegate repositorySessionGuidsSinceDelegate) {
            this.timestamp = l;
            this.delegate = repositorySessionGuidsSinceDelegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<String> arrayList;
            Cursor cursor;
            if (!AndroidBrowserRepositorySession.this.isActive()) {
                this.delegate.onGuidsSinceFailed(new InactiveSessionException(null));
                return;
            }
            try {
                cursor = AndroidBrowserRepositorySession.this.dbHelper.getGUIDsSince(this.timestamp);
            }
            catch (Exception exception) {
                this.delegate.onGuidsSinceFailed(exception);
                return;
            }
            try {
                if (!cursor.moveToFirst()) {
                    this.delegate.onGuidsSinceSucceeded(new String[0]);
                    return;
                }
                arrayList = new ArrayList<String>();
                while (!cursor.isAfterLast()) {
                    arrayList.add(RepoUtils.getStringFromCursor(cursor, "guid"));
                    cursor.moveToNext();
                }
            }
            finally {
                Logger.debug(AndroidBrowserRepositorySession.LOG_TAG, "Closing cursor after guidsSince.");
                cursor.close();
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            this.delegate.onGuidsSinceSucceeded(stringArray);
        }
    }
}

