/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.R;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.tabs.TabHistoryPage;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.FaviconView;

public class TabHistoryItemRow
extends RelativeLayout {
    private final FaviconView favicon;
    private final TextView title;
    private final ImageView timeLineTop;
    private final ImageView timeLineBottom;
    private final OnFaviconLoadedListener faviconListener;
    private int loadFaviconJobId = 0;

    public TabHistoryItemRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        LayoutInflater.from((Context)context).inflate(R.layout.tab_history_item_row, (ViewGroup)this);
        this.favicon = (FaviconView)this.findViewById(R.id.tab_history_icon);
        this.title = (TextView)this.findViewById(R.id.tab_history_title);
        this.timeLineTop = (ImageView)this.findViewById(R.id.tab_history_timeline_top);
        this.timeLineBottom = (ImageView)this.findViewById(R.id.tab_history_timeline_bottom);
        this.faviconListener = new UpdateViewFaviconLoadedListener(this.favicon);
    }

    public void update(TabHistoryPage tabHistoryPage, boolean bl, boolean bl2) {
        ThreadUtils.assertOnUiThread();
        this.timeLineTop.setVisibility(bl ? 4 : 0);
        this.timeLineBottom.setVisibility(bl2 ? 4 : 0);
        this.title.setText((CharSequence)tabHistoryPage.getTitle());
        if (tabHistoryPage.isSelected()) {
            this.title.setTypeface(null, 1);
        } else {
            this.title.setTypeface(null, 0);
        }
        this.favicon.setEnabled(tabHistoryPage.isSelected());
        this.favicon.clearImage();
        Favicons.cancelFaviconLoad(this.loadFaviconJobId);
        this.loadFaviconJobId = Favicons.getSizedFaviconForPageFromLocal(this.getContext(), tabHistoryPage.getUrl(), this.faviconListener);
    }

    private static class UpdateViewFaviconLoadedListener
    implements OnFaviconLoadedListener {
        private final WeakReference<FaviconView> view;

        public UpdateViewFaviconLoadedListener(FaviconView faviconView) {
            this.view = new WeakReference<FaviconView>(faviconView);
        }

        @Override
        public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
            FaviconView faviconView = (FaviconView)((Object)this.view.get());
            if (faviconView == null) {
                return;
            }
            if (bitmap == null) {
                faviconView.showDefaultFavicon();
                return;
            }
            faviconView.updateImage(bitmap, string3);
        }
    }
}

