/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.HardwareUtils;

public abstract class AnchoredPopup
extends PopupWindow {
    private View mAnchor;
    private OnShowListener mOnShowListener;
    protected LinearLayout mContent;
    protected boolean mInflated;
    protected final Context mContext;

    public AnchoredPopup(Context context) {
        super(context);
        this.mContext = context;
        this.setAnimationStyle(R.style.PopupAnimation);
    }

    protected void init() {
        this.setBackgroundDrawable((Drawable)new BitmapDrawable(this.mContext.getResources()));
        this.setOutsideTouchable(true);
        int n = (int)this.mContext.getResources().getDimension(R.dimen.doorhanger_width);
        this.setWindowLayoutMode(0, -2);
        this.setWidth(n);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        View view = layoutInflater.inflate(R.layout.anchored_popup, null);
        this.setContentView(view);
        this.mContent = (LinearLayout)view.findViewById(R.id.content);
        this.mInflated = true;
    }

    public void setAnchor(View view) {
        this.mAnchor = view;
    }

    public void setOnShowListener(OnShowListener onShowListener) {
        this.mOnShowListener = onShowListener;
    }

    public void show() {
        boolean bl;
        if (!this.mInflated) {
            throw new IllegalStateException("ArrowPopup#init() must be called before ArrowPopup#show()");
        }
        if (this.mOnShowListener != null) {
            this.mOnShowListener.onDoorHangerShow();
        }
        int[] nArray = new int[2];
        if (this.mAnchor != null) {
            this.mAnchor.getLocationInWindow(nArray);
        }
        int n = this.mContext.getResources().getDimensionPixelOffset(R.dimen.doorhanger_offsetY);
        View view = ((Activity)this.mContext).getWindow().getDecorView();
        if (AppConstants.Versions.preHC) {
            this.setWidth(view.getWidth());
            n = this.mContext.getResources().getDimensionPixelOffset(R.dimen.doorhanger_GB_offsetY);
            if (this.mAnchor == null) {
                this.mAnchor = view;
            }
            this.showAsDropDown(this.mAnchor, 0, -n);
            return;
        }
        boolean bl2 = bl = this.mAnchor != null && nArray[1] > 0;
        if (HardwareUtils.isTablet()) {
            if (bl) {
                this.showAsDropDown(this.mAnchor, 0, 0);
            } else {
                int n2 = this.mContext.getResources().getDimensionPixelOffset(R.dimen.doorhanger_offsetX);
                this.showAtLocation(view, 51, n2, n);
            }
        } else {
            View view2 = bl ? this.mAnchor : view;
            this.showAtLocation(view2, 49, 0, n);
        }
    }

    public static interface OnShowListener {
        public void onDoorHangerShow();
    }
}

