/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.common.telemetry;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mozilla.gecko.background.common.log.Logger;

public class TelemetryWrapper {
    private static final String LOG_TAG = TelemetryWrapper.class.getSimpleName();
    private static volatile Method mAddToHistogram;

    public static void addToHistogram(String string2, int n) {
        if (mAddToHistogram == null) {
            try {
                Class<?> clazz = Class.forName("org.mozilla.gecko.Telemetry");
                mAddToHistogram = clazz.getMethod("addToHistogram", String.class, Integer.TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.warn(LOG_TAG, "org.mozilla.gecko.Telemetry class found!");
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logger.warn(LOG_TAG, "org.mozilla.gecko.Telemetry.addToHistogram(String, int) method not found!");
                return;
            }
        }
        if (mAddToHistogram != null) {
            try {
                mAddToHistogram.invoke(null, string2, n);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                Logger.warn(LOG_TAG, "Got exception invoking telemetry!");
            }
        }
    }
}

