/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mozilla.gecko.background.healthreport.HealthReportDatabaseStorage;
import org.mozilla.gecko.background.healthreport.HealthReportDatabases;
import org.mozilla.gecko.background.healthreport.HealthReportStorage;

public class HealthReportProvider
extends ContentProvider {
    private HealthReportDatabases databases;
    private static final UriMatcher uriMatcher = new UriMatcher(-1);
    public static final String HEALTH_AUTHORITY = "org.mozilla.fennec.health";
    private static final int ENVIRONMENTS_ROOT = 10;
    private static final int EVENTS_ROOT = 11;
    private static final int EVENTS_RAW_ROOT = 12;
    private static final int FIELDS_ROOT = 13;
    private static final int MEASUREMENTS_ROOT = 14;
    private static final int EVENTS_FIELD_GENERIC = 20;
    private static final int EVENTS_FIELD_COUNTER = 21;
    private static final int EVENTS_FIELD_LAST = 22;
    private static final int ENVIRONMENT_DETAILS = 30;
    private static final int FIELDS_MEASUREMENT = 31;

    public HealthReportDatabaseStorage getProfileStorage(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("profilePath must be provided.");
        }
        return this.databases.getDatabaseHelperForProfile(new File(string2));
    }

    private HealthReportDatabaseStorage getProfileStorageForUri(Uri uri) {
        String string2 = uri.getQueryParameter("profilePath");
        return this.getProfileStorage(string2);
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.databases.closeDatabaseHelpers();
    }

    public String getType(Uri uri) {
        return null;
    }

    public boolean onCreate() {
        this.databases = new HealthReportDatabases(this.getContext());
        return true;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        int n = uriMatcher.match(uri);
        HealthReportDatabaseStorage healthReportDatabaseStorage = this.getProfileStorageForUri(uri);
        switch (n) {
            case 31: {
                List list = uri.getPathSegments();
                String string2 = (String)list.get(1);
                int n2 = Integer.parseInt((String)list.get(2));
                healthReportDatabaseStorage.ensureMeasurementInitialized(string2, n2, this.getFieldSpecs(contentValues));
                return uri;
            }
            case 10: {
                HealthReportDatabaseStorage.DatabaseEnvironment databaseEnvironment = healthReportDatabaseStorage.getEnvironment();
                databaseEnvironment.init(contentValues);
                return ContentUris.withAppendedId((Uri)uri, (long)databaseEnvironment.register());
            }
            case 20: {
                long l = HealthReportProvider.getTimeFromUri(uri);
                int n3 = healthReportDatabaseStorage.getDay(l);
                int n4 = HealthReportProvider.getEnvironmentFromUri(uri);
                HealthReportStorage.Field field = HealthReportProvider.getFieldFromUri(healthReportDatabaseStorage, uri);
                if (!contentValues.containsKey("value")) {
                    throw new IllegalArgumentException("Must provide ContentValues including 'value' key.");
                }
                Object object = contentValues.get("value");
                if (object instanceof Integer || object instanceof Long) {
                    healthReportDatabaseStorage.recordDailyDiscrete(n4, n3, field.getID(), (Integer)object);
                } else if (object instanceof String) {
                    healthReportDatabaseStorage.recordDailyDiscrete(n4, n3, field.getID(), (String)object);
                } else {
                    healthReportDatabaseStorage.recordDailyDiscrete(n4, n3, field.getID(), object.toString());
                }
                return uri;
            }
        }
        throw new IllegalArgumentException("Unknown insert URI");
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        int n = uriMatcher.match(uri);
        if (n != 21 && n != 22) {
            throw new IllegalArgumentException("Must provide operation for update.");
        }
        HealthReportDatabaseStorage healthReportDatabaseStorage = this.getProfileStorageForUri(uri);
        long l = HealthReportProvider.getTimeFromUri(uri);
        int n2 = healthReportDatabaseStorage.getDay(l);
        int n3 = HealthReportProvider.getEnvironmentFromUri(uri);
        HealthReportStorage.Field field = HealthReportProvider.getFieldFromUri(healthReportDatabaseStorage, uri);
        switch (n) {
            case 21: {
                int n4 = contentValues.containsKey("value") ? contentValues.getAsInteger("value") : 1;
                healthReportDatabaseStorage.incrementDailyCount(n3, n2, field.getID(), n4);
                return 1;
            }
            case 22: {
                Object object = contentValues.get("value");
                if (object instanceof Integer || object instanceof Long) {
                    healthReportDatabaseStorage.recordDailyLast(n3, n2, field.getID(), (Integer)object);
                } else if (object instanceof String) {
                    healthReportDatabaseStorage.recordDailyLast(n3, n2, field.getID(), (String)object);
                } else {
                    healthReportDatabaseStorage.recordDailyLast(n3, n2, field.getID(), object.toString());
                }
                return 1;
            }
        }
        return 0;
    }

    public int delete(Uri uri, String string2, String[] stringArray) {
        int n = uriMatcher.match(uri);
        HealthReportDatabaseStorage healthReportDatabaseStorage = this.getProfileStorageForUri(uri);
        switch (n) {
            case 14: {
                healthReportDatabaseStorage.deleteMeasurements();
                return 1;
            }
            case 10: {
                healthReportDatabaseStorage.deleteEnvironments();
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        int n = uriMatcher.match(uri);
        HealthReportDatabaseStorage healthReportDatabaseStorage = this.getProfileStorageForUri(uri);
        switch (n) {
            case 11: {
                return healthReportDatabaseStorage.getEventsSince(HealthReportProvider.getTimeFromUri(uri));
            }
            case 12: {
                return healthReportDatabaseStorage.getRawEventsSince(HealthReportProvider.getTimeFromUri(uri));
            }
            case 14: {
                return healthReportDatabaseStorage.getMeasurementVersions();
            }
            case 13: {
                return healthReportDatabaseStorage.getFieldVersions();
            }
        }
        List list = uri.getPathSegments();
        switch (n) {
            case 30: {
                return healthReportDatabaseStorage.getEnvironmentRecordForID(Integer.parseInt((String)list.get(1), 10));
            }
            case 31: {
                String string4 = (String)list.get(1);
                int n2 = Integer.parseInt((String)list.get(2));
                return healthReportDatabaseStorage.getFieldVersions(string4, n2);
            }
        }
        return null;
    }

    private static long getTimeFromUri(Uri uri) {
        String string2 = uri.getQueryParameter("time");
        if (string2 == null) {
            return System.currentTimeMillis();
        }
        return Long.parseLong(string2, 10);
    }

    private static int getEnvironmentFromUri(Uri uri) {
        return Integer.parseInt((String)uri.getPathSegments().get(1), 10);
    }

    private static HealthReportStorage.Field getFieldFromUri(HealthReportStorage healthReportStorage, Uri uri) {
        List list = uri.getPathSegments();
        String string2 = (String)list.get(2);
        int n = Integer.parseInt((String)list.get(3), 10);
        String string3 = (String)list.get(4);
        return healthReportStorage.getField(string2, n, string3);
    }

    private HealthReportStorage.MeasurementFields getFieldSpecs(ContentValues contentValues) {
        final ArrayList<HealthReportStorage.MeasurementFields.FieldSpec> arrayList = new ArrayList<HealthReportStorage.MeasurementFields.FieldSpec>(contentValues.size());
        for (Map.Entry entry : contentValues.valueSet()) {
            arrayList.add(new HealthReportStorage.MeasurementFields.FieldSpec((String)entry.getKey(), (Integer)entry.getValue()));
        }
        return new HealthReportStorage.MeasurementFields(){

            @Override
            public Iterable<HealthReportStorage.MeasurementFields.FieldSpec> getFields() {
                return arrayList;
            }
        };
    }

    static {
        uriMatcher.addURI(HEALTH_AUTHORITY, "environments/", 10);
        uriMatcher.addURI(HEALTH_AUTHORITY, "events/", 11);
        uriMatcher.addURI(HEALTH_AUTHORITY, "rawevents/", 12);
        uriMatcher.addURI(HEALTH_AUTHORITY, "fields/", 13);
        uriMatcher.addURI(HEALTH_AUTHORITY, "measurements/", 14);
        uriMatcher.addURI(HEALTH_AUTHORITY, "events/#/*/#/*", 20);
        uriMatcher.addURI(HEALTH_AUTHORITY, "events/#/*/#/*/counter", 21);
        uriMatcher.addURI(HEALTH_AUTHORITY, "events/#/*/#/*/last", 22);
        uriMatcher.addURI(HEALTH_AUTHORITY, "environments/#", 30);
        uriMatcher.addURI(HEALTH_AUTHORITY, "fields/*/#", 31);
    }
}

