/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.tasks;

import android.content.Context;
import android.widget.Toast;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.fxa.tasks.FxAccountSetupTask;

public class FxAccountUnlockCodeResender {
    private static final String LOG_TAG = FxAccountUnlockCodeResender.class.getSimpleName();

    public static void resendUnlockCode(Context context, String string2, byte[] byArray) {
        ResendUnlockCodeDelegate resendUnlockCodeDelegate = new ResendUnlockCodeDelegate(context);
        if (byArray == null) {
            resendUnlockCodeDelegate.handleError(new IllegalArgumentException("emailUTF8 must not be null"));
            return;
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string2, executorService);
        new FxAccountUnlockCodeTask(context, byArray, fxAccountClient20, resendUnlockCodeDelegate).execute(new Void[0]);
    }

    private static class ResendUnlockCodeDelegate
    implements FxAccountClient10.RequestDelegate<Void> {
        public final Context context;

        public ResendUnlockCodeDelegate(Context context) {
            this.context = context;
        }

        @Override
        public void handleError(Exception exception) {
            Logger.warn(LOG_TAG, "Got exception requesting fresh unlock code; ignoring.", exception);
            Toast.makeText((Context)this.context, (int)R.string.fxaccount_unlock_code_not_sent, (int)1).show();
        }

        @Override
        public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            this.handleError(fxAccountClientRemoteException);
        }

        @Override
        public void handleSuccess(Void void_) {
            Toast.makeText((Context)this.context, (int)R.string.fxaccount_unlock_code_sent, (int)0).show();
        }
    }

    private static class FxAccountUnlockCodeTask
    extends FxAccountSetupTask<Void> {
        protected static final String LOG_TAG = FxAccountUnlockCodeTask.class.getSimpleName();
        protected final byte[] emailUTF8;

        public FxAccountUnlockCodeTask(Context context, byte[] byArray, FxAccountClient fxAccountClient, FxAccountClient10.RequestDelegate<Void> requestDelegate) {
            super(context, null, fxAccountClient, null, requestDelegate);
            this.emailUTF8 = byArray;
        }

        protected FxAccountSetupTask.InnerRequestDelegate<Void> doInBackground(Void ... voidArray) {
            try {
                this.client.resendUnlockCode(this.emailUTF8, this.innerDelegate);
                this.latch.await();
                return this.innerDelegate;
            }
            catch (Exception exception) {
                Logger.error(LOG_TAG, "Got exception signing in.", exception);
                this.delegate.handleError(exception);
                return null;
            }
        }
    }
}

