/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.SearchEngine;
import org.mozilla.gecko.widget.TwoWayView;

public class SearchEngineBar
extends TwoWayView
implements AdapterView.OnItemClickListener {
    private static final String LOGTAG = "Gecko" + SearchEngineBar.class.getSimpleName();
    private final SearchEngineAdapter adapter = new SearchEngineAdapter();
    private OnSearchBarClickListener onSearchBarClickListener;

    public SearchEngineBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setAdapter((ListAdapter)this.adapter);
        this.setOnItemClickListener(this);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        if (this.onSearchBarClickListener == null) {
            throw new IllegalStateException(OnSearchBarClickListener.class.getSimpleName() + " is not initialized");
        }
        SearchEngine searchEngine = this.adapter.getItem(n);
        this.onSearchBarClickListener.onSearchBarClickListener(searchEngine);
    }

    protected void setOnSearchBarClickListener(OnSearchBarClickListener onSearchBarClickListener) {
        this.onSearchBarClickListener = onSearchBarClickListener;
    }

    protected void setSearchEngines(List<SearchEngine> list) {
        this.adapter.setSearchEngines(list);
    }

    public static class SearchEngineBarContainer
    extends FrameLayout {
        private final Paint dividerPaint = new Paint();

        public SearchEngineBarContainer(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.dividerPaint.setColor(this.getResources().getColor(R.color.divider_light));
        }

        public void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            canvas.drawLine(0.0f, 0.0f, (float)this.getWidth(), 0.0f, this.dividerPaint);
        }
    }

    public class SearchEngineAdapter
    extends BaseAdapter {
        List<SearchEngine> searchEngines = new ArrayList<SearchEngine>();

        public void setSearchEngines(List<SearchEngine> list) {
            this.searchEngines = list;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.searchEngines.size();
        }

        public SearchEngine getItem(int n) {
            return this.searchEngines.get(n);
        }

        public long getItemId(int n) {
            return n;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            View view2 = view == null ? LayoutInflater.from((Context)SearchEngineBar.this.getContext()).inflate(R.layout.search_engine_bar_item, viewGroup, false) : view;
            ImageView imageView = (ImageView)view2.findViewById(R.id.search_engine_icon);
            SearchEngine searchEngine = this.searchEngines.get(n);
            imageView.setImageBitmap(searchEngine.getIcon());
            View view3 = view2.findViewById(R.id.search_engine_icon_container);
            String string2 = SearchEngineBar.this.getResources().getString(R.string.search_bar_item_desc, new Object[]{searchEngine.getEngineIdentifier()});
            view3.setContentDescription((CharSequence)string2);
            return view2;
        }
    }

    public static interface OnSearchBarClickListener {
        public void onSearchBarClickListener(SearchEngine var1);
    }
}

